{*
* Template Prestashop DiscountShop
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*}

{capture name=path}{l s='Product Comparison'}{/capture}

{include file="$tpl_dir./breadcrumb.tpl"}
<h1>{l s='Product Comparison'}</h1>

{if $hasProduct}
<div class="products_block">
	<table id="product_comparison">
		<tr>
			<td class="td_empty compare_extra_information">
				{if isset($HOOK_COMPARE_EXTRA_INFORMATION) && $HOOK_COMPARE_EXTRA_INFORMATION}{$HOOK_COMPARE_EXTRA_INFORMATION}{/if}
			</td>
			{assign var='taxes_behavior' value=false}
			{if $use_taxes && (!$priceDisplay  || $priceDisplay == 2)}
				{assign var='taxes_behavior' value=true}
			{/if}
		{foreach from=$products item=product name=for_products}
			{assign var='replace_id' value=$product->id|cat:'|'}

			<td style="width:{$width}%" class="ajax_block_product comparison_infos">
				{assign var='specific_prices' value=$product->specificPrice}
				<h5><a href="{$product->getLink()}" title="{$product->name|escape:'html':'UTF-8'}">{$product->name|truncate:40:'...'|escape:'html':'UTF-8'}</a></h5>
				<a href="{$product->getLink()}" title="{$product->name|escape:'html':'UTF-8'}" class="product_image">
					<img class="replace-2x" src="{$link->getImageLink($product->link_rewrite, $product->id_image, 'home')}" alt="{$product->name|escape:'html':'UTF-8'}" {if isset($imgHomeSize)}style="width:{$imgHomeSize.width}px"{/if} />
				</a>
				<div class="comparison_product_infos">
					<div class="comparison_prices_container">
					{if isset($product->on_sale) && $product->on_sale && isset($product->show_price) && $product->show_price && !$PS_CATALOG_MODE}<p class="comparison_reduction">{l s='On sale'} <span>{if isset($specific_prices.reduction_type) && $specific_prices.reduction_type == 'percentage'}-{$specific_prices.reduction*100}%{/if}{if isset($specific_prices.reduction_type) && $specific_prices.reduction_type == 'amount'}-{($specific_prices.reduction|round:2*100/($product->getPrice($taxes_behavior)+$product->specificPrice.reduction))|round:0}%{/if}</span></p>
					{elseif isset($product->specificPrice.reduction) && $product->specificPrice.reduction && isset($product->show_price) && $product->show_price && !$PS_CATALOG_MODE}<p class="comparison_reduction">{l s='Promotion'} <span>{if isset($specific_prices.reduction_type) && $specific_prices.reduction_type == 'percentage'}-{$specific_prices.reduction*100}%{/if}{if isset($specific_prices.reduction_type) && $specific_prices.reduction_type == 'amount'}-{($specific_prices.reduction|round:2*100/($product->getPrice($taxes_behavior)+$product->specificPrice.reduction))|round:0}%{/if}</span></p>{/if}
					{if isset($product->show_price) && $product->show_price && !$PS_CATALOG_MODE}
						<p class="comparison_price_container">
							<span class="price">{if version_compare($smarty.const._PS_VERSION_,'1.6','>=')}{hook h="displayProductPriceBlock" product=$product type="before_price"}{/if}{convertPrice price=$product->getPrice($taxes_behavior)}</span>
							{if isset($product->on_sale) && $product->on_sale OR isset($product->specificPrice.reduction) && $product->specificPrice.reduction}<span class="old_price_display">{if version_compare($smarty.const._PS_VERSION_,'1.6','>=')}{hook h="displayProductPriceBlock" product=$product type="old_price"}{/if}<span class="old_price">{if isset($specific_prices.reduction_type) && $specific_prices.reduction_type == 'percentage'}{convertPrice price=$product->getPrice($taxes_behavior)/(1-$product->specificPrice.reduction)}{/if}{if isset($specific_prices.reduction_type) && $specific_prices.reduction_type == 'amount'}{convertPrice price=$product->getPrice($taxes_behavior)+($product->specificPrice.reduction)}{/if}</span></span>{/if}
						</p>
						{if version_compare($smarty.const._PS_VERSION_,'1.6','>=')}
							<div class="aeuc_block">
								{hook h="displayProductPriceBlock" product=$product type="price"}
								{hook h="displayProductPriceBlock" product=$product type="weight"}
							</div>
						{/if}
						{if !empty($product->unity) && $product->unit_price_ratio > 0.000000}
								{math equation="pprice / punit_price"  pprice=$product->getPrice($taxes_behavior)  punit_price=$product->unit_price_ratio assign=unit_price}
							<p class="comparison_unit_price">{convertPrice price=$unit_price}&nbsp;{l s='per'}&nbsp;{$product->unity|escape:'html':'UTF-8'}</p>
						{else}
						&nbsp;
						{/if}
					{/if}
					</div>
					<a class="cmp_remove" href="{$request_uri|replace:$replace_id:''}">{l s='Remove this product'}</a>
				</div>
			</td>
		{/foreach}
		</tr>

		<tr class="comparison_header">
			<td>
				{l s='Features'}
			</td>
			{section loop=$products|count step=1 start=0 name=td}
			<td></td>
			{/section}
		</tr>

		{if $ordered_features}
		{foreach from=$ordered_features item=feature}
		<tr>
			{cycle values='comparison_feature_odd,comparison_feature_even' assign='classname'}
			<td class="{$classname}" >
				<strong>{$feature.name|escape:'html':'UTF-8'}</strong>
			</td>

			{foreach from=$products item=product name=for_products}
				{assign var='product_id' value=$product->id}
				{assign var='feature_id' value=$feature.id_feature}
				{if isset($product_features[$product_id])}
					{assign var='tab' value=$product_features[$product_id]}
					<td style="width:{$width}%" class="{$classname} comparison_infos">{$tab[$feature_id]|escape:'html':'UTF-8'}</td>
				{else}
					<td style="width:{$width}%" class="{$classname} comparison_infos"></td>
				{/if}
			{/foreach}
		</tr>
		{/foreach}
		{else}
			<tr>
				<td></td>
				<td colspan="{$products|@count + 1}">{l s='No features to compare'}</td>
			</tr>
		{/if}

		{*{if isset($HOOK_EXTRA_PRODUCT_COMPARISON) && $HOOK_EXTRA_PRODUCT_COMPARISON}{$HOOK_EXTRA_PRODUCT_COMPARISON}{/if}*}
	</table>
</div>
{else}
	<p class="warning">{l s='There are no products selected for comparison.'}</p>
{/if}