{*
* Template Prestashop DiscountShop
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*}

{capture name=path}<a href="{$link->getPageLink('my-account.php', true)}" title="{l s='My account'}">{l s='My account'}</a><span class="navigation-pipe">{$navigationPipe}</span>{l s='Credit slips'}{/capture}
{include file="$tpl_dir./breadcrumb.tpl"}

<h1>{l s='Credit slips'}</h1>
<div class="block-center" id="block-history">
	{if $ordersSlip && count($ordersSlip)}
	<table id="order-list" class="std">
		<thead>
			<tr>
				<th class="credit_number first_item">{l s='Credit slip'}</th>
				<th class="credit_order item">{l s='Order'}</th>
				<th class="credit_date item">{l s='Date issued'}</th>
				<th class="credit_slip last_item center">{l s='View credit slip'}</th>
			</tr>
		</thead>
		<tbody>
		{foreach from=$ordersSlip item=slip name=myLoop}
			<tr class="{if $smarty.foreach.myLoop.first}first_item{elseif $smarty.foreach.myLoop.last}last_item{else}item{/if}{if $smarty.foreach.myLoop.index % 2} alternate_item{/if}">
				<td class="credit_number bold"><span class="color-myaccount">{l s='#'}{$slip.id_order_slip|string_format:"%06d"}</span></td>
				<td class="credit_order"><a class="color-myaccount" href="javascript:showOrder(1, {$slip.id_order|intval}, 'order-detail.php');">{l s='#'}{$slip.id_order|string_format:"%06d"}</a></td>
				<td class="credit_date bold">{dateFormat date=$slip.date_add full=0}</td>
				<td class="credit_slip center">
					<a href="{$link->getPageLink('pdf-order-slip.php', true)}?id_order_slip={$slip.id_order_slip|intval}" title="{l s='Credit slip'} {l s='#'}{$slip.id_order_slip|string_format:"%06d"}"><i class="icon-file-text"></i></a>
				</td>
			</tr>
		{/foreach}
		</tbody>
	</table>
	<div id="block-order-detail" class="hidden">&nbsp;</div>
	{else}
		<p class="warning">{l s='You have not received any credit slips.'}</p>
	{/if}
</div>

<ul class="footer_links">
	<li><a href="{$link->getPageLink('my-account.php', true)}" title="{l s='Back to your account'}">{l s='Back to your account'}</a></li>
	<li><a href="{$base_dir_ssl}" title="{l s='Home'}">{l s='Home'}</a></li>
</ul>