<?php
class USPSShippingServices extends ObjectModel
{
	public $id;
	public $id_carrier;
	public $class_id;
	public $service_name;

	public static $definition = array(
		'table' => 'wk_usps_shipping_services',
		'primary' => 'id',
		'fields' => array(
			'id_carrier'   => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
			'class_id' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => true),
			'service_name' => array('type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => true)
		)
	);

	public function getUSPSServices()
	{
		return DB::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.'wk_usps_shipping_services`');
	}

	public function updateIdCarrierById($id_carrier, $id)
	{
		if ($id)
			return DB::getInstance()->update('wk_usps_shipping_services', array('id_carrier' => (int)$id_carrier), '`id` = '.(int)$id);
		return false;
	}

	public function updateIdCarrierByIdCarrier($new_id_carrier, $id_carrier)
	{
		if ($id_carrier)
			return DB::getInstance()->update('wk_usps_shipping_services', array('id_carrier' => (int)$new_id_carrier), '`id_carrier` = '.(int)$id_carrier);
		return false;
	}

	public function getUSPSCarriersByIdCarrier($id_carrier)
	{
		if ($id_carrier)
			return DB::getInstance()->getRow('SELECT * FROM `'._DB_PREFIX_.'wk_usps_shipping_services` WHERE `id_carrier` = '.(int)$id_carrier);
		return false;
	}

	public static function getUSPSCarriersByCarrierName($service_name)
    {
        if ($service_name) {
            return DB::getInstance()->getRow(
                'SELECT * FROM `'._DB_PREFIX_.'wk_usps_shipping_services`
                WHERE `service_name` = \''.pSQL($service_name).'\''
            );
        }

        return false;
    }
}
?>