<?php
/**
* Order Approval.
*
* NOTICE OF LICENSE
*
* This product is licensed for one customer to use on one installation (test stores and multishop included).
* Site developer has the right to modify this module to suit their needs, but can not redistribute the module in
* whole or in part. Any other use of this module constitues a violation of the user agreement.
*
* DISCLAIMER
*
* NO WARRANTIES OF DATA SAFETY OR MODULE SECURITY
* ARE EXPRESSED OR IMPLIED. USE THIS MODULE IN ACCORDANCE
* WITH YOUR MERCHANT AGREEMENT, KNOWING THAT VIOLATIONS OF
* PCI COMPLIANCY OR A DATA BREACH CAN COST THOUSANDS OF DOLLARS
* IN FINES AND DAMAGE A STORES REPUTATION. USE AT YOUR OWN RISK.
*
*  @author    idnovate.com <info@idnovate.com>
*  @copyright 2014 idnovate.com
*  @license   See above
*/

if (!defined('_PS_VERSION_'))
	exit;

class OrderApproval extends Module
{
	protected $success = false;
	protected $errors = array();

	public function __construct()
	{
		$this->name = 'orderapproval';
		$this->tab = 'payment_security';
		$this->version = '1.2';
		$this->author = 'idnovate.com';
		$this->module_key = '02fda980ff72dc0ebf40318b2afb7364';

		parent::__construct();

		$this->displayName = $this->l('Order approval');
		$this->description = $this->l('Approve your orders before they are validated automatically. Avoid customers to get their product if you think it\'s a fraud');
		$this->confirmUninstall = $this->l('Are you sure you want to delete the module and the related data?');

		/* Backward compatibility */
		if (version_compare(_PS_VERSION_, '1.5', '<'))
			require(_PS_MODULE_DIR_.$this->name.'/backward_compatibility/backward.php');
	}

	public function install()
	{
		if (!parent::install() || !Configuration::updateValue('ORDERAPP_LIMIT_PRODUCTS', '0') || !Configuration::updateValue('ORDERAPP_FREE_PRODUCTS', '') ||
			!Configuration::updateValue('ORDERAPP_STATE_ID', '') || !Configuration::updateValue('ORDERAPP_MINIMUM_AMOUNT', '0') ||
			!Configuration::updateValue('ORDERAPP_MINIMUM_AMOUNT_CUR', Configuration::get('PS_CURRENCY_DEFAULT')))
			return false;

		/*Override 1.4*/
		if (version_compare(_PS_VERSION_, '1.5', '<'))
			return $this->_installOverride();

		return true;
	}

	public function uninstall()
	{
		Configuration::deleteByName('ORDERAPP_LIMIT_PRODUCTS');
		Configuration::deleteByName('ORDERAPP_FREE_PRODUCTS');
		Configuration::deleteByName('ORDERAPP_STATE_ID');
		Configuration::deleteByName('ORDERAPP_MINIMUM_AMOUNT');
		Configuration::deleteByName('ORDERAPP_MINIMUM_AMOUNT_CUR');
		parent::uninstall();

		if (file_exists(dirname(__FILE__).'/../../override/classes/OrderHistory.php'))
		{
			if (md5_file(dirname(__FILE__).'/../../override/classes/OrderHistory.php') != 'e9d2a1061efda5a271023f9387703fed')
				$this->errors[] = '/override/classes/OrderHistory.php';
			else
			{
				if (!unlink(dirname(__FILE__).'/../../override/classes/OrderHistory.php'))
					$this->errors[] = '/override/classes/OrderHistory.php';
			}
		}

		if (count($this->errors))
			die('<div class="conf warn">
				<img src="../img/admin/warn2.png" />'.
				$this->l('The module was uninstalled but the following could not be deleted. Please, edit the file manually:').'<br />'.
				implode('<br />', $this->errors).
				'</div>');

		return true;
	}

	private function _installOverride()
	{
		// Make sure the environment is OK
		if (!is_dir(dirname(__FILE__).'/../../override/classes/'))
			mkdir(dirname(__FILE__).'/../../override/classes/', 0777, true);

		//Copy OrderHistory override
		if (file_exists(dirname(__FILE__).'/../../override/classes/OrderHistory.php'))
		{
			if (md5_file(dirname(__FILE__).'/override14/classes/OrderHistory.php') != 'e9d2a1061efda5a271023f9387703fed')
				$this->errors[] = '/override/classes/OrderHistory.php';
		}
		else
		{
			if (!copy(dirname(__FILE__).'/override14/classes/OrderHistory.php', dirname(__FILE__).'/../../override/classes/OrderHistory.php'))
				$this->errors[] = '/override/classes/OrderHistory.php';
		}

		if (count($this->errors))
			die('<div class="conf warn">
				<img src="../img/admin/warn2.png" />'.
				$this->l('The module was installed but the following file already exist. Please, merge the file manually:').'<br />'.
				implode('<br />', $this->errors).
				'</div>');
		return true;
	}


	public function getContent()
	{
		if (Tools::getValue('btnSubmit'))
		{
			if (!is_numeric(Tools::getValue('limit_products')))
				$this->errors[] = $this->l('Please define a numeric value at field "Leave order pending when products higher or equal than"');
			else
				Configuration::updateValue('ORDERAPP_LIMIT_PRODUCTS', Tools::getValue('limit_products'));

			Configuration::updateValue('ORDERAPP_FREE_PRODUCTS', Tools::getValue('limit_free_products'));

			if (Tools::getValue('minimum_amount') || Tools::getValue('moneda'))
			{
				if (!Validate::isPrice(Tools::getValue('minimum_amount')) || !Validate::isInt(Tools::getValue('moneda')))
					$this->errors[] = $this->l('Minimum amount or currency is not valid.');
				else
				{
					Configuration::updateValue('ORDERAPP_MINIMUM_AMOUNT', Tools::getValue('minimum_amount'));
					Configuration::updateValue('ORDERAPP_MINIMUM_AMOUNT_CUR', Tools::getValue('moneda'));
				}
			}
			else
				$this->errors[] = $this->l('Please define a minimum order amount.');

			if (!Tools::getValue('state_id'))
				$this->errors[] = $this->l('Please define a pending state');
			else
				Configuration::updateValue('ORDERAPP_STATE_ID', Tools::getValue('state_id'));

			if (count($this->errors) > 0)
				$this->success = false;
			else
				$this->success = true;
		}

		$this->context->smarty->assign(array(
			'displayName'			=> $this->displayName,
			'currencies'			=> Currency::getCurrencies(),
			'minimum_amount'		=> Configuration::get('ORDERAPP_MINIMUM_AMOUNT'),
			'moneda'				=> Configuration::get('ORDERAPP_MINIMUM_AMOUNT_CUR'),
			'limit_products'		=> Configuration::get('ORDERAPP_LIMIT_PRODUCTS'),
			'limit_free_products'	=> Configuration::get('ORDERAPP_FREE_PRODUCTS'),
			'states'				=> OrderState::getOrderStates($this->context->cookie->id_lang),
			'state_id'				=> Configuration::get('ORDERAPP_STATE_ID'),
			'success'				=> $this->success,
			'errors'				=> $this->errors,
			'oa_path' 				=> $this->_path,
		));

		if (version_compare(_PS_VERSION_, '1.5', '<'))
			return $this->display(__FILE__, 'views/templates/hook/admin.tpl');
		return $this->display(__FILE__, 'admin.tpl');
	}
}