<?php
/**
 * Author: egrove systems
 * Created by: EGS 140
 * Updated by: EGS 161
 * Updated on: 11/07/2012
 **/
class egrpayflowpropaymentModuleFrontController extends ModuleFrontController
{
	public $display_column_left = true;
	public $ssl = true;
	

	/**
	 * @see FrontController::initContent()
	 */
	public function initContent()
	{
		parent::initContent();
		$confirm = FALSE;

		global $smarty, $cart, $cookie,$currency,$link;
		
		//$id_cart = $cart->id;

		if($cart->getOrderTotal()<=0)
		{
			Tools::redirect('authentication.php?back=order.php');
		}
		$smarty->assign('PayPalAPI_Supported_Currency',1);
		$cardName ="";$cardNumber ="";$cardCode ="";$cardExpires ="";$expMonth ="";$expYear ="";
		$errors = array();
		$payAuthorize = new egrpayflowpro();
		$payAuthorize->populatePaymentVars();
		
		if (Tools::isSubmit('nextPayment'))
		{
		    $cardName = trim(Tools::getValue('cardName'));
			if(empty($cardName))
			$errors[] = Tools::displayError('The name as it appears on the card is required');
		    $cardNumber = trim(Tools::getValue('cardNumber'));
			if(empty($cardNumber))
			$errors[] = Tools::displayError('The credit card number is required');
		    $cardCode = trim(Tools::getValue('cardCode'));
			if(empty($cardCode))
			$errors[] = Tools::displayError('The cvn on the back of the credit card is required');
		    $expMonth = trim(Tools::getValue('expMonth'));
			if(empty($expMonth))
			$errors[] = Tools::displayError('The month your credit card expires is required');
		    $expYear = trim(Tools::getValue('expYear'));
			if(empty($expYear))
			$errors[] = Tools::displayError('The year your credit card expires is required');
		    if(!empty($expMonth) && !empty($expYear))
			$cardExpires = $expMonth. "/" .$expYear;
		    $smarty->assign('errors', $errors);
		    if(empty($errors))
			$confirm = TRUE;
		}
		else if(Tools::isSubmit('submitPayment'))
		{
			
			$cardName = trim(Tools::getValue('cardName'));
			$cardNumber = trim(Tools::getValue('cardNumber'));
			$cardCode = trim(Tools::getValue('cardCode'));
			$cardExpires = trim(Tools::getValue('cardExpires'));
			$expMonth = trim(Tools::getValue('expMonth'));
			$expYear = trim(Tools::getValue('expYear'));
			$response = $payAuthorize->makeCurlRequest();
			if($response=='accepted')
			{
				$customer = new Customer($cart->id_customer);
				//header("location:index.php?fc=module&module=egrpayflowpro&controller=thankyou");
				Tools::redirect('index.php?controller=order-confirmation&id_cart='.$cart->id.'&id_module='.$this->module->id.'&id_order='.$this->module->currentOrder.'&key='.$customer->secure_key);
			}
			else
			{
				$this->errors[] =$response;
			}
		}
		else
		{
			
			$paypalacceptcurrency=array("AUD","CAD","EUR","GBP","JPY","USD","NZD","CHF","HKD","SGD","SEK","DKK","PLN","NOK","HUF","CZK","ILS","MXN","BRL","MYR","PHP","TWD","THB");
			if (!in_array($currency->iso_code,$paypalacceptcurrency))
			{	
				if(Configuration::get('EGR_PAYFLOW_CURRENCY')== 0 )
				{
					$smarty->assign('PayPalAPI_Supported_Currency',0);
				}
				else
				{
					$cookie->id_currency =  Configuration::get('EGR_PAYFLOW_CURRENCY');
					$cart->id_currency = Configuration::get('EGR_PAYFLOW_CURRENCY');
					$cart->update();
					header("location:" .$_SERVER['PHP_SELF']);
				}
			}	
		}
		
		$smarty->assign(array(
		    'years' => cardYears(),
		    'months' => cardMonths(),
		));
		
		$summary = $cart->getSummaryDetails();
		$smarty->assign($summary);
		$smarty->assign(array(
		    'token' => Tools::getToken(false),
		    'voucherAllowed' => Configuration::get('PS_VOUCHERS'),
		    'HOOK_SHOPPING_CART' => Module::hookExec('shoppingCart', $summary),
		    'shippingCost' => $cart->getOrderTotal(true, 5),
		    'cardName' => $cardName,
		    'cardNumberDisplay' => "xxxx-xxxx-xxxx-".substr($cardNumber, - 4),
		    'cardNumber' => $cardNumber,
		    'cardExpires' => $cardExpires,
		    'expMonth' => $expMonth,
		    'expYear' => $expYear,
		    'cardCode' => $cardCode,
		    'self' => $_SERVER['PHP_SELF']
		));

		$smarty->assign('lanid',$cookie->id_lang);
		
		$smarty->assign('httpssl',1);
		
		/*if(Configuration::get('PS_SSL_ENABLED')) $smarty->assign('httpssl',1);
		else $smarty->assign('httpssl',0);*/
		
		if(!$confirm)
		    $this->setTemplate('payment_1.tpl');
		else
		    $this->setTemplate('confirm-payment.tpl');
	}
}
function cardMonths()
{
    for ($i = 01; $i < 13; $i++)
	$tab[] = sprintf("%02d", $i);
    return $tab;
}

function cardYears()
{
    for ($i = date('y'); $i < (date('y') + 11); $i++)
	$tab[] = $i;
    return $tab;
}
