<?php
/**
*  Template for acguevement section
* @since WP Deep Blue 1.0
*/
$page_id = wp_deep_blue_get( 'testimonial-page' );
?>
<!-- TESTIMONIALS -->
<div class="container  wp-deep-blue-section-gap wp-deep-blue-testimonials-section">
    <?php if( $page_id ): ?>
        <div class="wp-deep-blue-title-n-short-content text-center">
            <?php $sub_text = wp_deep_blue_get( 'testimonial-sub-text' ); ?>
            <span class="wp-deep-blue-sub-title-tag"><?php echo esc_html( $sub_text ); ?></span>
            <?php
                $query = new WP_Query(array(
                    'page_id' => $page_id
                ));
            ?>
            <?php while( $query->have_posts() ): $query->the_post(); ?>
                    <h2><?php the_title(); ?></h2>
            <?php endwhile; ?>
        </div>

        <br>
        <br>
        <br>
        <br>
    <?php endif; ?>

    <?php
        $pages = wp_deep_blue_get( 'testimonial-pages' );

        if( $pages ):
            $args = apply_filters( 'wp_deep_blue_testimonial_pages_args', array(
                'post_type' => 'page',
                'post__in'  => json_decode( $pages ),
                'orderby'   => 'post__in',
                'posts_per_page' => 3
            ));
            $query = new WP_Query( $args );
            $testimonials = array();
            while( $query->have_posts() ){
                $query->the_post();

                $title = wp_deep_blue_get_title_with_designation();
                $testimonials[] = array(
                    'image' => get_the_post_thumbnail_url( null, 'full' ),
                    'title' => $title[0],
                    'designation' => $title[1],
                    'excerpt' => get_the_excerpt()
                );
            }
            wp_reset_postdata();
            if( count( $testimonials ) > 0 ):
    ?>
                <div class="row wp-deep-blue-testimonial">

                    <div class="col-md-3 offset-md-2 ">
                        <div class="position-relative wp-deep-blue-user-img p-5">
                            <div class="wp-deep-blue-bracket-symbol">
                                <span></span>
                                <span></span>
                            </div>

                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 417.97 457.82">
                                <path class="cls-1" d="M9.13,131.85C36.38,63.28,201.3-84,363.13,62.91c130,118-5,276.94-58,339.94s-179.25,98.47-236-45C33.13,266.85-21.87,209.85,9.13,131.85Z" />
                            </svg>

                            <div id="wp-deep-blue-testimonials-img">
                                <?php foreach( $testimonials as $t ): ?>
                                    <div class="wp-deep-blue-testimonial-img" style="background:url('<?php echo esc_url( $t[ 'image' ] ); ?>');                                      
                                        "></div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>

                    <div class=" col-md-5 wp-deep-blue-content-wrapper">
                        <div class="wp-deep-blue-content">

                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" width="160px" viewBox="0 0 95.333 95.332" fill="#f3f6fc">
                                <path d="M30.512,43.939c-2.348-0.676-4.696-1.019-6.98-1.019c-3.527,0-6.47,0.806-8.752,1.793    c2.2-8.054,7.485-21.951,18.013-23.516c0.975-0.145,1.774-0.85,2.04-1.799l2.301-8.23c0.194-0.696,0.079-1.441-0.318-2.045    s-1.035-1.007-1.75-1.105c-0.777-0.106-1.569-0.16-2.354-0.16c-12.637,0-25.152,13.19-30.433,32.076    c-3.1,11.08-4.009,27.738,3.627,38.223c4.273,5.867,10.507,9,18.529,9.313c0.033,0.001,0.065,0.002,0.098,0.002    c9.898,0,18.675-6.666,21.345-16.209c1.595-5.705,0.874-11.688-2.032-16.851C40.971,49.307,36.236,45.586,30.512,43.939z" />
                                <path d="M92.471,54.413c-2.875-5.106-7.61-8.827-13.334-10.474c-2.348-0.676-4.696-1.019-6.979-1.019    c-3.527,0-6.471,0.806-8.753,1.793c2.2-8.054,7.485-21.951,18.014-23.516c0.975-0.145,1.773-0.85,2.04-1.799l2.301-8.23    c0.194-0.696,0.079-1.441-0.318-2.045c-0.396-0.604-1.034-1.007-1.75-1.105c-0.776-0.106-1.568-0.16-2.354-0.16    c-12.637,0-25.152,13.19-30.434,32.076c-3.099,11.08-4.008,27.738,3.629,38.225c4.272,5.866,10.507,9,18.528,9.312    c0.033,0.001,0.065,0.002,0.099,0.002c9.897,0,18.675-6.666,21.345-16.209C96.098,65.559,95.376,59.575,92.471,54.413z" />
                            </svg>
                            <div id="wp-deep-blue-user-quote">
                                <?php foreach( $testimonials as $t ): ?>
                                    <div>
                                        <div class="wp-deep-blue-quotes">
                                            <?php echo esc_html( $t[ 'excerpt' ] ); ?>
                                        </div>
                                        <div class="wp-deep-blue-user-info">
                                            <h2><?php echo esc_html( $t[ 'title' ] ); ?></h2>
                                            <p><?php echo esc_html( $t[ 'designation' ] ); ?></p>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
    <?php endif; endif; ?>
</div>