<?php
/**
* Front page slider
* @since WP Deep Blue 1.0
*
*/
$pages = wp_deep_blue_get( 'slider-pages' );

if( $pages ){
    $args = apply_filters( 'wp_deep_blue_slider_args', array(
        'post_type' => 'page',
        'post__in'  => json_decode( $pages )
    ));
    $query = new WP_Query( $args );
    $settings = apply_filters( 'wp_deep_blue_slick_slider_args', array(
        "slidesToShow"   => 1,
        "slidesToScroll" => 1,
        "autoplaySpeed"  => 3000,
        "autoplay"       => wp_deep_blue_get( 'slider-autoplay' ),
        "infinite"       => wp_deep_blue_get( 'slider-infinite' ),
        "dots"           => wp_deep_blue_get( 'slider-dots' ) 
    ));
?>
<!-- HOME PAGE BANNER SECTION-->
<div class="wp-deep-blue-banner-slider-wrapper">
    <div id="homepage-main-banner" class="wp-deep-blue-banner-slider" data-slick='<?php echo esc_attr( json_encode( $settings ) ); ?>'>
        <?php if( $query->have_posts() ): ?>
            <?php while( $query->have_posts() ): ?>
                <?php
                    $query->the_post();
                    $thumb = get_the_post_thumbnail_url( null, 'full' );
                ?>
                <div class="slider-items" style="background-image: url('<?php echo esc_url( $thumb ); ?>');">
                    <div class="container">
                        <div class="slider-caption">
                            <h2>
                                <?php the_title(); ?>
                            </h2>
                            <?php the_excerpt(); ?>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
        <?php wp_reset_postdata(); endif; ?>
    </div>

    <div class="current-slider">01</div>

    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1366.5 34.5">
        <polyline class="cls-1" fill="#fff" points="1366 0 1366 34 0 34"></polyline>
    </svg>    
</div>
<?php } ?>