<?php
/**
*  Template for CTA section
* @since WP Deep Blue 1.0
*/
?>
<div class="container">
    <div class="wp-deep-blue-newsletter">
        <div class="row">
            <?php
                $page_id = wp_deep_blue_get( 'cta-page' );

                if( $page_id ):
                    $query = new WP_Query(array(
                        'page_id' => $page_id
                    ));

                    if( $query->have_posts() ):
                        while( $query->have_posts() ): $query->the_post();
            ?>
                            <div class="col-md-6">
                                <div class="wp-deep-blue-title">
                                    <h2><?php the_title(); ?></h2>
                                    <h3><?php the_excerpt(); ?></h3>
                                </div>
                            </div>
                        <?php
                        endwhile;
                    endif;
                    wp_reset_postdata();
                endif;
            ?>

            <?php
                $shortcode = wp_deep_blue_get( 'cta-contact-form-shortcode' );
                if( '' != $shortcode ):
            ?>
                    <div class="col-md-6">
                        <div class="wp-deep-blue-form-wrapper">
                            <?php echo do_shortcode( $shortcode ); ?>
                        </div>
                    </div>
            <?php endif; ?>
        </div>
    </div>
</div>