<?php
/*
 Template Name: Team Archive
*/
 get_header(); 

get_template_part( 'template-parts/content', 'banner' );
?>
<div class="team-archive-wrapper">
    <div class="container">
        <main id="site-content" role="main">
            <div class="row">
                <div class="col-12">
                    <div id="primary" class="content-area">
                        <?php if ( have_posts() ): ?>
                            <?php
                                while ( have_posts() ){
                                    the_post();
                                    ?>
                                    <article <?php echo wp_deep_blue_schema( 'article' ); ?> id="post-<?php the_ID(); ?>" <?php post_class(); ?> >
                                        <div class="entry-content">
                                            <?php the_content(); ?>     
                                        </div><!-- .entry-content -->
                                    </article>
                                    <?php
                                }
                            ?>
                        <?php endif; ?>

                        <section class="wp-deep-blue-team-section">
                            <?php 
                                $pages = wp_deep_blue_get( 'team-pages' ); 
                                if( $pages ){
                                    $args = apply_filters( 'wp_deep_blue_team_archive_args', array(
                                        'post_type'      => 'page',
                                        'posts_per_page' => 5,
                                        'post__in'       => json_decode( $pages )
                                    ));
                                    $query = new WP_Query( $args );
                                    if( $query->have_posts() ){
                                        echo '<div class="row">';
                                        while( $query->have_posts() ){
                                            $query->the_post();
                                            $thumbnail = get_the_post_thumbnail_url( null, 'full' );
                                            $title = wp_deep_blue_get_title_with_designation();
                                    ?>
                                        <div class="col-12 col-xs-6 col-md-3 wp-deep-blue-content-wrapper">
                                            <div class="wp-deep-blue-staff">
                                                <div class="wp-deep-blue-staff-img" style="background-image: url('<?php echo esc_url( $thumbnail ); ?>')">
                                                </div>

                                                <div class="wp-deep-blue-content">
                                                    <h3>
                                                        <a href="<?php the_permalink(); ?>">
                                                            <?php echo esc_html( $title[ 0 ] ); ?>
                                                        </a>
                                                    </h3>
                                                    <p><?php echo esc_html( $title[ 1 ] ); ?></p>
                                                </div>
                                            </div>
                                        </div>
                            <?php
                                        }
                                        echo '</div>';
                                    }
                                    wp_reset_postdata();
                                }
                            ?>
                        </section>
                    </div>
                </div>
            </div>
        </main><!-- .site-main -->
    </div>
</div>  
<?php get_footer() ?>