<?php
/**
 * ------------------------------------------------------
 *  Required files for this module
 * ------------------------------------------------------
 *
 * @since WP Deep Blue 1.0
 */
function wp_deep_blue_tgm_files( $files ){

	$new_files = array(
		'class-tgm-plugin-activation.php',
	);

	return array_merge( $files, $new_files );
}
add_filter( 'wp_deep_blue_modules_tgm', 'wp_deep_blue_tgm_files' );

/**
 * ------------------------------------------------------
 *  Required plugins
 * ------------------------------------------------------
 *
 * @since WP Deep Blue 1.0
 */
function wp_deep_blue_register_required_plugins(){
	$plugins = array(
		array(
			'name'     => esc_html__( 'One Click Demo Import', 'wp-deep-blue' ),
			'slug'     => 'one-click-demo-import',
			'required' => false,
		),
		array(
			'name'     => esc_html__( 'Fansee Themes Demo Data', 'wp-deep-blue' ),
			'slug'     => 'fansee-themes-demo-data',
			'required' => false
		),
	);

	tgmpa( $plugins );
}
add_action( 'tgmpa_register', 'wp_deep_blue_register_required_plugins' );