<?php
/**
* Add custom fileds
* @since WP Deep Blue 1.0
*/
function wp_deep_blue_register_metabox(){
	add_meta_box( 
		'wp-deep-blue-meta-box', 
		esc_html__( 'Deep Blue Settings', 'wp-deep-blue' ), 
		'wp_deep_blue_render_metabox', 
		'post',
		'side'
	);

	add_meta_box( 
		'wp-deep-blue-meta-box', 
		esc_html__( 'Deep Blue Settings', 'wp-deep-blue' ), 
		'wp_deep_blue_render_metabox', 
		'page',
		'side'
	);
}
add_action( 'add_meta_boxes', 'wp_deep_blue_register_metabox' );

function wp_deep_blue_render_metabox( $post ){
	wp_nonce_field( 'wp_deep_blue_meta_nonce', 'wp_deep_blue_name_meta_nonce' );

	$sidebar_position = get_post_meta( $post->ID, 'wp-deep-blue-sidebar-position', true );
	$customizer_image = get_post_meta( $post->ID, 'wp-deep-blue-use-customizer-image-for-banner', true );

	$disable_banner   = get_post_meta( $post->ID, 'wp-deep-blue-disable-inner-banner', true );
	$disable_footer   = get_post_meta( $post->ID, 'wp-deep-blue-disable-footer-widget', true );
	?>
	<div class="wp-deep-blue-metabox-wrapper">

		<div class="wp-deep-blue-metabox-select">
			<label><?php echo esc_html__( 'Sidebar', 'wp-deep-blue' ); ?></label>
			<select name="wp-deep-blue-sidebar-position">
				<option value="show" <?php selected( 'show', $sidebar_position, true ); ?>>
					<?php esc_html_e( 'Show', 'wp-deep-blue' ); ?>
				</option>
				<option value="hide" <?php selected( 'hide', $sidebar_position, true ); ?>>
					<?php esc_html_e( 'Hide', 'wp-deep-blue' ); ?>
				</option>
			</select>
		</div>

		<div class="wp-deep-blue-metabox-checkbox">
			<label for="wp-deep-blue-use-customizer-image-for-banner">
				<?php esc_html_e( 'Use banner from customizer', 'wp-deep-blue' ); ?>
			</label>
			<input id="wp-deep-blue-use-customizer-image-for-banner" 
				type="checkbox" name="wp-deep-blue-use-customizer-image-for-banner" <?php checked( $customizer_image, 'on', true ); ?> 
			/>
		</div>

		<div class="wp-deep-blue-metabox-checkbox">
			<label for="wp-deep-blue-disable-inner-banner"><?php esc_html_e( 'Disable Banner', 'wp-deep-blue' ); ?></label>
			<input id="wp-deep-blue-disable-inner-banner" 
				type="checkbox" name="wp-deep-blue-disable-inner-banner" <?php checked( $disable_banner, 'on', true ); ?> 
			/>
		</div>

		<div class="wp-deep-blue-metabox-checkbox">
			<label for="wp-deep-blue-disable-footer-widget"><?php esc_html_e( 'Disable Footer Widget', 'wp-deep-blue' ); ?></label>
			<input id="wp-deep-blue-disable-footer-widget" 
				type="checkbox" name="wp-deep-blue-disable-footer-widget" <?php checked( $disable_footer, 'on', true ); ?> 
			/>
		</div>
	</div>
	<?php
}

function wp_deep_blue_save_metabox( $post_id ){
	      	
  	$p = wp_unslash( $_POST );
  	$is_autosave = wp_is_post_autosave( $post_id );
	$is_revision = wp_is_post_revision( $post_id );

	if ( $is_autosave || $is_revision || empty( $p ) || ! isset(  $p[ 'wp_deep_blue_name_meta_nonce' ] ) || ! wp_verify_nonce( $p[ 'wp_deep_blue_name_meta_nonce' ], 'wp_deep_blue_meta_nonce' )) {
		return;
	}

	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}

	//Don't update on Quick Edit
	if (defined('DOING_AJAX') ) {
		return $post_id;
	}

	if ( ! current_user_can( 'edit_post', $post_id ) ) {
		return;
	}

	update_post_meta( $post_id, 'wp-deep-blue-sidebar-position', sanitize_key( $p[ 'wp-deep-blue-sidebar-position' ] ) );
	update_post_meta( $post_id, 'wp-deep-blue-use-customizer-image-for-banner', sanitize_key( $p[ 'wp-deep-blue-use-customizer-image-for-banner' ] ) );
	update_post_meta( $post_id, 'wp-deep-blue-disable-inner-banner', sanitize_key( $p[ 'wp-deep-blue-disable-inner-banner' ] ) );
	update_post_meta( $post_id, 'wp-deep-blue-disable-footer-widget', sanitize_key( $p[ 'wp-deep-blue-disable-footer-widget' ] ) );

}
add_action( 'save_post', 'wp_deep_blue_save_metabox' );