<?php
/**
 * include customizer classes
 * @since WP Deep Blue 1.0
 */
function wp_deep_blue_customizer_files( $files ){

	$new_files = array(
		'class-customizer.php',
		# custom controls for customizer
		'controls/toggle/class-toggle.php',
		'controls/page-repeater/class-page-repeater.php',
		'controls/slider/class-slider.php',
		'controls/link/class-link.php',

		# theme options
		'sections/class-frontpage.php',
		'sections/class-theme-options.php',
	);

	return array_merge( $files, $new_files );
}
add_filter( 'wp_deep_blue_modules_customizer', 'wp_deep_blue_customizer_files' );

/**
 * Get theme mod
 * @since WP Deep Blue 1.0
 */
function wp_deep_blue_get( $id ){
	return WP_Deep_Blue_Customizer::get( $id );
}

/**
 * Register customizer options
 * @since WP Deep Blue 1.0
 */
function wp_deep_blue_customizer_register( $wp_customize ){

	$cus = new WP_Deep_Blue_Customizer();
	$cus->fields = array(
		array(
			'id'       => 'go-to-pro',
			'title'    => esc_html__( 'Need More Features ? - Buy Pro', 'wp-deep-blue' ),
			'type'     => 'link',
			'url'      => esc_url( 'fanseethemes.com/downloads/wp-deep-blue-pro/' ),
			'priority' => 0
		)
	);
	
	$cus->add();

	$panel = array(
		'id' => WP_Deep_Blue_Customizer::get_id( 'frontpage' ),
		'args' => array(
			'title'    => esc_html__( 'Front Page Options', 'wp-deep-blue' ),
			'priority' => 10,
		)
	);
	new WP_Deep_Blue_Frontpage_Customizer( $panel );

	$panel = array(
		'id' => WP_Deep_Blue_Customizer::get_id( 'theme-options' ),
		'args' => array(
			'title'    => esc_html__( 'Theme Options', 'wp-deep-blue' ),
			'priority' => 10,
		)
	);
	new WP_Deep_Blue_Options_Customizer( $panel );
}
add_action( 'init', 'wp_deep_blue_customizer_register' );

/**
 * enqueue scripts and styles for customizer 
 * @since WP Deep Blue 1.0
 */
function wp_deep_blue_custom_controls_script(){
	$type = WP_DEBUG ? 'min.' : ''; //min.
	$script = get_theme_file_uri( "assets/build/js/customizer.{$type}js" );
	$deps   = array( 'jquery', 'customize-base', 'wp-color-picker', 'jquery-ui-slider', 'jquery-ui-button' );
	$style  = get_theme_file_uri( "assets/build/css/customizer.{$type}css" );

	wp_enqueue_script( 'wp-deep-blue-customizer-js', $script, $deps, '1.0', true );
	wp_enqueue_style( 'wp-deep-blue-customizer-css', $style );
}
add_action( 'customize_controls_enqueue_scripts', 'wp_deep_blue_custom_controls_script', 99	);

/**
 * Modify default customizer placement
 * @since WP Deep Blue 1.0
 */
function wp_deep_blue_customize_register( $wp_customize ){
	$color_section = 'wp-deep-blue-color-section';
	$wp_customize->get_control( 'header_textcolor' )->section = $color_section;
	$wp_customize->get_control( 'background_color' )->section = $color_section;		

	$wp_customize->get_section( 'header_image' )->title = esc_html__( 'Header', 'wp-deep-blue' );
	$wp_customize->get_section( 'header_image' )->panel = 'wp-deep-blue-theme-options';
}
add_action( 'customize_register', 'wp_deep_blue_customize_register' );