<?php
/**
 * Prints dynamic styles
 * @since WP Deep Blue 1.0
 */
function wp_deep_blue_dynamic_styles(){

	#dynamic fonts
	$fonts         = wp_deep_blue_get_fonts();
	$info_fonts    = wp_deep_blue_get( 'site-info-font' );
	$body_fonts    = wp_deep_blue_get( 'body-font' );
	$heading_fonts = wp_deep_blue_get( 'heading-font' );

	#dynamic colors
	$primary_color     = wp_deep_blue_get( 'primary-color' );
	$paragraph_color   = wp_deep_blue_get( 'body-paragraph-color' );
	$link_color        = wp_deep_blue_get( 'link-color' );
	$link_hover_color  = wp_deep_blue_get( 'link-hover-color' );
	$header_text_color = get_header_textcolor();

	#banner options
	$banner_title_color = wp_deep_blue_get( 'banner-title-color' );
	$banner_bg_color    = wp_deep_blue_get( 'banner-bg-color' );
	$banner_overlay     = wp_deep_blue_get( 'banner-bg-overlay' );

	#banner height
	$banner_height_mobile  = wp_deep_blue_get( 'banner-height-mobile' );
	$banner_height_tablet  = wp_deep_blue_get( 'banner-height-tablet' );
	$banner_height_desktop = wp_deep_blue_get( 'banner-height-desktop' );
	?>
	<style type="text/css">
		<?php if(! display_header_text() ): ?>
			.site-title, .site-description{
				position: absolute;
				clip: rect(1px, 1px, 1px, 1px);
			}
		<?php endif; ?>

		.site-title, .site-title a, .site-description{
			font-family: "<?php echo esc_html( $fonts[ $info_fonts ][ 'family' ] ); ?>";
			color: #<?php echo esc_html( $header_text_color ); ?>;
		}

		body{
			font-family: "<?php echo esc_html( $fonts[ $body_fonts ][ 'family' ] ); ?>";
		}

		h1,h2,h3,h4,h5,h6, .h1, .h2, .h3, .h4, .h5, .h6, h1 a, h2 a, h3 a, h4 a, h5 a, h6 a{
			font-family: "<?php echo esc_html( $fonts[ $heading_fonts ][ 'family' ] ); ?>";
		}

		body, body p{
			color: <?php echo esc_html( $paragraph_color ); ?>;;
		
		}

		a{
			color: <?php echo esc_html( $link_color ); ?>;;
		}

		a:hover{
			color: <?php echo esc_html( $link_hover_color ); ?>;;
		}

		.wp-deep-blue-btn-primary, 
		.comment-respond .comment-form input[type="submit"], 
		.no-results.not-found a,
		.fst-scrolltop-button,
		.woocommerce button.button, 
		.woocommerce #respond input#submit, 
		.woocommerce button.button.alt, 
		.woocommerce a.button,
		.wp-deep-blue-circle-xl,
		.wp-deep-blue-bracket-symbol span:last-child:after, 
		.wp-deep-blue-bracket-symbol span:first-child:after, 
		.wp-deep-blue-bracket-symbol span:last-child:before, 
		.wp-deep-blue-bracket-symbol span:first-child:before,
		.wp-deep-blue-achievement-box,
		.wp-deep-blue-testimonial .slick-dots li.slick-active span, 
		.wp-deep-blue-banner-slider-wrapper .slick-dots li.slick-active span,
		.wp-deep-blue-main-menu > ul > li.current-menu-item > a:before, 
		.primary-menu-wrapper > ul > li.current-menu-item > a:before, 
		#primary-menu > ul > li.current-menu-item > a:before,
		.wp-deep-blue-banner-slider .slick-slide .slider-items .slider-caption:after,
		#calendar_wrap #today,
		.woocommerce-page .woocommerce-checkout #payment .wc_payment_methods,
		.no-results.not-found a, .comment-respond .comment-form input[type=submit], .wpcf7 input[type=submit], .wpcf7 button[type=submit], .wp-deep-blue-btn-primary,
		#loader-wrapper .loader-inner {
			background: <?php echo esc_html( $primary_color ); ?>;
		}		 

		.wp-deep-blue-newsletter{
			border-left-color: <?php echo esc_html( $primary_color ); ?>;
		}	

		#loader-wrapper #loader{
			border-color: <?php echo esc_html( $primary_color ); ?>;
		}		

		.widget ul li:before, 
		.widget-area .widget ul li:before,
		.wp-deep-blue-sub-title-tag,
		.wp-deep-blue-achievement-box .wp-deep-blue-content p,
		.wp-deep-blue-main-menu > ul > li.current-menu-item > a, 
		.primary-menu-wrapper > ul > li.current-menu-item > a, 
		#primary-menu > ul > li.current-menu-item > a,
		.wp-deep-blue-content h2 a:hover,
		.wp-deep-blue-service h2 a:hover,
		.wp-deep-blue-staff .wp-deep-blue-content h3 a:hover{
			color: <?php echo esc_html( $primary_color ); ?>;
		}


		.wp-deep-blue-inner-banner-wrapper .entry-title, .wp-deep-blue-inner-banner-wrapper .breadcrumb-wrapper ul li a,  .wp-deep-blue-inner-banner-wrapper .breadcrumb-wrapper ul li{
			color: <?php echo esc_html( $banner_title_color ); ?>;
		}

		.wp-deep-blue-inner-banner-wrapper{
			min-height: <?php echo esc_html( $banner_height_desktop ); ?>px;
		}

		.wp-deep-blue-inner-banner-wrapper:after{
			background-color: <?php echo esc_html( $banner_bg_color ); ?>;
			opacity: <?php echo esc_html( $banner_overlay / 10 ); ?>;
		}



		/* responsive style for tablet */

		@media (max-width: 1024px) {
		  	.wp-deep-blue-inner-banner-wrapper{
				min-height: <?php echo esc_html( $banner_height_tablet ); ?>px;
			}
		}

		/* responsive style for mobile */

		@media (max-width: 767px) {
		  	.wp-deep-blue-inner-banner-wrapper{
				min-height: <?php echo esc_html( $banner_height_mobile ); ?>px;
			}
		}

	</style>
	<?php
}
add_action( 'wp_head', 'wp_deep_blue_dynamic_styles' );