<?php
/**
* Front page template
* 
* @since WP Deep Blue 1.0
*/ 
get_header(); 

echo '<main id="site-content" role="main">';
if ( have_posts() ){
    while ( have_posts() ){
        the_post();
        $show_content = wp_deep_blue_get( 'show-content' );
        $show_content_above = wp_deep_blue_get( 'show-content-above' );

        if( $show_content && $show_content_above ){ 
            get_template_part( 'template-parts/content', 'frontpage' ); 
        }

        foreach( wp_deep_blue_get_content_order() as $template ){

            if( wp_deep_blue_get( "enable-{$template}-shortcode" ) ){
                $shortcode = wp_deep_blue_get( "{$template}-shortcode" );
                echo do_shortcode( $shortcode );
            }
                
            if( wp_deep_blue_get( "enable-{$template}" ) ){
                get_template_part( 'template-parts/front-page/' . $template );
            }
        } 

        if( $show_content && !$show_content_above ){ 
            get_template_part( 'template-parts/content', 'frontpage' ); 
        }
    }
}
echo '</main>';
get_footer();
