+(function ($) {

    var HomePage = /** @class */ (function () {

        /* Constructor function */
        function HomePage() {
            this.bannerSlider();
            this.clientSlider();
            this.testimonialsSlider();
        };


        /* Banner slider */
        HomePage.prototype.bannerSlider = function () {
            var $homeBanner = $("#homepage-main-banner");
            if ($homeBanner.length) {

                var prevArrow = `<div class="prev-arrow"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
                                <path d="M374.108,373.328c-7.829-7.792-20.492-7.762-28.284,0.067L276,443.557V20c0-11.046-8.954-20-20-20    c-11.046,0-20,8.954-20,20v423.558l-69.824-70.164c-7.792-7.829-20.455-7.859-28.284-0.067c-7.83,7.793-7.859,20.456-0.068,28.285    l104,104.504c0.006,0.007,0.013,0.012,0.019,0.018c7.792,7.809,20.496,7.834,28.314,0.001c0.006-0.007,0.013-0.012,0.019-0.018    l104-104.504C381.966,393.785,381.939,381.121,374.108,373.328z" />
                            </svg><span>Prev</span></div>`;

                var nextArrow = `<div class="next-arrow"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
                                <path d="M374.108,373.328c-7.829-7.792-20.492-7.762-28.284,0.067L276,443.557V20c0-11.046-8.954-20-20-20    c-11.046,0-20,8.954-20,20v423.558l-69.824-70.164c-7.792-7.829-20.455-7.859-28.284-0.067c-7.83,7.793-7.859,20.456-0.068,28.285    l104,104.504c0.006,0.007,0.013,0.012,0.019,0.018c7.792,7.809,20.496,7.834,28.314,0.001c0.006-0.007,0.013-0.012,0.019-0.018    l104-104.504C381.966,393.785,381.939,381.121,374.108,373.328z" />
                            </svg><span>Next</span></div> `;

                $homeBanner.slick({
                    autoplay: true,
                    dots: true,
                    speed: 800,
                    fade: true,
                    customPaging: function (slider, i) {
                        return '<span></span>';
                    },
                    prevArrow: prevArrow,
                    nextArrow: nextArrow,
                });


                $homeBanner.on('beforeChange', function (event, slick, currentSlide, nextSlide) {
                    nextSlide = nextSlide + 1;
                    nextSlide = nextSlide < 10 ? '0' + nextSlide : nextSlide;
                    $homeBanner.next().text(nextSlide);
                });

            }
        };

        HomePage.prototype.testimonialsSlider = function () {
            var $testimonialsUserImageSlider = $('#wp-deep-blue-testimonials-img');
            var $testimonialsUserQuoteSlider = $('#wp-deep-blue-user-quote');

            if ($testimonialsUserImageSlider.length) {
                $testimonialsUserImageSlider.slick({
                    autoplay: true,
                    dots: false,
                    speed: 500,
                    fade: true,
                    arrows: false,

                });
            }

            if ($testimonialsUserQuoteSlider.length) {
                $testimonialsUserQuoteSlider.slick({
                    autoplay: true,
                    dots: true,
                    speed: 500,
                    asNavFor: '#wp-deep-blue-testimonials-img',
                    customPaging: function (slider, i) {
                        return '<span></span>';
                    },
                    arrows: false,
                });
            }
        }


        /* Clinet Slider */
        HomePage.prototype.clientSlider = function () {
            var $clientSlider = $('#clients-logo');

            if ($clientSlider.length) {
                $clientSlider.slick({
                    slidesToShow: 1,
                    variableWidth: true,
                    infinite: true,
                    dots: false,
                    prevArrow: false,
                    nextArrow: false,
                    slidesToShow: 4,
                    slidesToScroll: 1,
                    autoplay: true,
                });
            }
        };

        return HomePage;
    }());



    $(document).ready(function () {
        new HomePage();
    });


    $(window).load(function () {
        $("#loader-wrapper").fadeOut(1000);
        $("#loader").fadeOut(400);
    });

})(jQuery)
