<?php
/**
 * Organic Farm: Customizer
 *
 * @subpackage Organic Farm
 * @since 1.0
 */

function organic_farm_customize_register( $wp_customize ) {

	wp_enqueue_style('customizercustom_css', esc_url( get_template_directory_uri() ). '/assets/css/customizer.css');

	// fontawesome icon-picker

	load_template( trailingslashit( get_template_directory() ) . '/inc/icon-picker.php' );

	// Add custom control.
  	require get_parent_theme_file_path( 'inc/switch/control_switch.php' );

  	require get_parent_theme_file_path( 'inc/custom-control.php' );
  	
  	// Add homepage customizer file
  	require get_template_directory() . '/inc/customizer-home-page.php';

  	// pro section
 	$wp_customize->add_section('organic_farm_pro', array(
        'title'    => __('UPGRADE ORGANIC FARM PREMIUM', 'organic-farm'),
        'priority' => 1,
    ));
    $wp_customize->add_setting('organic_farm_pro', array(
        'default'           => null,
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control(new Organic_Farm_Pro_Control($wp_customize, 'organic_farm_pro', array(
        'label'    => __('ORGANIC FARM PREMIUM', 'organic-farm'),
        'section'  => 'organic_farm_pro',
        'settings' => 'organic_farm_pro',
        'priority' => 1,
    )));

    // logo
    $wp_customize->add_setting('organic_farm_logo_max_height',array(
		'default'=> '100',
		'transport' => 'refresh',
		'sanitize_callback' => 'organic_farm_sanitize_integer'
	));
	$wp_customize->add_control(new Organic_Farm_Slider_Custom_Control( $wp_customize, 'organic_farm_logo_max_height',array(
		'label'	=> esc_html__('Logo Width','organic-farm'),
		'section'=> 'title_tagline',
		'settings'=>'organic_farm_logo_max_height',
		'input_attrs' => array(
			'reset'            => 100,
            'step'             => 1,
			'min'              => 0,
			'max'              => 250,
        ),
        'priority' => 9,
	)));
	$wp_customize->add_setting('organic_farm_logo_title',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'organic_farm_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Organic_Farm_Customizer_Customcontrol_Switch(
			$wp_customize,
			'organic_farm_logo_title',
			array(
				'settings'        => 'organic_farm_logo_title',
				'section'         => 'title_tagline',
				'label'           => __( 'Show Site Title', 'organic-farm' ),
				'choices'		  => array(
					'1'      => __( 'On', 'organic-farm' ),
					'off'    => __( 'Off', 'organic-farm' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting('organic_farm_logo_text',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => 'off',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'organic_farm_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Organic_Farm_Customizer_Customcontrol_Switch(
			$wp_customize,
			'organic_farm_logo_text',
			array(
				'settings'        => 'organic_farm_logo_text',
				'section'         => 'title_tagline',
				'label'           => __( 'Show Site Tagline', 'organic-farm' ),
				'choices'		  => array(
					'1'      => __( 'On', 'organic-farm' ),
					'off'    => __( 'Off', 'organic-farm' ),
				),
				'active_callback' => '',
			)
		)
	);

    //typography
	$wp_customize->add_section( 'organic_farm_typography_settings', array(
		'title'       => __( 'Typography', 'organic-farm' ),
		'priority'       => 3,
	) );
	$organic_farm_font_choices = array(
		'' => 'Select',
		'Source Sans Pro:400,700,400italic,700italic' => 'Source Sans Pro',
		'Open Sans:400italic,700italic,400,700' => 'Open Sans',
		'Oswald:400,700' => 'Oswald',
		'Playfair Display:400,700,400italic' => 'Playfair Display',
		'Montserrat:400,700' => 'Montserrat',
		'Raleway:400,700' => 'Raleway',
		'Droid Sans:400,700' => 'Droid Sans',
		'Lato:400,700,400italic,700italic' => 'Lato',
		'Arvo:400,700,400italic,700italic' => 'Arvo',
		'Lora:400,700,400italic,700italic' => 'Lora',
		'Merriweather:400,300italic,300,400italic,700,700italic' => 'Merriweather',
		'Oxygen:400,300,700' => 'Oxygen',
		'PT Serif:400,700' => 'PT Serif',
		'PT Sans:400,700,400italic,700italic' => 'PT Sans',
		'PT Sans Narrow:400,700' => 'PT Sans Narrow',
		'Cabin:400,700,400italic' => 'Cabin',
		'Fjalla One:400' => 'Fjalla One',
		'Francois One:400' => 'Francois One',
		'Josefin Sans:400,300,600,700' => 'Josefin Sans',
		'Libre Baskerville:400,400italic,700' => 'Libre Baskerville',
		'Arimo:400,700,400italic,700italic' => 'Arimo',
		'Ubuntu:400,700,400italic,700italic' => 'Ubuntu',
		'Bitter:400,700,400italic' => 'Bitter',
		'Droid Serif:400,700,400italic,700italic' => 'Droid Serif',
		'Roboto:400,400italic,700,700italic' => 'Roboto',
		'Open Sans Condensed:700,300italic,300' => 'Open Sans Condensed',
		'Roboto Condensed:400italic,700italic,400,700' => 'Roboto Condensed',
		'Roboto Slab:400,700' => 'Roboto Slab',
		'Yanone Kaffeesatz:400,700' => 'Yanone Kaffeesatz',
		'Rokkitt:400' => 'Rokkitt',
	);
	$wp_customize->add_setting( 'organic_farm_section_typo_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Organic_Farm_Customizer_Customcontrol_Section_Heading( $wp_customize, 'organic_farm_section_typo_heading', array(
		'label'       => esc_html__( 'Typography Settings', 'organic-farm' ),
		'section'     => 'organic_farm_typography_settings',
		'settings'    => 'organic_farm_section_typo_heading',
	) ) );
	$wp_customize->add_setting( 'organic_farm_headings_text', array(
		'sanitize_callback' => 'organic_farm_sanitize_fonts',
	));
	$wp_customize->add_control( 'organic_farm_headings_text', array(
		'type' => 'select',
		'description' => __('Select your suitable font for the headings.', 'organic-farm'),
		'section' => 'organic_farm_typography_settings',
		'choices' => $organic_farm_font_choices
	));
	$wp_customize->add_setting( 'organic_farm_body_text', array(
		'sanitize_callback' => 'organic_farm_sanitize_fonts'
	));
	$wp_customize->add_control( 'organic_farm_body_text', array(
		'type' => 'select',
		'description' => __( 'Select your suitable font for the body.', 'organic-farm' ),
		'section' => 'organic_farm_typography_settings',
		'choices' => $organic_farm_font_choices
	) );

    // Theme General Settings
    $wp_customize->add_section('organic_farm_theme_settings',array(
        'title' => __('Theme General Settings', 'organic-farm'),
        'priority' => 3,
    ) );
    $wp_customize->add_setting( 'organic_farm_section_sticky_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Organic_Farm_Customizer_Customcontrol_Section_Heading( $wp_customize, 'organic_farm_section_sticky_heading', array(
		'label'       => esc_html__( 'Sticky Header Settings', 'organic-farm' ),
		'section'     => 'organic_farm_theme_settings',
		'settings'    => 'organic_farm_section_sticky_heading',
	) ) );
    $wp_customize->add_setting(
		'organic_farm_sticky_header',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => 'off',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'organic_farm_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Organic_Farm_Customizer_Customcontrol_Switch(
			$wp_customize,
			'organic_farm_sticky_header',
			array(
				'settings'        => 'organic_farm_sticky_header',
				'section'         => 'organic_farm_theme_settings',
				'label'           => __( 'Show Sticky Header', 'organic-farm' ),
				'choices'		  => array(
					'1'      => __( 'On', 'organic-farm' ),
					'off'    => __( 'Off', 'organic-farm' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting( 'organic_farm_section_loader_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Organic_Farm_Customizer_Customcontrol_Section_Heading( $wp_customize, 'organic_farm_section_loader_heading', array(
		'label'       => esc_html__( 'Loader Settings', 'organic-farm' ),
		'section'     => 'organic_farm_theme_settings',
		'settings'    => 'organic_farm_section_loader_heading',
	) ) );
	$wp_customize->add_setting(
		'organic_farm_theme_loader',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => 'off',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'organic_farm_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Organic_Farm_Customizer_Customcontrol_Switch(
			$wp_customize,
			'organic_farm_theme_loader',
			array(
				'settings'        => 'organic_farm_theme_loader',
				'section'         => 'organic_farm_theme_settings',
				'label'           => __( 'Show Site Loader', 'organic-farm' ),
				'choices'		  => array(
					'1'      => __( 'On', 'organic-farm' ),
					'off'    => __( 'Off', 'organic-farm' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting( 'organic_farm_theme_width_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Organic_Farm_Customizer_Customcontrol_Section_Heading( $wp_customize, 'organic_farm_theme_width_heading', array(
		'label'       => esc_html__( 'Theme Width Settings', 'organic-farm' ),
		'section'     => 'organic_farm_theme_settings',
		'settings'    => 'organic_farm_theme_width_heading',
	) ) );
	$wp_customize->add_setting('organic_farm_width_options',array(
        'default' => 'full_width',
        'sanitize_callback' => 'organic_farm_sanitize_choices'
	));
	$wp_customize->add_control('organic_farm_width_options',array(
        'type' => 'select',
        'label' => __('Theme Width Option','organic-farm'),
        'section' => 'organic_farm_theme_settings',
        'choices' => array(
            'full_width' => __('Fullwidth','organic-farm'),
            'Container' => __('Container','organic-farm'),
            'container_fluid' => __('Container Fluid','organic-farm'),
        ),
	) );
	$wp_customize->add_setting( 'organic_farm_section_menu_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Organic_Farm_Customizer_Customcontrol_Section_Heading( $wp_customize, 'organic_farm_section_menu_heading', array(
		'label'       => esc_html__( 'Menu Settings', 'organic-farm' ),
		'section'     => 'organic_farm_theme_settings',
		'settings'    => 'organic_farm_section_menu_heading',
	) ) );
	$wp_customize->add_setting('organic_farm_menu_text_transform',array(
        'default' => 'CAPITALISE',
        'sanitize_callback' => 'organic_farm_sanitize_choices'
	));
	$wp_customize->add_control('organic_farm_menu_text_transform',array(
        'type' => 'select',
        'label' => __('Menus Text Transform','organic-farm'),
        'section' => 'organic_farm_theme_settings',
        'choices' => array(
            'CAPITALISE' => __('CAPITALISE','organic-farm'),
            'UPPERCASE' => __('UPPERCASE','organic-farm'),
            'LOWERCASE' => __('LOWERCASE','organic-farm'),
        ),
	) );
	$wp_customize->add_setting( 'organic_farm_section_scroll_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Organic_Farm_Customizer_Customcontrol_Section_Heading( $wp_customize, 'organic_farm_section_scroll_heading', array(
		'label'       => esc_html__( 'Scroll Top Settings', 'organic-farm' ),
		'section'     => 'organic_farm_theme_settings',
		'settings'    => 'organic_farm_section_scroll_heading',
	) ) );
	$wp_customize->add_setting(
		'organic_farm_scroll_enable',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'organic_farm_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Organic_Farm_Customizer_Customcontrol_Switch(
			$wp_customize,
			'organic_farm_scroll_enable',
			array(
				'settings'        => 'organic_farm_scroll_enable',
				'section'         => 'organic_farm_theme_settings',
				'label'           => __( 'Show Scroll Top', 'organic-farm' ),
				'choices'		  => array(
					'1'      => __( 'On', 'organic-farm' ),
					'off'    => __( 'Off', 'organic-farm' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting( 'organic_farm_scroll_options',
		array(
			'default' => 'right_align',
			'transport' => 'refresh',
			'sanitize_callback' => 'organic_farm_sanitize_choices'
		)
	);
	$wp_customize->add_control( new Organic_Farm_Text_Radio_Button_Custom_Control( $wp_customize, 'organic_farm_scroll_options',
		array(
			'type' => 'select',
			'label' => esc_html__( 'Scroll Top Alignment', 'organic-farm' ),
			'section' => 'organic_farm_theme_settings',
			'choices' => array(
				'left_align' => __('LEFT','organic-farm'),
				'center_align' => __('CENTER','organic-farm'),
				'right_align' => __('RIGHT','organic-farm'),
			)
		)
	) );
	$wp_customize->add_setting('organic_farm_scroll_top_icon',array(
		'default'	=> 'fas fa-chevron-up',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Organic_Farm_Fontawesome_Icon_Chooser(
        $wp_customize,'organic_farm_scroll_top_icon',array(
		'label'	=> __('Add Scroll Top Icon','organic-farm'),
		'transport' => 'refresh',
		'section'	=> 'organic_farm_theme_settings',
		'setting'	=> 'organic_farm_scroll_top_icon',
		'type'		=> 'icon'
	)));

	// Post Layouts
	$wp_customize->add_panel( 'organic_farm_post_panel', array(
		'title' => esc_html__( 'Post Layout', 'organic-farm' ),
		'priority' => 4,
	));
    $wp_customize->add_section('organic_farm_layout',array(
        'title' => __('Single-Post Layout', 'organic-farm'),
        'panel' => 'organic_farm_post_panel',
    ) );
    $wp_customize->add_setting( 'organic_farm_section_post_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Organic_Farm_Customizer_Customcontrol_Section_Heading( $wp_customize, 'organic_farm_section_post_heading', array(
		'label'       => esc_html__( 'Single Post Structure', 'organic-farm' ),
		'section'     => 'organic_farm_layout',
		'settings'    => 'organic_farm_section_post_heading',
	) ) );
	$wp_customize->add_setting( 'organic_farm_single_post_option',
		array(
			'default' => 'single_right_sidebar',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_text_field'
		)
	);
	$wp_customize->add_control( new Organic_Farm_Radio_Image_Control( $wp_customize, 'organic_farm_single_post_option',
		array(
			'type'=>'select',
			'label' => __( 'select Single Post Page Layout', 'organic-farm' ),
			'section' => 'organic_farm_layout',
			'choices' => array(

				'single_right_sidebar' => array(
					'image' => get_template_directory_uri().'/assets/images/2column.jpg',
					'name' => __( 'Right Sidebar', 'organic-farm' )
				),
				'single_left_sidebar' => array(
					'image' => get_template_directory_uri().'/assets/images/left.png',
					'name' => __( 'Left Sidebar', 'organic-farm' )
				),
				'single_full_width' => array(
					'image' => get_template_directory_uri().'/assets/images/1column.jpg',
					'name' => __( 'One Column', 'organic-farm' )
				),
			)
		)
	) );
	$wp_customize->add_setting('organic_farm_single_post_date',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'organic_farm_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new organic_farm_Customizer_Customcontrol_Switch(
			$wp_customize,
			'organic_farm_single_post_date',
			array(
				'settings'        => 'organic_farm_single_post_date',
				'section'         => 'organic_farm_layout',
				'label'           => __( 'Show Date', 'organic-farm' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'organic-farm' ),
					'off'    => __( 'Off', 'organic-farm' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'organic_farm_single_post_date', array(
		'selector' => '.date-box',
		'render_callback' => 'organic_farm_customize_partial_organic_farm_single_post_date',
	) );
	$wp_customize->add_setting('organic_farm_single_date_icon',array(
		'default'	=> 'far fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Organic_Farm_Fontawesome_Icon_Chooser(
        $wp_customize,'organic_farm_single_date_icon',array(
		'label'	=> __('date Icon','organic-farm'),
		'transport' => 'refresh',
		'section'	=> 'organic_farm_layout',
		'setting'	=> 'organic_farm_single_date_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('organic_farm_single_post_admin',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'organic_farm_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new organic_farm_Customizer_Customcontrol_Switch(
			$wp_customize,
			'organic_farm_single_post_admin',
			array(
				'settings'        => 'organic_farm_single_post_admin',
				'section'         => 'organic_farm_layout',
				'label'           => __( 'Show Author/Admin', 'organic-farm' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'organic-farm' ),
					'off'    => __( 'Off', 'organic-farm' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'organic_farm_single_post_admin', array(
		'selector' => '.entry-author',
		'render_callback' => 'organic_farm_customize_partial_organic_farm_single_post_admin',
	) );
	$wp_customize->add_setting('organic_farm_single_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Organic_Farm_Fontawesome_Icon_Chooser(
        $wp_customize,'organic_farm_single_author_icon',array(
		'label'	=> __('Author Icon','organic-farm'),
		'transport' => 'refresh',
		'section'	=> 'organic_farm_layout',
		'setting'	=> 'organic_farm_single_author_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('organic_farm_single_post_comment',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'organic_farm_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new organic_farm_Customizer_Customcontrol_Switch(
			$wp_customize,
			'organic_farm_single_post_comment',
			array(
				'settings'        => 'organic_farm_single_post_comment',
				'section'         => 'organic_farm_layout',
				'label'           => __( 'Show Comment', 'organic-farm' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'organic-farm' ),
					'off'    => __( 'Off', 'organic-farm' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting('organic_farm_single_comment_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Organic_Farm_Fontawesome_Icon_Chooser(
        $wp_customize,'organic_farm_single_comment_icon',array(
		'label'	=> __('comment Icon','organic-farm'),
		'transport' => 'refresh',
		'section'	=> 'organic_farm_layout',
		'setting'	=> 'organic_farm_single_comment_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('organic_farm_single_post_tag_count',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'organic_farm_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Organic_Farm_Customizer_Customcontrol_Switch(
			$wp_customize,
			'organic_farm_single_post_tag_count',
			array(
				'settings'        => 'organic_farm_single_post_tag_count',
				'section'         => 'organic_farm_layout',
				'label'           => __( 'Show tag count', 'organic-farm' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'organic-farm' ),
					'off'    => __( 'Off', 'organic-farm' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting('organic_farm_single_tag_icon',array(
		'default'	=> 'fas fa-tags',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Organic_Farm_Fontawesome_Icon_Chooser(
        $wp_customize,'organic_farm_single_tag_icon',array(
		'label'	=> __('tag Icon','organic-farm'),
		'transport' => 'refresh',
		'section'	=> 'organic_farm_layout',
		'setting'	=> 'organic_farm_single_tag_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('organic_farm_single_post_tag',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'organic_farm_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new organic_farm_Customizer_Customcontrol_Switch(
			$wp_customize,
			'organic_farm_single_post_tag',
			array(
				'settings'        => 'organic_farm_single_post_tag',
				'section'         => 'organic_farm_layout',
				'label'           => __( 'Show Tags', 'organic-farm' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'organic-farm' ),
					'off'    => __( 'Off', 'organic-farm' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'organic_farm_single_post_tag', array(
		'selector' => '.single-tags',
		'render_callback' => 'organic_farm_customize_partial_organic_farm_single_post_tag',
	) );
	$wp_customize->add_section('organic_farm_archieve_post_layot',array(
        'title' => __('Archieve-Post Layout', 'organic-farm'),
        'panel' => 'organic_farm_post_panel',
    ) );
	$wp_customize->add_setting( 'organic_farm_section_archive_post_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Organic_Farm_Customizer_Customcontrol_Section_Heading( $wp_customize, 'organic_farm_section_archive_post_heading', array(
		'label'       => esc_html__( 'Archieve Post Structure', 'organic-farm' ),
		'section'     => 'organic_farm_archieve_post_layot',
		'settings'    => 'organic_farm_section_archive_post_heading',
	) ) );
    $wp_customize->add_setting( 'organic_farm_post_option',
		array(
			'default' => 'right_sidebar',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_text_field'
		)
	);
	$wp_customize->add_control( new Organic_Farm_Radio_Image_Control( $wp_customize, 'organic_farm_post_option',
		array(
			'type'=>'select',
			'label' => __( 'select Post Page Layout', 'organic-farm' ),
			'section' => 'organic_farm_archieve_post_layot',
			'choices' => array(
				'right_sidebar' => array(
					'image' => get_template_directory_uri().'/assets/images/2column.jpg',
					'name' => __( 'Right Sidebar', 'organic-farm' )
				),
				'left_sidebar' => array(
					'image' => get_template_directory_uri().'/assets/images/left.png',
					'name' => __( 'Left Sidebar', 'organic-farm' )
				),
				'one_column' => array(
					'image' => get_template_directory_uri().'/assets/images/1column.jpg',
					'name' => __( 'One Column', 'organic-farm' )
				),
				'three_column' => array(
					'image' => get_template_directory_uri().'/assets/images/3column.jpg',
					'name' => __( 'Three Column', 'organic-farm' )
				),
				'four_column' => array(
					'image' => get_template_directory_uri().'/assets/images/4column.jpg',
					'name' => __( 'Four Column', 'organic-farm' )
				),
				'grid_sidebar' => array(
					'image' => get_template_directory_uri().'/assets/images/grid-sidebar.jpg',
					'name' => __( 'Grid-Right-Sidebar Layout', 'organic-farm' )
				),
				'grid_left_sidebar' => array(
					'image' => get_template_directory_uri().'/assets/images/grid-left.png',
					'name' => __( 'Grid-Left-Sidebar Layout', 'organic-farm' )
				),
				'grid_post' => array(
					'image' => get_template_directory_uri().'/assets/images/grid.jpg',
					'name' => __( 'Grid Layout', 'organic-farm' )
				)
			)
		)
	) );
	$wp_customize->add_setting( 'organic_farm_grid_column',
		array(
			'default' => '3_column',
			'transport' => 'refresh',
			'sanitize_callback' => 'organic_farm_sanitize_choices'
		)
	);
	$wp_customize->add_control( new Organic_Farm_Text_Radio_Button_Custom_Control( $wp_customize, 'organic_farm_grid_column',
		array(
			'type' => 'select',
			'label' => esc_html__('Grid Post Per Row','organic-farm'),
			'section' => 'organic_farm_archieve_post_layot',
			'choices' => array(
				'1_column' => __('1','organic-farm'),
	            '2_column' => __('2','organic-farm'),
	            '3_column' => __('3','organic-farm'),
	            '4_column' => __('4','organic-farm'),
			)
		)
	) );
	$wp_customize->add_setting('organic_farm_post_excerpt',array(
		'default'=> 30,
		'transport' => 'refresh',
		'sanitize_callback' => 'organic_farm_sanitize_integer'
	));
	$wp_customize->add_control(new Organic_Farm_Slider_Custom_Control( $wp_customize, 'organic_farm_post_excerpt',array(
		'label' => esc_html__( 'Excerpt Limit','organic-farm' ),
		'section'=> 'organic_farm_archieve_post_layot',
		'settings'=>'organic_farm_post_excerpt',
		'input_attrs' => array(
			'reset'			   => 30,
            'step'             => 1,
			'min'              => 0,
			'max'              => 100,
        ),
	)));
	$wp_customize->add_setting('organic_farm_date',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'organic_farm_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Organic_Farm_Customizer_Customcontrol_Switch(
			$wp_customize,
			'organic_farm_date',
			array(
				'settings'        => 'organic_farm_date',
				'section'         => 'organic_farm_archieve_post_layot',
				'label'           => __( 'Show Date', 'organic-farm' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'organic-farm' ),
					'off'    => __( 'Off', 'organic-farm' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'organic_farm_date', array(
		'selector' => '.date-box',
		'render_callback' => 'organic_farm_customize_partial_organic_farm_date',
	) );
	$wp_customize->add_setting('organic_farm_date_icon',array(
		'default'	=> 'far fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Organic_Farm_Fontawesome_Icon_Chooser(
        $wp_customize,'organic_farm_date_icon',array(
		'label'	=> __('date Icon','organic-farm'),
		'transport' => 'refresh',
		'section'	=> 'organic_farm_archieve_post_layot',
		'setting'	=> 'organic_farm_date_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('organic_farm_admin',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'organic_farm_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Organic_Farm_Customizer_Customcontrol_Switch(
			$wp_customize,
			'organic_farm_admin',
			array(
				'settings'        => 'organic_farm_admin',
				'section'         => 'organic_farm_archieve_post_layot',
				'label'           => __( 'Show Author/Admin', 'organic-farm' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'organic-farm' ),
					'off'    => __( 'Off', 'organic-farm' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'organic_farm_admin', array(
		'selector' => '.entry-author',
		'render_callback' => 'organic_farm_customize_partial_organic_farm_admin',
	) );
	$wp_customize->add_setting('organic_farm_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Organic_Farm_Fontawesome_Icon_Chooser(
        $wp_customize,'organic_farm_author_icon',array(
		'label'	=> __('Author Icon','organic-farm'),
		'transport' => 'refresh',
		'section'	=> 'organic_farm_archieve_post_layot',
		'setting'	=> 'organic_farm_author_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('organic_farm_comment',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'organic_farm_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Organic_Farm_Customizer_Customcontrol_Switch(
			$wp_customize,
			'organic_farm_comment',
			array(
				'settings'        => 'organic_farm_comment',
				'section'         => 'organic_farm_archieve_post_layot',
				'label'           => __( 'Show Comment', 'organic-farm' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'organic-farm' ),
					'off'    => __( 'Off', 'organic-farm' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'organic_farm_comment', array(
		'selector' => '.entry-comments',
		'render_callback' => 'organic_farm_customize_partial_organic_farm_comment',
	) );
	$wp_customize->add_setting('organic_farm_comment_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Organic_Farm_Fontawesome_Icon_Chooser(
        $wp_customize,'organic_farm_comment_icon',array(
		'label'	=> __('comment Icon','organic-farm'),
		'transport' => 'refresh',
		'section'	=> 'organic_farm_archieve_post_layot',
		'setting'	=> 'organic_farm_comment_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('organic_farm_tag',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'organic_farm_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Organic_Farm_Customizer_Customcontrol_Switch(
			$wp_customize,
			'organic_farm_tag',
			array(
				'settings'        => 'organic_farm_tag',
				'section'         => 'organic_farm_archieve_post_layot',
				'label'           => __( 'Show tag count', 'organic-farm' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'organic-farm' ),
					'off'    => __( 'Off', 'organic-farm' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'organic_farm_tag', array(
		'selector' => '.tags',
		'render_callback' => 'organic_farm_customize_partial_organic_farm_tag',
	) );
	$wp_customize->add_setting('organic_farm_tag_icon',array(
		'default'	=> 'fas fa-tags',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Organic_Farm_Fontawesome_Icon_Chooser(
        $wp_customize,'organic_farm_tag_icon',array(
		'label'	=> __('tag Icon','organic-farm'),
		'transport' => 'refresh',
		'section'	=> 'organic_farm_archieve_post_layot',
		'setting'	=> 'organic_farm_tag_icon',
		'type'		=> 'icon'
	)));

	// breadcrumb setting
	$wp_customize->add_section('organic_farm_breadcrumb_settings',array(
        'title' => __('Breadcrumb Settings', 'organic-farm'),
        'priority' => 4
    ) );
	$wp_customize->add_setting( 'organic_farm_section_breadcrumb_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Organic_Farm_Customizer_Customcontrol_Section_Heading( $wp_customize, 'organic_farm_section_breadcrumb_heading', array(
		'label'       => esc_html__( ' theme Breadcrumb Settings', 'organic-farm' ),
		'section'     => 'organic_farm_breadcrumb_settings',
		'settings'    => 'organic_farm_section_breadcrumb_heading',
	) ) );
	$wp_customize->add_setting(
		'organic_farm_enable_breadcrumb',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'organic_farm_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Organic_Farm_Customizer_Customcontrol_Switch(
			$wp_customize,
			'organic_farm_enable_breadcrumb',
			array(
				'settings'        => 'organic_farm_enable_breadcrumb',
				'section'         => 'organic_farm_breadcrumb_settings',
				'label'           => __( 'Show Breadcrumb', 'organic-farm' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'organic-farm' ),
					'off'    => __( 'Off', 'organic-farm' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting( 'organic_farm_single_breadcrumb_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Organic_Farm_Customizer_Customcontrol_Section_Heading( $wp_customize, 'organic_farm_single_breadcrumb_heading', array(
		'label'       => esc_html__( 'Single post & Page', 'organic-farm' ),
		'section'     => 'organic_farm_breadcrumb_settings',
		'settings'    => 'organic_farm_single_breadcrumb_heading',
	) ) );
	$wp_customize->add_setting(
		'organic_farm_single_enable_breadcrumb',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'organic_farm_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Organic_Farm_Customizer_Customcontrol_Switch(
			$wp_customize,
			'organic_farm_single_enable_breadcrumb',
			array(
				'settings'        => 'organic_farm_single_enable_breadcrumb',
				'section'         => 'organic_farm_breadcrumb_settings',
				'label'           => __( 'Show Breadcrumb', 'organic-farm' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'organic-farm' ),
					'off'    => __( 'Off', 'organic-farm' ),
				),
				'active_callback' => '',
			)
		)
	);
	if ( class_exists( 'WooCommerce' ) ) { 
		$wp_customize->add_setting( 'organic_farm_woocommerce_breadcrumb_heading', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( new Organic_Farm_Customizer_Customcontrol_Section_Heading( $wp_customize, 'organic_farm_woocommerce_breadcrumb_heading', array(
			'label'       => esc_html__( 'Woocommerce Breadcrumb', 'organic-farm' ),
			'section'     => 'organic_farm_breadcrumb_settings',
			'settings'    => 'organic_farm_woocommerce_breadcrumb_heading',
		) ) );
		$wp_customize->add_setting(
			'organic_farm_woocommerce_enable_breadcrumb',
			array(
				'type'                 => 'option',
				'capability'           => 'edit_theme_options',
				'theme_supports'       => '',
				'default'              => '1',
				'transport'            => 'refresh',
				'sanitize_callback'    => 'organic_farm_callback_sanitize_switch',
			)
		);
		$wp_customize->add_control(
			new Organic_Farm_Customizer_Customcontrol_Switch(
				$wp_customize,
				'organic_farm_woocommerce_enable_breadcrumb',
				array(
					'settings'        => 'organic_farm_woocommerce_enable_breadcrumb',
					'section'         => 'organic_farm_breadcrumb_settings',
					'label'           => __( 'Show Breadcrumb', 'organic-farm' ),				
					'choices'		  => array(
						'1'      => __( 'On', 'organic-farm' ),
						'off'    => __( 'Off', 'organic-farm' ),
					),
					'active_callback' => '',
				)
			)
		);
	}

	// woocommerce
	if ( class_exists( 'WooCommerce' ) ) { 
		$wp_customize->add_section('organic_farm_woocommerce_settings',array(
	        'title' => __('WooCommerce Settings', 'organic-farm'),
	        'priority' => 4,
	    ) );
		$wp_customize->add_setting( 'organic_farm_section_shoppage_heading', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( new Organic_Farm_Customizer_Customcontrol_Section_Heading( $wp_customize, 'organic_farm_section_shoppage_heading', array(
			'label'       => esc_html__( 'Sidebar Settings', 'organic-farm' ),
			'section'     => 'organic_farm_woocommerce_settings',
			'settings'    => 'organic_farm_section_shoppage_heading',
		) ) );
		$wp_customize->add_setting(
			'organic_farm_shop_page_sidebar',
			array(
				'type'                 => 'option',
				'capability'           => 'edit_theme_options',
				'theme_supports'       => '',
				'default'              => '1',
				'transport'            => 'refresh',
				'sanitize_callback'    => 'organic_farm_callback_sanitize_switch',
			)
		);
		$wp_customize->add_control(
			new Organic_Farm_Customizer_Customcontrol_Switch(
				$wp_customize,
				'organic_farm_shop_page_sidebar',
				array(
					'settings'        => 'organic_farm_shop_page_sidebar',
					'section'         => 'organic_farm_woocommerce_settings',
					'label'           => __( 'Show Shop Page Sidebar', 'organic-farm' ),
					'choices'		  => array(
						'1'      => __( 'On', 'organic-farm' ),
						'off'    => __( 'Off', 'organic-farm' ),
					),
					'active_callback' => '',
				)
			)
		);
		$wp_customize->add_setting(
			'organic_farm_wocommerce_single_page_sidebar',
			array(
				'type'                 => 'option',
				'capability'           => 'edit_theme_options',
				'theme_supports'       => '',
				'default'              => '1',
				'transport'            => 'refresh',
				'sanitize_callback'    => 'organic_farm_callback_sanitize_switch',
			)
		);
		$wp_customize->add_control(
			new Organic_Farm_Customizer_Customcontrol_Switch(
				$wp_customize,
				'organic_farm_wocommerce_single_page_sidebar',
				array(
					'settings'        => 'organic_farm_wocommerce_single_page_sidebar',
					'section'         => 'organic_farm_woocommerce_settings',
					'label'           => __( 'Show Single Product Page Sidebar', 'organic-farm' ),
					'choices'		  => array(
						'1'      => __( 'On', 'organic-farm' ),
						'off'    => __( 'Off', 'organic-farm' ),
					),
					'active_callback' => '',
				)
			)
		);
		$wp_customize->add_setting( 'organic_farm_section_archieve_product_heading', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( new Organic_Farm_Customizer_Customcontrol_Section_Heading( $wp_customize, 'organic_farm_section_archieve_product_heading', array(
			'label'       => esc_html__( 'Archieve Product Settings', 'organic-farm' ),
			'section'     => 'organic_farm_woocommerce_settings',
			'settings'    => 'organic_farm_section_archieve_product_heading',
		) ) );
		$wp_customize->add_setting('organic_farm_archieve_item_columns',array(
	        'default' => '3',
	        'sanitize_callback' => 'organic_farm_sanitize_choices'
		));
		$wp_customize->add_control('organic_farm_archieve_item_columns',array(
	        'type' => 'select',
	        'label' => __('Select No of Columns','organic-farm'),
	        'section' => 'organic_farm_woocommerce_settings',
	        'choices' => array(
	            '1' => __('One Column','organic-farm'),
	            '2' => __('Two Column','organic-farm'),
	            '3' => __('Three Column','organic-farm'),
	            '4' => __('four Column','organic-farm'),
	            '5' => __('Five Column','organic-farm'),
	            '6' => __('Six Column','organic-farm'),
	        ),
		) );
		$wp_customize->add_setting( 'organic_farm_archieve_shop_perpage', array(
			'default'              => 6,
			'type'                 => 'theme_mod',
			'transport' 		   => 'refresh',
			'sanitize_callback'    => 'organic_farm_sanitize_number_absint',
			'sanitize_js_callback' => 'absint',
		) );
		$wp_customize->add_control( 'organic_farm_archieve_shop_perpage', array(
			'label'       => esc_html__( 'Display Products','organic-farm' ),
			'section'     => 'organic_farm_woocommerce_settings',
			'type'        => 'number',
			'input_attrs' => array(
				'step'             => 1,
				'min'              => 0,
				'max'              => 30,
			),
		) );
		$wp_customize->add_setting( 'organic_farm_section_related_heading', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( new Organic_Farm_Customizer_Customcontrol_Section_Heading( $wp_customize, 'organic_farm_section_related_heading', array(
			'label'       => esc_html__( 'Related Product Settings', 'organic-farm' ),
			'section'     => 'organic_farm_woocommerce_settings',
			'settings'    => 'organic_farm_section_related_heading',
		) ) );
		$wp_customize->add_setting('organic_farm_related_item_columns',array(
	        'default' => '3',
	        'sanitize_callback' => 'organic_farm_sanitize_choices'
		));
		$wp_customize->add_control('organic_farm_related_item_columns',array(
	        'type' => 'select',
	        'label' => __('Select No of Columns','organic-farm'),
	        'section' => 'organic_farm_woocommerce_settings',
	        'choices' => array(
	            '1' => __('One Column','organic-farm'),
	            '2' => __('Two Column','organic-farm'),
	            '3' => __('Three Column','organic-farm'),
	            '4' => __('four Column','organic-farm'),
	            '5' => __('Five Column','organic-farm'),
	            '6' => __('Six Column','organic-farm'),
	        ),
		) );
		$wp_customize->add_setting( 'organic_farm_related_shop_perpage', array(
			'default'              => 3,
			'type'                 => 'theme_mod',
			'transport' 		   => 'refresh',
			'sanitize_callback'    => 'organic_farm_sanitize_number_absint',
			'sanitize_js_callback' => 'absint',
		) );
		$wp_customize->add_control( 'organic_farm_related_shop_perpage', array(
			'label'       => esc_html__( 'Display Products','organic-farm' ),
			'section'     => 'organic_farm_woocommerce_settings',
			'type'        => 'number',
			'input_attrs' => array(
				'step'             => 1,
				'min'              => 0,
				'max'              => 10,
			),
		) );
		$wp_customize->add_setting(
			'organic_farm_related_product',
			array(
				'type'                 => 'option',
				'capability'           => 'edit_theme_options',
				'theme_supports'       => '',
				'default'              => '1',
				'transport'            => 'refresh',
				'sanitize_callback'    => 'organic_farm_callback_sanitize_switch',
			)
		);
		$wp_customize->add_control(new Organic_Farm_Customizer_Customcontrol_Switch($wp_customize,'organic_farm_related_product',
			array(
				'settings'        => 'organic_farm_related_product',
				'section'         => 'organic_farm_woocommerce_settings',
				'label'           => __( 'Show Related Products', 'organic-farm' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'organic-farm' ),
					'off'    => __( 'Off', 'organic-farm' ),
				),
				'active_callback' => '',
			)
		));
	}
	
	//button
	$wp_customize->add_section('organic_farm_button_options',array(
        'title' => __('Button settings', 'organic-farm'),
        'priority' => 4,
    ) );
    $wp_customize->add_setting( 'organic_farm_section_other_button_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Organic_Farm_Customizer_Customcontrol_Section_Heading( $wp_customize, 'organic_farm_section_other_button_heading', array(
		'label'       => esc_html__( 'Other Page Button Settings', 'organic-farm' ),
		'section'     => 'organic_farm_button_options',
		'settings'    => 'organic_farm_section_other_button_heading',
	) ) );
    $wp_customize->add_setting( 'organic_farm_theme_button_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'organic_farm_theme_button_color', array(
	    'label'       => esc_html__( 'Background Color', 'organic-farm' ),
	    'section' => 'organic_farm_button_options',
	    'settings' => 'organic_farm_theme_button_color',
  	)));
	$wp_customize->add_setting('organic_farm_button_border_radius',array(
		'default'=> 30,
		'transport' => 'refresh',
		'sanitize_callback' => 'organic_farm_sanitize_integer'
	));
	$wp_customize->add_control(new Organic_Farm_Slider_Custom_Control( $wp_customize, 'organic_farm_button_border_radius',array(
		'label' => esc_html__( 'Border Radius','organic-farm' ),
		'section'=> 'organic_farm_button_options',
		'settings'=>'organic_farm_button_border_radius',
		'input_attrs' => array(
			'reset'			   => 30,
            'step'             => 1,
			'min'              => 0,
			'max'              => 30,
        ),
	)));
	$wp_customize->add_setting( 'organic_farm_section_slider_button_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Organic_Farm_Customizer_Customcontrol_Section_Heading( $wp_customize, 'organic_farm_section_slider_button_heading', array(
		'label'       => esc_html__( 'Slider Button Settings', 'organic-farm' ),
		'section'     => 'organic_farm_button_options',
		'settings'    => 'organic_farm_section_slider_button_heading',
	) ) );
	$wp_customize->add_setting( 'organic_farm_slider_button_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'organic_farm_slider_button_color', array(
	    'label' => __(' Background color','organic-farm'),
	    'section' => 'organic_farm_button_options',
	    'settings' => 'organic_farm_slider_button_color',
  	)));
  	$wp_customize->add_setting('organic_farm_slider_button_border_radius',array(
		'default'=> 30,
		'transport' => 'refresh',
		'sanitize_callback' => 'organic_farm_sanitize_integer'
	));
	$wp_customize->add_control(new Organic_Farm_Slider_Custom_Control( $wp_customize, 'organic_farm_slider_button_border_radius',array(
		'label' => esc_html__( ' Border Radius','organic-farm' ),
		'section'=> 'organic_farm_button_options',
		'settings'=>'organic_farm_slider_button_border_radius',
		'input_attrs' => array(
			'reset'            => 30,
            'step'             => 1,
			'min'              => 0,
			'max'              => 30,
        ),
	)));

	


	



	$wp_customize->get_setting( 'blogname' )->transport          = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport   = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport  = 'postMessage';

	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.site-title a',
		'render_callback' => 'organic_farm_customize_partial_blogname',
	) );
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.site-description',
		'render_callback' => 'organic_farm_customize_partial_blogdescription',
	) );

	//front page
	$num_sections = apply_filters( 'organic_farm_front_page_sections', 4 );

	// Create a setting and control for each of the sections available in the theme.
	for ( $i = 1; $i < ( 1 + $num_sections ); $i++ ) {
		$wp_customize->add_setting( 'panel_' . $i, array(
			'default'           => false,
			'sanitize_callback' => 'organic_farm_sanitize_dropdown_pages',
			'transport'         => 'postMessage',
		) );

		$wp_customize->add_control( 'panel_' . $i, array(
			/* translators: %d is the front page section number */
			'label'          => sprintf( __( 'Front Page Section %d Content', 'organic-farm' ), $i ),
			'description'    => ( 1 !== $i ? '' : __( 'Select pages to feature in each area from the dropdowns. Add an image to a section by setting a featured image in the page editor. Empty sections will not be displayed.', 'organic-farm' ) ),
			'section'        => 'theme_options',
			'type'           => 'dropdown-pages',
			'allow_addition' => true,
			'active_callback' => 'organic_farm_is_static_front_page',
		) );

		$wp_customize->selective_refresh->add_partial( 'panel_' . $i, array(
			'selector'            => '#panel' . $i,
			'render_callback'     => 'organic_farm_front_page_section',
			'container_inclusive' => true,
		) );
	}
}
add_action( 'customize_register', 'organic_farm_customize_register' );

function organic_farm_customize_partial_blogname() {
	bloginfo( 'name' );
}
function organic_farm_customize_partial_blogdescription() {
	bloginfo( 'description' );
}
function organic_farm_is_static_front_page() {
	return ( is_front_page() && ! is_home() );
}
function organic_farm_is_view_with_layout_option() {
	return ( is_page() || ( is_archive() && ! is_active_sidebar( 'sidebar-1' ) ) );
}

define('ORGANIC_FARM_PRO_LINK',__('https://www.ovationthemes.com/wordpress/organic-farm-wordpress-theme/','organic-farm'));

/* Pro control */
if (class_exists('WP_Customize_Control') && !class_exists('Organic_Farm_Pro_Control')):
    class Organic_Farm_Pro_Control extends WP_Customize_Control{

    public function render_content(){?>
        <label style="overflow: hidden; zoom: 1;">
	        <div class="col-md upsell-btn">
                <a href="<?php echo esc_url( ORGANIC_FARM_PRO_LINK ); ?>" target="blank" class="btn btn-success btn"><?php esc_html_e('UPGRADE ORGANIC FARM PREMIUM','organic-farm');?> </a>
	        </div>
            <div class="col-md">
                <img class="organic_farm_img_responsive " src="<?php echo esc_url(get_template_directory_uri()); ?>/screenshot.png">
            </div>
	        <div class="col-md">
	            <h3 style="margin-top:10px; margin-left: 20px; text-decoration:underline; color:#333;"><?php esc_html_e('ORGANIC FARM PREMIUM - Features', 'organic-farm'); ?></h3>
                <ul style="padding-top:10px">
                    <li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Responsive Design', 'organic-farm');?> </li>
                    <li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Boxed or fullwidth layout', 'organic-farm');?> </li>
                    <li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Shortcode Support', 'organic-farm');?> </li>
                    <li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Demo Importer', 'organic-farm');?> </li>
                    <li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Section Reordering', 'organic-farm');?> </li>
                    <li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Contact Page Template', 'organic-farm');?> </li>
                    <li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Multiple Blog Layouts', 'organic-farm');?> </li>
                    <li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Unlimited Color Options', 'organic-farm');?> </li>
                    <li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Designed with HTML5 and CSS3', 'organic-farm');?> </li>
                    <li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Customizable Design & Code', 'organic-farm');?> </li>
                    <li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Cross Browser Support', 'organic-farm');?> </li>
                    <li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Detailed Documentation Included', 'organic-farm');?> </li>
                    <li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Stylish Custom Widgets', 'organic-farm');?> </li>
                    <li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Patterns Background', 'organic-farm');?> </li>
                    <li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('WPML Compatible (Translation Ready)', 'organic-farm');?> </li>
                    <li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Woo-commerce Compatible', 'organic-farm');?> </li>
                    <li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Full Support', 'organic-farm');?> </li>
                    <li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('10+ Sections', 'organic-farm');?> </li>
                    <li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Live Customizer', 'organic-farm');?> </li>
                   	<li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('AMP Ready', 'organic-farm');?> </li>
                   	<li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Clean Code', 'organic-farm');?> </li>
                   	<li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('SEO Friendly', 'organic-farm');?> </li>
                   	<li class="upsell-organic_farm"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Supper Fast', 'organic-farm');?> </li>
                </ul>
        	</div>
		    <div class="col-md upsell-btn upsell-btn-bottom">
	            <a href="<?php echo esc_url( ORGANIC_FARM_PRO_LINK ); ?>" target="blank" class="btn btn-success btn"><?php esc_html_e('UPGRADE ORGANIC FARM PREMIUM','organic-farm');?> </a>
		    </div>
			<p><?php printf(__('Please review us if you love our product on %1$sWordPress.org%2$s. </br></br>  Thank You', 'organic-farm'), '<a target="blank" href="https://wordpress.org/support/theme/organic-farm/reviews/">', '</a>');
            ?></p>
        </label>
    <?php } }
endif;


/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */

final class organic_farm_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}


/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );
	}

// icons
/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	 public function enqueue_control_scripts() {

		wp_enqueue_style('organic-farm-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/css/customize-controls.css');

		wp_localize_script(
		'organic-farm-customize-controls',
		'organic_farm_customizer_params',
		array(
			'ajaxurl' =>	admin_url( 'admin-ajax.php' )
		));
	}


}
