{*
* Template Prestashop DiscountShop
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*}

{include file="$tpl_dir./breadcrumb.tpl"}

{include file="$tpl_dir./errors.tpl"}

{if !isset($errors) OR !sizeof($errors)}
	<h1>{l s='List of products by supplier'}&nbsp;{$supplier->name|escape:'html':'UTF-8'}</h1>
	{if !empty($supplier->description)}
		<div class="description_box">
			<img src="{$img_sup_dir}{if isset($supplier->id_supplier)}{$supplier->id_supplier|escape:'html':'UTF-8'}{else}{$supplier->id|escape:'html':'UTF-8'}{/if}-medium.jpg" alt="{$supplier->name|escape:'html':'UTF-8'}" />
			<p>{$supplier->description}</p>
		</div>
	{/if}

	{if $products}
		<div class="content_sortPagiBar">
			<div class="sortPagiBar">
				{include file="$tpl_dir./product-compare.tpl"}
				{include file="$tpl_dir./nbr-product-page.tpl"}
				{include file="$tpl_dir./product-sort.tpl"}
			</div>
		</div>
	
		{include file="$tpl_dir./product-list.tpl" products=$products}
	
		<div class="content_sortPagiBar">
			<div class="sortPagiBar">
				{include file="$tpl_dir./product-compare.tpl"}
				{include file="$tpl_dir./pagination.tpl"}
			</div>
		</div>
	{else}
		<p class="warning">{l s='No products for this supplier.'}</p>
	{/if}
{/if}