{*
* Template Prestashop DiscountShop
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*}

{if isset($orderby) AND isset($orderway)}

{* On 1.5 the var request is setted on the front controller. The next lines assure the retrocompatibility with some modules *}
{if !isset($request)}
	<!-- Sort products -->
	{if isset($smarty.get.id_category) && $smarty.get.id_category}
		{assign var='request' value=$link->getPaginationLink('category', $category, false, true)}
	{elseif isset($smarty.get.id_manufacturer) && $smarty.get.id_manufacturer}
		{assign var='request' value=$link->getPaginationLink('manufacturer', $manufacturer, false, true)}
	{elseif isset($smarty.get.id_supplier) && $smarty.get.id_supplier}
		{assign var='request' value=$link->getPaginationLink('supplier', $supplier, false, true)}
	{else}
		{assign var='request' value=$link->getPaginationLink(false, false, false, true)}
	{/if}
{/if}

<script type="text/javascript">
//<![CDATA[
$(document).ready(function()
{
	$('#selectPrductSort').change(function()
	{
		var requestSortProducts = '{$request}';
		var splitData = $(this).val().split(':');
		document.location.href = requestSortProducts + ((requestSortProducts.indexOf('?') < 0) ? '?' : '&') + 'orderby=' + splitData[0] + '&orderway=' + splitData[1];
	});
});
//]]>
</script>

<form id="productsSortForm" action="{$request|escape:'html':'UTF-8'}">
	<p class="select">
		<label>{l s='Sort by :'}</label>
		<select id="selectPrductSort" class="selectProductSort">
			<option value="{$orderbydefault|escape:'html':'UTF-8'}:{$orderwaydefault|escape:'html':'UTF-8'}" {if $orderby eq $orderbydefault}selected="selected"{/if}>{l s='--'}</option>
			{if !$PS_CATALOG_MODE}
				<option value="price:asc" {if $orderby eq 'price' AND $orderway eq 'asc'}selected="selected"{/if}>{l s='Price: lowest first'}</option>
				<option value="price:desc" {if $orderby eq 'price' AND $orderway eq 'desc'}selected="selected"{/if}>{l s='Price: highest first'}</option>
			{/if}
			<option value="name:asc" {if $orderby eq 'name' AND $orderway eq 'asc'}selected="selected"{/if}>{l s='Product Name: A to Z'}</option>
			<option value="name:desc" {if $orderby eq 'name' AND $orderway eq 'desc'}selected="selected"{/if}>{l s='Product Name: Z to A'}</option>
			{if !$PS_CATALOG_MODE}
				<option value="quantity:desc" {if $orderby eq 'quantity' AND $orderway eq 'desc'}selected="selected"{/if}>{l s='In-stock first'}</option>
			{/if}
		</select>
	</p>
</form>
<!-- /Sort products -->
{/if}

<span class="gridorlist">
	<a href="#" class="gridview{if !isset($ptm_listdisplay) OR !isset($smarty.cookies.switchercookie) AND isset($ptm_listdisplay) AND $ptm_listdisplay == 1 OR isset($smarty.cookies.switchercookie) AND $smarty.cookies.switchercookie=="grid"} active{/if}" title="{l s='Grid'}"><i class="icon-grid2"></i></a>
	<a href="#" class="listview{if !isset($smarty.cookies.switchercookie) AND isset($ptm_listdisplay) AND $ptm_listdisplay == 0 OR isset($smarty.cookies.switchercookie) AND $smarty.cookies.switchercookie=="list"} active{/if}" title="{l s='List'}"><i class="icon-list4"></i></a>
</span>