{*
* Template Prestashop DiscountShop
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*}

{if !$opc}
	<script type="text/javascript">
	// <![CDATA[
	var currencySign = '{$currencySign|html_entity_decode:2:"UTF-8"}';
	var currencyRate = '{$currencyRate|floatval}';
	var currencyFormat = '{$currencyFormat|intval}';
	var currencyBlank = '{$currencyBlank|intval}';
	var txtProduct = "{l s='product'}";
	var txtProducts = "{l s='products'}";
	// ]]>
	</script>

	{capture name=path}{l s='Your payment method'}{/capture}
	{include file="$tpl_dir./breadcrumb.tpl"}
{/if}

{if !$opc}<h1>{l s='Choose your payment method'}</h1>{else}<h2><span>3</span> {l s='Choose your payment method'}</h2>{/if}

{if !$opc}
	{assign var='current_step' value='payment'}
	{include file="$tpl_dir./order-steps.tpl"}
	{include file="$tpl_dir./errors.tpl"}
{else}
	<div id="opc_payment_methods" class="opc-main-block">
		<div id="opc_payment_methods-overlay" class="opc-overlay" style="display:none"></div>
{/if}

<div class="paiement_block">

	<div id="HOOK_TOP_PAYMENT">{$HOOK_TOP_PAYMENT}</div>

	{if !$opc}
		{if isset($advanced_payment_api) && $advanced_payment_api}
			<h2>{l s='Shopping cart summary'}</h2>
		{/if}
		{if version_compare($smarty.const._PS_VERSION_,'1.6','>=')}{hook h="displayBeforeShoppingCartBlock"}{/if}
		<div id="order-detail-content" class="table_block">
			<table id="cart_summary" class="std">
				<thead>
					<tr>
						<th class="cart_product first_item">{l s='Product'}</th>
						<th class="cart_description item">{l s='Description'}</th>
						<th class="cart_unit item">{l s='Unit price'}</th>
						<th class="cart_quantity item">{l s='Qty'}</th>
						<th class="cart_total last_item">{l s='Total price'}</th>
					</tr>
				</thead>
				<tbody>
				{foreach from=$products item=product name=productLoop}
					{assign var='productId' value=$product.id_product}
					{assign var='productAttributeId' value=$product.id_product_attribute}
					{assign var='quantityDisplayed' value=0}
					{assign var='cannotModify' value=1}
					{assign var='odd' value=$product@iteration%2}
					{assign var='noDeleteButton' value=1}
					{* Display the product line *}
					{include file="$tpl_dir./shopping-cart-product-line.tpl"}
					{* Then the customized datas ones*}
					{if isset($customizedDatas.$productId.$productAttributeId)}
						{if isset($product.id_address_delivery)}{assign var=varCustomizedDatas value=$customizedDatas.$productId.$productAttributeId[$product.id_address_delivery]}{else}{assign var=varCustomizedDatas value=$customizedDatas.$productId.$productAttributeId}{/if}
						{foreach $varCustomizedDatas as $id_customization=>$customization}
							<tr id="product_{$product.id_product}_{$product.id_product_attribute}_{$id_customization}{if isset($product.id_address_delivery)}_{$product.id_address_delivery|intval}{/if}" class="product_customization_for_{$product.id_product}_{$product.id_product_attribute}{if isset($product.id_address_delivery)}_{$product.id_address_delivery|intval}{/if} {if $odd}odd{else}even{/if} customization alternate_item {if $product@last && $customization@last && isset($gift_products) && !count($gift_products)}last_item{/if}">
								<td></td>
								<td>
									{foreach $customization.datas as $type => $custom_data}
										{if $type == $CUSTOMIZE_FILE}
											<div class="customizationUploaded">
												<ul class="customizationUploaded">
													{foreach $custom_data as $picture}
														<li><img src="{$pic_dir}{$picture.value}_small" alt="" class="customizationUploaded" /></li>
													{/foreach}
												</ul>
											</div>
										{elseif $type == $CUSTOMIZE_TEXTFIELD}
											<ul class="typedText">
												{foreach $custom_data as $textField}
													<li>
														{if $textField.name}
															{$textField.name}
														{else}
															{l s='Text #'}{$textField@index+1}
														{/if}
														: {$textField.value}
													</li>
												{/foreach}
											</ul>
										{/if}
									{/foreach}
								</td>
								<td></td>
								<td class="cart_quantity">
									<span>{if $quantityDisplayed == 0 AND isset($customizedDatas.$productId.$productAttributeId)}{$customizedDatas.$productId.$productAttributeId|@count}{else}{$product.cart_quantity-$quantityDisplayed}{/if}</span>
								</td>
								<td></td>
							</tr>
							{assign var='quantityDisplayed' value=$quantityDisplayed+$customization.quantity}
						{/foreach}
						{* If it exists also some uncustomized products *}
						{if $product.quantity-$quantityDisplayed > 0}{include file="$tpl_dir./shopping-cart-product-line.tpl" productLast=$product@last productFirst=$product@first}{/if}
					{/if}
				{/foreach}
				{if isset($gift_products)}
				{assign var='last_was_odd' value=$product@iteration%2}
				{foreach $gift_products as $product}
					{assign var='productId' value=$product.id_product}
					{assign var='productAttributeId' value=$product.id_product_attribute}
					{assign var='quantityDisplayed' value=0}
					{assign var='odd' value=($product@iteration+$last_was_odd)%2}
					{assign var='ignoreProductLast' value=isset($customizedDatas.$productId.$productAttributeId)}
					{assign var='cannotModify' value=1}
					{* Display the gift product line *}
					{include file="$tpl_dir./shopping-cart-product-line.tpl" productLast=$product@last productFirst=$product@first}
				{/foreach}
				{/if}
				</tbody>
			{if count($discounts)}
				<tbody>
				{foreach from=$discounts item=discount name=discountLoop}
					<tr class="cart_discount {if $smarty.foreach.discountLoop.last}last_item{elseif $smarty.foreach.discountLoop.first}first_item{else}item{/if}" id="cart_discount_{$discount.id_discount}">
						<td></td>
						<td class="cart_discount_name">{if isset($discount.code)}{$discount.code}{else}{$discount.name}{/if} - {$discount.description}</td>
						<td></td>
						<td></td>
						<td class="cart_discount_price">
							<span class="price-discount">
								{if $discount.value_real > 0}
									{if !$priceDisplay}
										{displayPrice price=$discount.value_real*-1}
									{else}
										{displayPrice price=$discount.value_tax_exc*-1}
									{/if}
								{/if}
							</span>
						</td>
					</tr>
				{/foreach}
				</tbody>
			{/if}
			</table>
			<table id="cart_summary_total" class="std">
				{if $use_taxes}
					{if $priceDisplay}
						<tr class="cart_total_price">
							<td>{if $display_tax_label}{l s='Total products (tax excl.) :'}{else}{l s='Total products :'}{/if}</td>
							<td id="total_product" class="price">{displayPrice price=$total_products}</td>
						</tr>
					{else}
						<tr class="cart_total_price">
							<td>{if $display_tax_label}{l s='Total products (tax incl.) :'}{else}{l s='Total products :'}{/if}</td>
							<td id="total_product" class="price">{displayPrice price=$total_products_wt}</td>
						</tr>
					{/if}
				{else}
					<tr class="cart_total_price">
						<td>{l s='Total products :'}</td>
						<td id="total_product" class="price">{displayPrice price=$total_products}</td>
					</tr>
				{/if}
				<tr class="cart_total_voucher" {if $total_discounts == 0}style="display:none"{/if}>
					<td>
						{if $use_taxes}
							{if $priceDisplay}
								{if $display_tax_label}{l s='Total coupon codes (tax excl.) :'}{else}{l s='Total vouchers :'}{/if}
							{else}
								{if $display_tax_label}{l s='Total coupon codes (tax incl.) :'}{else}{l s='Total vouchers :'}{/if}
							{/if}
						{else}
							{l s='Total coupon codes :'}
						{/if}
					</td>
					<td id="total_discount" class="price-discount price">
						{if $use_taxes && !$priceDisplay}
							{assign var='total_discounts_negative' value=$total_discounts}
						{else}
							{assign var='total_discounts_negative' value=$total_discounts_tax_exc}
						{/if}
						{if $total_discounts_negative < 0}
							{displayPrice price=$total_discounts_negative}
						{else}
							{displayPrice price=$total_discounts_negative * -1}
						{/if}
					</td>
				</tr>
				<tr class="cart_total_voucher" {if $total_wrapping == 0}style="display:none"{/if}>
					<td>
						{if $use_taxes}
							{if $priceDisplay}
								{if $display_tax_label}{l s='Total gift-wrapping (tax excl.) :'}{else}{l s='Total gift-wrapping :'}{/if}
							{else}
								{if $display_tax_label}{l s='Total gift-wrapping (tax incl.) :'}{else}{l s='Total gift-wrapping :'}{/if}
							{/if}
						{else}
							{l s='Total gift-wrapping :'}
						{/if}
					</td>
					<td id="total_wrapping" class="price-discount price">
						{if $use_taxes}
							{if $priceDisplay}
								{displayPrice price=$total_wrapping_tax_exc}
							{else}
								{displayPrice price=$total_wrapping}
							{/if}
						{else}
							{displayPrice price=$total_wrapping_tax_exc}
						{/if}
					</td>
				</tr>
				{if $total_shipping_tax_exc <= 0 && !isset($virtualCart)}
					<tr class="cart_total_delivery">
						<td>{l s='Total shipping :'}</td>
						<td id="total_shipping" class="price">{l s='Free Shipping !'}</td>
					</tr>
				{else}
					{if $use_taxes}
						{if $priceDisplay}
							<tr class="cart_total_delivery" {if $total_shipping <= 0}style="display:none"{/if}>
								<td>{if $display_tax_label}{l s='Total shipping (tax excl.) :'}{else}{l s='Total shipping :'}{/if}</td>
								<td id="total_shipping" class="price">{displayPrice price=$total_shipping_tax_exc}</td>
							</tr>
						{else}
							<tr class="cart_total_delivery" {if $total_shipping <= 0}style="display:none"{/if}>
								<td>{if $display_tax_label}{l s='Total shipping (tax incl.) :'}{else}{l s='Total shipping :'}{/if}</td>
								<td id="total_shipping" class="price">{displayPrice price=$total_shipping}</td>
							</tr>
						{/if}
					{else}
						<tr class="cart_total_delivery" {if $total_shipping <= 0}style="display:none"{/if}>
							<td>{l s='Total shipping :'}</td>
							<td id="total_shipping" class="price">{displayPrice price=$total_shipping_tax_exc}</td>
						</tr>
					{/if}
				{/if}
				{if $use_taxes}
					<tr class="cart_total_tax">
						<td>{l s='Total tax :'}</td>
						<td id="total_tax" class="price">{displayPrice price=$total_tax}</td>
					</tr>
					<tr class="cart_total_price">
						<td id="total_price_label" class="total_price">{l s='Total (tax incl.) :'}</td>
						<td id="total_price_amount" class="total_price price">{displayPrice price=$total_price}</td>
					</tr>
				{else}
					<tr class="cart_total_price">
						<td id="total_price_label" class="total_price">{l s='Total :'}</td>
						<td id="total_price_amount" class="total_price price">{displayPrice price=$total_price_without_tax}</td>
					</tr>
				{/if}
			</table>
			<div class="clear"></div>
		</div>
		{if version_compare($smarty.const._PS_VERSION_,'1.6','>=')}{hook h="displayAfterShoppingCartBlock" colspan_total=''}{/if}
	{/if}
	{if !isset($advanced_payment_api) || (isset($advanced_payment_api) && !$advanced_payment_api)}
		{if isset($HOOK_PAYMENT) && $HOOK_PAYMENT}
			{if $opc}<div id="opc_payment_methods-content">{/if}
				<div id="HOOK_PAYMENT">{$HOOK_PAYMENT}</div>
			{if $opc}</div>{/if}
		{else}
			<p class="warning">{l s='Unable to find any available payment option for your cart. Please contact us if the problem persists.'}</p>
		{/if}
	{/if}
</div>
{if isset($advanced_payment_api) && $advanced_payment_api}
	{if !$opc}
		{if !isset($addresses_style)}
			{$addresses_style.company = 'address_company'}
			{$addresses_style.vat_number = 'address_company'}
			{$addresses_style.firstname = 'address_name'}
			{$addresses_style.lastname = 'address_name'}
			{$addresses_style.address1 = 'address_address1'}
			{$addresses_style.address2 = 'address_address2'}
			{$addresses_style.city = 'address_city'}
			{$addresses_style.country = 'address_country'}
			{$addresses_style.phone = 'address_phone'}
			{$addresses_style.phone_mobile = 'address_phone_mobile'}
			{$addresses_style.alias = 'address_title'}
		{/if}
		{assign var='have_non_virtual_products' value=false}
		{foreach $products as $product}
			{if $product.is_virtual == 0}
				{assign var='have_non_virtual_products' value=true}
				{break}
			{/if}
		{/foreach}
		<div id="adresses_details">
			<h2>{l s='Address(es) details'}</h2>
			{if ((!empty($delivery_option) AND !isset($virtualCart)) OR $delivery->id OR $invoice->id)}
				<div class="bloc_adresses clearfix">
					{if !isset($formattedAddresses) || (count($formattedAddresses.invoice) == 0 && count($formattedAddresses.delivery) == 0) || (count($formattedAddresses.invoice.formated) == 0 && count($formattedAddresses.delivery.formated) == 0)}
						{if $delivery->id}
							<div {if !$have_non_virtual_products}style="display:none"{/if}>
								<ul id="address_delivery" class="address item">
									<li class="address_title">{l s='Delivery address'}&nbsp;<span class="address_alias">({$delivery->alias})</span></li>
									{if $delivery->company}<li class="address_company">{$delivery->company|escape:'html':'UTF-8'}</li>{/if}
									<li class="address_name">{$delivery->firstname|escape:'html':'UTF-8'} {$delivery->lastname|escape:'html':'UTF-8'}</li>
									<li class="address_address1">{$delivery->address1|escape:'html':'UTF-8'}</li>
									{if $delivery->address2}<li class="address_address2">{$delivery->address2|escape:'html':'UTF-8'}</li>{/if}
									<li class="address_city">{$delivery->postcode|escape:'html':'UTF-8'} {$delivery->city|escape:'html':'UTF-8'}</li>
									<li class="address_country">{$delivery->country|escape:'html':'UTF-8'} {if $delivery->id_state}({$delivery_state->name|escape:'html':'UTF-8'}){/if}</li>
								</ul>
							</div>
						{/if}
						{if $invoice->id}
							<div>
								<ul id="address_invoice" class="address alternate_item">
									<li class="address_title">{l s='Invoice address'}&nbsp;<span class="address_alias">({$invoice->alias})</span></li>
									{if $invoice->company}<li class="address_company">{$invoice->company|escape:'html':'UTF-8'}</li>{/if}
									<li class="address_name">{$invoice->firstname|escape:'html':'UTF-8'} {$invoice->lastname|escape:'html':'UTF-8'}</li>
									<li class="address_address1">{$invoice->address1|escape:'html':'UTF-8'}</li>
									{if $invoice->address2}<li class="address_address2">{$invoice->address2|escape:'html':'UTF-8'}</li>{/if}
									<li class="address_city">{$invoice->postcode|escape:'html':'UTF-8'} {$invoice->city|escape:'html':'UTF-8'}</li>
									<li class="address_country">{$invoice->country|escape:'html':'UTF-8'} {if $invoice->id_state}({$invoice->name|escape:'html':'UTF-8'}){/if}</li>
								</ul>
							</div>
						{/if}
					{else}
						{foreach from=$formattedAddresses key=k item=address}
							<div {if $k == 'delivery' && !$have_non_virtual_products}style="display:none"{/if}>
								<ul class="address {if $address@last}last_item{elseif $address@first}first_item{/if} {if $address@index % 2}alternate_item{else}item{/if}">
									<li class="address_title">
											{if $k eq 'invoice'}
												{l s='Invoice address'}
											{elseif $k eq 'delivery' && $delivery->id}
												{l s='Delivery address'}
											{/if}
											{if isset($address.object.alias)}
												<span class="address_alias">({$address.object.alias})</span>
											{/if}
									</li>
									{foreach $address.ordered as $pattern}
										{assign var=addressKey value=" "|explode:$pattern}
										{assign var=addedli value=false}
										{foreach from=$addressKey item=key name=foo}
											{$key_str = $key|regex_replace:AddressFormat::_CLEANING_REGEX_:""}
											{if isset($address.formated[$key_str]) && !empty($address.formated[$key_str])}
												{if (!$addedli)}
													{$addedli = true}
													<li><span class="{if isset($addresses_style[$key_str])}{$addresses_style[$key_str]}{/if}">
												{/if}
												{$address.formated[$key_str]|escape:'html':'UTF-8'}
											{/if}
											{if ($smarty.foreach.foo.last && $addedli)}
												</span></li>
											{/if}
										{/foreach}
									{/foreach}
								</ul>
							</div>
						{/foreach}
					{/if}
				</div>
			{/if}
		</div>
	{/if}
	<!-- HOOK_ADVANCED_PAYMENT -->
	<div id="HOOK_ADVANCED_PAYMENT">
		{if !$opc}
			<h2>{l s='Payment options'}</h2>
		{/if}
		<!-- Should get a collection of "PaymentOption" object -->
		{assign var='adv_payment_empty' value=true}
		{foreach from=$HOOK_ADVANCED_PAYMENT item=pay_option key=key}
			{if $pay_option}
				{assign var='adv_payment_empty' value=false}
			{/if}
		{/foreach}
		{if $HOOK_ADVANCED_PAYMENT && !$adv_payment_empty}
			{foreach $HOOK_ADVANCED_PAYMENT as $advanced_payment_opt_list}
				{foreach $advanced_payment_opt_list as $paymentOption}
						<p class="payment_module pointer-box">
							<a class="payment_module_adv">
								<img class="payment_option_logo" src="{$paymentOption->getLogo()}"/>
								<span class="payment_option_cta">
									{$paymentOption->getCallToActionText()}
								</span>
								<span class="payment_option_selected">
									<i class="icon-check"></i>
								</span>
							</a>
						</p>
						<div class="payment_option_form">
							{if $paymentOption->getForm()}
								{$paymentOption->getForm()}
							{else}
								<form method="{if $paymentOption->getMethod()}{$paymentOption->getMethod()}{else}POST{/if}" action="{$paymentOption->getAction()}">
									{if $paymentOption->getInputs()}
										{foreach from=$paymentOption->getInputs() item=value key=name}
											<input type="hidden" name="{$name}" value="{$value}">
										{/foreach}
									{/if}
								</form>
							{/if}
						</div>
				{/foreach}
			{/foreach}
		{else}
			<p class="warning">{l s='Unable to find any available payment option for your cart. Please contact us if the problem persists.'}</p>
		{/if}
	</div>
    <!-- end HOOK_ADVANCED_PAYMENT -->
	<!-- TNC -->
    <div id="terms_conditions">
		{if $conditions AND $cms_id}
			{if $override_tos_display}
				{$override_tos_display}
			{else}
				<h2>{l s='Terms of service'}</h2>
				<div class="tnc_box">
				    <p class="checkbox">
					    <input type="checkbox" name="cgv" id="cgv" value="1" {if $checkedTOS}checked="checked"{/if} />
					    <label for="cgv">{l s='I agree to the terms of service and will adhere to them unconditionally.'}</label>
					    <a href="{$link_conditions|escape:'html':'UTF-8'}" class="iframe" rel="nofollow">{l s='(Read the Terms of Service)'}</a>
				    </p>
				</div>
			{/if}
		{/if}
	</div>
    <!-- end TNC -->
	<p class="cart_navigation clearfix">
		{if $opc}
			{assign var='back_link' value=$link->getPageLink('index')}
		{else}
			{assign var='back_link' value=$link->getPageLink('order', true, NULL, "step=2")}
		{/if}
		<a href="{$back_link|escape:'html':'UTF-8'}" title="{l s='Previous'}" class="button">&laquo; {l s='Continue shopping'}</a>
		<input data-show-if-js="" style="" type="submit" id="confirmOrder" value="{l s='Order with obligation to pay'}" class="exclusive" />
	</p>
{else}
	{if !$opc}
		<p class="cart_navigation"><a href="{$link->getPageLink('order.php', true)}?step=2" title="{l s='Previous'}" class="button">&laquo; {l s='Previous'}</a></p>
	{else}
		</div>
	{/if}
{/if}