{*
* Template Prestashop DiscountShop
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*}

{include file="$tpl_dir./breadcrumb.tpl"}
{include file="$tpl_dir./errors.tpl"}

{if isset($category)}
	{if $category->id AND $category->active}
		<h1>
			{strip}
				{$category->name|escape:'html':'UTF-8'}
				{if isset($categoryNameComplement)}
					{$categoryNameComplement|escape:'html':'UTF-8'}
				{/if}
				<span class="category-product-count">
					{include file="$tpl_dir./category-count.tpl"}
				</span>
			{/strip}
		</h1>

		{if $scenes || $category->description || $category->id_image}
		<div class="content_scene_cat">
			{if $scenes}
				<!-- Scenes -->
				{include file="$tpl_dir./scenes.tpl" scenes=$scenes}
			{else}
				<!-- Category image -->
				{if $category->id_image}
				<div class="cat_img">
					<img id="categoryImage" src="{$link->getCatImageLink($category->link_rewrite, $category->id_image, 'category')}" alt="{$category->name|escape:'html':'UTF-8'}" title="{$category->name|escape:'html':'UTF-8'}" />
				</div>
				{/if}
			{/if}
			{if $category->description}
				<div class="cat_desc">
					<p>{$category->description}</p>
				</div>
			{/if}
		</div>
		{/if}

		{if !isset($ptm_subcatdisplay) OR isset($ptm_subcatdisplay) AND $ptm_subcatdisplay == 1}
			{if isset($ptm_subcat) && $ptm_subcat == 3}{assign var='spanValue' value=4}{/if}
			{if isset($ptm_subcat) && $ptm_subcat == 4}{assign var='spanValue' value=3}{/if}
			{if isset($ptm_subcat) && $ptm_subcat == 5}{assign var='spanValue' value=2}{/if}
			{if isset($subcategories)}
			<!-- Subcategories -->
			<div id="subcategories">
				{if isset($ptm_subcat)}
					{assign var='nbItemsPerLine' value=$ptm_subcat}
				{else}
					{assign var='nbItemsPerLine' value=4}
					{assign var='spanValue' value=3}
				{/if}
				<ul class="inline_list">
				{foreach from=$subcategories item=subcategory name=subcategory}
					<li class="{if $smarty.foreach.subcategory.iteration%$nbItemsPerLine == 1}first_item_of_line {/if}span{$spanValue}">
						<a href="{$link->getCategoryLink($subcategory.id_category, $subcategory.link_rewrite)|escape:'html':'UTF-8'}" title="{$subcategory.name|escape:'html':'UTF-8'}" class="img">
							<img src="{$link->getCatImageLink($subcategory.link_rewrite, $subcategory.id_image, 'category')}" alt="{$subcategory.name|escape:'html':'UTF-8'}" />
						</a>
						<a href="{$link->getCategoryLink($subcategory.id_category, $subcategory.link_rewrite)|escape:'html':'UTF-8'}" class="cat_name" title="{$subcategory.name|escape:'html':'UTF-8'}">{$subcategory.name|truncate:20:'...'|escape:'html':'UTF-8'}</a>
						{*{if $subcategory.description}
							<p class="cat_desc">{$subcategory.description|strip_tags:'UTF-8'|truncate:120:'...'|escape:'html':'UTF-8'}</p>
						{/if}*}
					</li>
				{/foreach}
				</ul>
			</div>
			{/if}
		{/if}

		{if $products}
			<div class="content_sortPagiBar">
				<div class="sortPagiBar">
					{include file="$tpl_dir./product-compare.tpl"}
					{include file="$tpl_dir./nbr-product-page.tpl"}
					{include file="$tpl_dir./product-sort.tpl"}
				</div>
			</div>
			
			{include file="$tpl_dir./product-list.tpl" products=$products}
			
			<div class="content_sortPagiBar">
				<div class="sortPagiBar">
					{include file="$tpl_dir./product-compare.tpl"}
					{include file="$tpl_dir./pagination.tpl"}
				</div>
			</div>
		{/if}
	{elseif $category->id}
		<p class="warning">{l s='This category is currently unavailable.'}</p>
	{/if}
	{* Careful with those brackets! *}
	<script src="//cdnjs.cloudflare.com/ajax/libs/tinysort/2.2.4/tinysort.min.js"></script>
	<div class="block new-left">
		<h4 class="title_block">
			{$category->name|escape:'html':'UTF-8'}{literal} 
			<span style="cursor: pointer;" class="sort-caret-up" onclick="">▼ <span class="date-sort" style="display:none;">(latest)</span></span>
			<span class="sort-caret-down" style="display: none; cursor: pointer;" onclick="">▲ <span class="date-sort" style="display:none;">(oldest)</span></span>
		</h4>
		<ul class="block_content sortable">
			{/literal}
			{foreach from=$subcategories item=subcategory name=subcategory}
				<li data-date="{$subcategory.date_add}">
					<a href="{$link->getCategoryLink($subcategory.id_category, $subcategory.link_rewrite)|escape:'html':'UTF-8'}">{$subcategory.name|truncate:20:'...'|escape:'html':'UTF-8'}</a>
				</li>
			{/foreach}{literal}
		</ul>
	</div>
	<script>
		if( $('.category-alternate').length ){
			if( $('.cat_desc').text().trim() == '' ){
				$('.cat_desc').hide();
			}
			$('#left_column > .block').remove();
			$('#left_column').append( $('.new-left') );
			if( ($('h1').text().indexOf('Books') > -1) || ($('h1').text().indexOf('Recipes') > -1) ){
				$('.date-sort').show();
				$('.sort-caret-up').on('click', function(){
					tinysort('.sortable>li',{order:'desc', attr: 'data-date'}); 
					$(this).hide();
					$('.sort-caret-down').show();
				});
				$('.sort-caret-down').on('click', function(){
					tinysort('.sortable>li',{order:'asc', attr: 'data-date'}); 
					$(this).hide();
					$('.sort-caret-up').show();
				});
			} else {
				$('.sort-caret-up').on('click', function(){
					tinysort('.sortable>li>a',{order:'desc'}); 
					$(this).hide();
					$('.sort-caret-down').show();
				});
				$('.sort-caret-down').on('click', function(){
					tinysort('.sortable>li>a',{order:'asc'}); 
					$(this).hide();
					$('.sort-caret-up').show();
				});
			}
			tinysort('.sortable>li>a',{order:'asc'})
		} else {
			$('.new-left').remove();
		}

	</script>
	{/literal}
{/if}