CREATE TABLE IF NOT EXISTS `PREFIX_wk_usps_shipping_services` (
	`id` int(10) unsigned NOT NULL auto_increment,
	`id_carrier` int(11) unsigned NOT NULL,
	`class_id` varchar(10) character set utf8 NOT NULL,
	`service_name` varchar(64) character set utf8 NOT NULL,
	PRIMARY KEY  (`id`)
) ENGINE=ENGINE_TYPE DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX_wk_usps_shipping_cache` (
	`id` int(10) unsigned NOT NULL auto_increment,
	`id_cart` int(10) NOT NULL,
	`id_carrier` int(10) NOT NULL,
	`hash` varchar(32) NOT NULL,
	`id_currency` int(10) NOT NULL,
	`total_charges` double(10,2) NOT NULL,
	`is_available` tinyint(1) NOT NULL,
	`date_add` datetime NOT NULL,
	`date_upd` datetime NOT NULL,
	PRIMARY KEY (`id`)
) ENGINE=ENGINE_TYPE DEFAULT CHARSET=utf8;

INSERT INTO `PREFIX_wk_usps_shipping_services` (`id_carrier`, `class_id`, `service_name`) VALUES
(0, '0_FCLE', 'First-Class Mail Large Envelope'),
(0, '0_FCL',  'First-Class Mail Letter'),
(0, '0_FCP',  'First-Class Mail Parcel'),
(0, '0_FCPC', 'First-Class Mail Postcards'),
(0, '1',      'Priority Mail'),
(0, '2',      'Priority Mail Express Hold For Pickup'),
(0, '3',      'Priority Mail Express'),
(0, '4',      'Standard Post'),
(0, '6',      'Media Mail Parcel'),
(0, '7',      'Library Mail Parcel'),
(0, '13',     'Priority Mail Express Flat Rate Envelope'),
(0, '15',     'First-Class Mail Large Postcards'),
(0, '16',     'Priority Mail Flat Rate Envelope'),
(0, '17',     'Priority Mail Medium Flat Rate Box'),
(0, '22',     'Priority Mail Large Flat Rate Box'),
(0, '23',	  'Priority Mail Express Sunday/Holiday Delivery'),
(0, '25',     'Priority Mail Express Sunday/Holiday Delivery Flat Rate Envelope'),
(0, '27',     'Priority Mail Express Flat Rate Envelope Hold For Pickup'),
(0, '28',     'Priority Mail Small Flat Rate Box'),
(0, '29',     'Priority Mail Padded Flat Rate Envelope'),
(0, '30',     'Priority Mail Express Legal Flat Rate Envelope'),
(0, '31',     'Priority Mail Express Legal Flat Rate Envelope Hold For Pickup'),
(0, '32',     'Priority Mail Express Sunday/Holiday Delivery Legal Flat Rate Envelope'),
(0, '33',     'Priority Mail Hold For Pickup'),
(0, '34',     'Priority Mail Large Flat Rate Box Hold For Pickup'),
(0, '35',     'Priority Mail Medium Flat Rate Box Hold For Pickup'),
(0, '36',     'Priority Mail Small Flat Rate Box Hold For Pickup'),
(0, '37',     'Priority Mail Flat Rate Envelope Hold For Pickup'),
(0, '38',     'Priority Mail Gift Card Flat Rate Envelope'),
(0, '39',     'Priority Mail Gift Card Flat Rate Envelope Hold For Pickup'),
(0, '40',     'Priority Mail Window Flat Rate Envelope'),
(0, '41',     'Priority Mail Window Flat Rate Envelope Hold For Pickup'),
(0, '42',     'Priority Mail Small Flat Rate Envelope'),
(0, '43',     'Priority Mail Small Flat Rate Envelope Hold For Pickup'),
(0, '44',     'Priority Mail Legal Flat Rate Envelope'),
(0, '45',     'Priority Mail Legal Flat Rate Envelope Hold For Pickup'),
(0, '46',     'Priority Mail Padded Flat Rate Envelope Hold For Pickup'),
(0, '47',     'Priority Mail Regional Rate Box A'),
(0, '48',     'Priority Mail Regional Rate Box A Hold For Pickup'),
(0, '49',     'Priority Mail Regional Rate Box B'),
(0, '50',     'Priority Mail Regional Rate Box B Hold For Pickup'),
(0, '53',     'First-Class Package Service Hold For Pickup'),
(0, '55',     'Priority Mail Express Flat Rate Boxes'),
(0, '56',     'Priority Mail Express Flat Rate Boxes Hold For Pickup'),
(0, '57',     'Priority Mail Express Sunday/Holiday Delivery Flat Rate Boxes'),
(0, '58',     'Priority Mail Regional Rate Box C'),
(0, '59',     'Priority Mail Regional Rate Box C Hold For Pickup'),
(0, '61',     'First-Class Package Service'),
(0, '62',     'Priority Mail Express Padded Flat Rate Envelope'),
(0, '63',     'Priority Mail Express Padded Flat Rate Envelope Hold For Pickup'),
(0, '64',     'Priority Mail Express Sunday/Holiday Delivery Padded Flat Rate Envelope'),
(0, 'INT_1',  'Priority Mail Express International'),
(0, 'INT_2',  'Priority Mail International'),
(0, 'INT_4',  'Global Express Guaranteed (GXG)'),
(0, 'INT_5',  'Global Express Guaranteed Document'),
(0, 'INT_6',  'Global Express Guaranteed Non-Document Rectangular'),
(0, 'INT_7',  'Global Express Guaranteed Non-Document Non-Rectangular'),
(0, 'INT_8',  'Priority Mail International Flat Rate Envelope'),
(0, 'INT_9',  'Priority Mail International Medium Flat Rate Box'),
(0, 'INT_10', 'Priority Mail Express International Flat Rate Envelope'),
(0, 'INT_11', 'Priority Mail International Large Flat Rate Box'),
(0, 'INT_12', 'USPS GXG Envelopes'),
(0, 'INT_13', 'First-Class Mail International Letter'),
(0, 'INT_14', 'First-Class Mail International Large Envelope'),
(0, 'INT_15', 'First-Class Package International Service'),
(0, 'INT_16', 'Priority Mail International Small Flat Rate Box'),
(0, 'INT_17', 'Priority Mail Express International Legal Flat Rate Envelope'),
(0, 'INT_18', 'Priority Mail International Gift Card Flat Rate Envelope'),
(0, 'INT_19', 'Priority Mail International Window Flat Rate Envelope'),
(0, 'INT_20', 'Priority Mail International Small Flat Rate Envelope'),
(0, 'INT_21', 'First-Class Mail International Postcard'),
(0, 'INT_22', 'Priority Mail International Legal Flat Rate Envelope'),
(0, 'INT_23', 'Priority Mail International Padded Flat Rate Envelope'),
(0, 'INT_24', 'Priority Mail International DVD Flat Rate priced box'),
(0, 'INT_25', 'Priority Mail International Large Video Flat Rate priced box'),
(0, 'INT_26', 'Priority Mail Express International Flat Rate Boxes'),
(0, 'INT_27', 'Priority Mail Express International Padded Flat Rate Envelope');