<?php
/**
* Module Prestashop PrestacreaThemeManager
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*/

class PrestacreaThemeManager extends Module
{
	public function __construct()
	{
		$this->name = 'prestacreathememanager';
		$this->tab = 'administration';
		$this->version = '1.5.5';
		$this->author = 'PRESTACREA';

		$this->bootstrap = true;
		$this->need_instance = 0;
		parent::__construct();

		$this->displayName = ('PRESTACREA - Theme Manager');
		$this->description = $this->l('Management module for your Prestacrea template');
        
        if (version_compare(_PS_VERSION_, '1.5.0.0', '<'))
            require(_PS_MODULE_DIR_.$this->name.'/backward_compatibility/backward.php');

		if (version_compare(_PS_VERSION_, '1.5.0.0', '<'))
		{
			if (!function_exists('smartyHook'))
			{
				function smartyHook($params, &$smarty)
				{
					if (!empty($params['h']))
					{
						$id_module = null;
						$hook_params = $params;
						$hook_params['smarty'] = $smarty;
						if (!empty($params['mod']))
						{
							$module = Module::getInstanceByName($params['mod']);
							if ($module && $module->id)
								$id_module = $module->id;
							unset($hook_params['mod']);
						}
						unset($hook_params['h']);
						return Hook::exec($params['h'], $hook_params, $id_module);
					}
				}
				smartyRegisterFunction($this->context->smarty, 'function', 'hook', 'smartyHook');
			}
		}
	}

	public function install()
	{
		if (file_exists(dirname(__FILE__).'/theme/install/theme-install.php'))
			require_once(dirname(__FILE__).'/theme/install/theme-install.php');

		if (file_exists(dirname(__FILE__).'/theme/install/theme-update.php') && $this->version >= '1.2')
			unlink(dirname(__FILE__).'/theme/install/theme-update.php');

		if (file_exists(dirname(__FILE__).'/theme/less/theme-global.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/theme-global.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/theme-responsive.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/theme-responsive.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/theme-maintenance.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/theme-maintenance.less.cache');

		if (file_exists(dirname(__FILE__).'/theme/less/module-advancedeucompliance.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-advancedeucompliance.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockbestsellers.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockbestsellers.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockcart.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockcart.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockcontact.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockcontact.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockcurrencies.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockcurrencies.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocklanguages.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocklanguages.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocklayered.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocklayered.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockmyaccountfooter.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockmyaccountfooter.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocknewproducts.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocknewproducts.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocknewsletter.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocknewsletter.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockpermanentlinks.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockpermanentlinks.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockreinsurance.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockreinsurance.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocksearch.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocksearch.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockspecials.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockspecials.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockstore.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockstore.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocktags.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocktags.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocktopmenu.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocktopmenu.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockuserinfo.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockuserinfo.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockviewed.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockviewed.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockwishlist.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockwishlist.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-carriercompare.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-carriercompare.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-crossselling.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-crossselling.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-editorial.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-editorial.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-favoriteproducts.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-favoriteproducts.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-homeslider.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-homeslider.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-mailalerts.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-mailalerts.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-productcomments.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-productcomments.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-productscategory.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-productscategory.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-sendtoafriend.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-sendtoafriend.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-themeconfigurator.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-themeconfigurator.less.cache');

		if (file_exists(dirname(__FILE__).'/theme/install/modules-install.php'))
			require_once(dirname(__FILE__).'/theme/install/modules-install.php');

		Db::getInstance()->Execute('INSERT IGNORE INTO '._DB_PREFIX_.'hook (`id_hook`, `name`, `title`, `description`, `position`, `live_edit`) VALUES (null, "topColumn", "Top Column", "Display a column above defaults columns", "1", "1")');

		if (!parent::install() || !$this->registerHook('header'))
			return false;
		return true;
	}

	public function uninstall()
	{
		if (file_exists(dirname(__FILE__).'/theme/install/theme-uninstall.php'))
			require_once(dirname(__FILE__).'/theme/install/theme-uninstall.php');

		if (file_exists(dirname(__FILE__).'/theme/less/theme-global.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/theme-global.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/theme-responsive.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/theme-responsive.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/theme-maintenance.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/theme-maintenance.less.cache');

		if (file_exists(dirname(__FILE__).'/theme/less/module-advancedeucompliance.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-advancedeucompliance.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockbestsellers.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockbestsellers.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockcart.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockcart.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockcontact.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockcontact.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockcurrencies.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockcurrencies.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocklanguages.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocklanguages.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocklayered.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocklayered.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockmyaccountfooter.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockmyaccountfooter.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocknewproducts.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocknewproducts.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocknewsletter.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocknewsletter.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockpermanentlinks.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockpermanentlinks.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockreinsurance.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockreinsurance.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocksearch.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocksearch.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockspecials.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockspecials.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockstore.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockstore.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocktags.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocktags.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocktopmenu.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocktopmenu.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockuserinfo.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockuserinfo.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockviewed.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockviewed.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockwishlist.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockwishlist.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-carriercompare.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-carriercompare.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-crossselling.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-crossselling.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-editorial.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-editorial.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-favoriteproducts.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-favoriteproducts.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-homeslider.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-homeslider.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-mailalerts.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-mailalerts.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-productcomments.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-productcomments.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-productscategory.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-productscategory.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-sendtoafriend.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-sendtoafriend.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-themeconfigurator.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-themeconfigurator.less.cache');

		if (file_exists(dirname(__FILE__).'/theme/install/modules-install.php'))
			require_once(dirname(__FILE__).'/theme/install/modules-install.php');

		if (!parent::uninstall())
			return false;
		return true;
	}

	public function getContent()
	{
		$this->_html = '<h2>'.$this->displayName.' - v.'.$this->version.' - '.Configuration::get('PTM_THEMENAME').'</h2>
		<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">
			<input style="margin:0 0 20px;" type="submit" name="submitCache" value="'.$this->l('Clear module cache').'" class="button" />';
			if (file_exists(dirname(__FILE__).'/theme/install/theme-update.php') && $this->version >= '1.2' && !Tools::isSubmit('submitUpdate'))
				$this->_html .= '<input style="margin:0 0 20px 10px;" type="submit" name="submitUpdate" value="'.$this->l('Update module').'" class="button" />';
		$this->_html .= '</form>';
		if (Tools::isSubmit('submitGeneral'))
		{
			Configuration::updateValue('PTM_RESPONSIVE', pSQL(Tools::getValue('ptm_responsive')));
			Configuration::updateValue('PTM_COLUMN', pSQL(Tools::getValue('ptm_column')));
			Configuration::updateValue('PTM_QUICKVIEW', pSQL(Tools::getValue('ptm_quickview')));
			Configuration::updateValue('PTM_HOMEBUTTONS', pSQL(Tools::getValue('ptm_homebuttons')));
			Configuration::updateValue('PTM_HOMEPRODUCTS', pSQL(Tools::getValue('ptm_homeproducts')));
			Configuration::updateValue('PTM_SUBCATDISPLAY', pSQL(Tools::getValue('ptm_subcatdisplay')));
			Configuration::updateValue('PTM_SUBCAT', pSQL(Tools::getValue('ptm_subcat')));
			Configuration::updateValue('PTM_LISTDISPLAY', pSQL(Tools::getValue('ptm_listdisplay')));
			Configuration::updateValue('PTM_LISTBUTTONS', pSQL(Tools::getValue('ptm_listbuttons')));
			Configuration::updateValue('PTM_LISTPRODUCTS', pSQL(Tools::getValue('ptm_listproducts')));
			$this->_html .= $this->displayConfirmation($this->l('Configuration updated'));
		}
		if (Tools::isSubmit('submitStyle'))
		{
			Configuration::updateValue('PTM_GOOGLEFONT', pSQL(Tools::getValue('ptm_googlefont')));
			if (Tools::getValue('ptm_basefontfamily') && Validate::isName(Tools::getValue('ptm_basefontfamily')))
				Configuration::updateValue('PTM_BASEFONTFAMILY', pSQL(Tools::getValue('ptm_basefontfamily')));
			else
				$this->_html .= $this->displayError($this->l('Invalid base font family'));
			if (Tools::getValue('ptm_altfontfamily') && Validate::isName(Tools::getValue('ptm_altfontfamily')))
				Configuration::updateValue('PTM_ALTFONTFAMILY', pSQL(Tools::getValue('ptm_altfontfamily')));
			else
				$this->_html .= $this->displayError($this->l('Invalid alt font family'));
			if (Tools::getValue('ptm_pricesfontfamily') && Validate::isName(Tools::getValue('ptm_pricesfontfamily')))
				Configuration::updateValue('PTM_PRICESFONTFAMILY', pSQL(Tools::getValue('ptm_pricesfontfamily')));
			else
				$this->_html .= $this->displayError($this->l('Invalid prices font family'));
			if (Tools::getValue('ptm_basefontsize') && Validate::isInt(Tools::getValue('ptm_basefontsize')))
				Configuration::updateValue('PTM_BASEFONTSIZE', pSQL(Tools::getValue('ptm_basefontsize')));
			else
				$this->_html .= $this->displayError($this->l('Invalid base font size'));
			if (Tools::getValue('ptm_altfontsize') && Validate::isInt(Tools::getValue('ptm_altfontsize')))
				Configuration::updateValue('PTM_ALTFONTSIZE', pSQL(Tools::getValue('ptm_altfontsize')));
			else
				$this->_html .= $this->displayError($this->l('Invalid alt font size'));
			if (Tools::getValue('ptm_pricesfontsize') && Validate::isInt(Tools::getValue('ptm_pricesfontsize')))
				Configuration::updateValue('PTM_PRICESFONTSIZE', pSQL(Tools::getValue('ptm_pricesfontsize')));
			else
				$this->_html .= $this->displayError($this->l('Invalid prices font size'));
			if (Tools::getValue('ptm_basecolor'))
				Configuration::updateValue('PTM_BASECOLOR', pSQL(Tools::getValue('ptm_basecolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid base color'));
			if (Tools::getValue('ptm_altcolor'))
				Configuration::updateValue('PTM_ALTCOLOR', pSQL(Tools::getValue('ptm_altcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid alt color'));
			if (Tools::getValue('ptm_basefontcolor'))
				Configuration::updateValue('PTM_BASEFONTCOLOR', pSQL(Tools::getValue('ptm_basefontcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid base font color'));
			if (Tools::getValue('ptm_pricesfontcolor'))
				Configuration::updateValue('PTM_PRICESFONTCOLOR', pSQL(Tools::getValue('ptm_pricesfontcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid prices font color'));

			if (file_exists(dirname(__FILE__).'/theme/less/theme-global.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/theme-global.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/theme-responsive.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/theme-responsive.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/theme-maintenance.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/theme-maintenance.less.cache');

			if (file_exists(dirname(__FILE__).'/theme/less/module-advancedeucompliance.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-advancedeucompliance.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockbestsellers.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockbestsellers.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockcart.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockcart.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockcontact.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockcontact.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockcurrencies.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockcurrencies.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocklanguages.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocklanguages.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocklayered.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocklayered.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockmyaccountfooter.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockmyaccountfooter.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocknewproducts.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocknewproducts.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocknewsletter.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocknewsletter.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockpermanentlinks.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockpermanentlinks.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockreinsurance.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockreinsurance.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocksearch.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocksearch.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockspecials.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockspecials.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockstore.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockstore.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocktags.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocktags.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocktopmenu.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocktopmenu.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockuserinfo.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockuserinfo.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockviewed.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockviewed.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockwishlist.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockwishlist.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-carriercompare.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-carriercompare.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-crossselling.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-crossselling.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-editorial.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-editorial.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-favoriteproducts.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-favoriteproducts.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-homeslider.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-homeslider.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-mailalerts.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-mailalerts.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-productcomments.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-productcomments.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-productscategory.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-productscategory.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-sendtoafriend.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-sendtoafriend.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-themeconfigurator.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-themeconfigurator.less.cache');

			if (file_exists(dirname(__FILE__).'/theme/install/modules-install.php'))
				require_once(dirname(__FILE__).'/theme/install/modules-install.php');

			$this->_html .= $this->displayConfirmation($this->l('Configuration updated'));
		}
		if (Tools::isSubmit('submitCSS'))
		{
			if ($this->putFileContents())
				$this->_html .= $this->displayConfirmation($this->l('CSS file updated'));
			else
				$this->_html .= $this->displayError($this->l('No CSS file selected'));
		}
		if (Tools::isSubmit('submitCache'))
		{
			if (file_exists(dirname(__FILE__).'/theme/less/theme-global.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/theme-global.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/theme-responsive.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/theme-responsive.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/theme-maintenance.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/theme-maintenance.less.cache');

			if (file_exists(dirname(__FILE__).'/theme/less/module-advancedeucompliance.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-advancedeucompliance.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockbestsellers.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockbestsellers.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockcart.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockcart.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockcontact.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockcontact.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockcurrencies.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockcurrencies.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocklanguages.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocklanguages.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocklayered.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocklayered.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockmyaccountfooter.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockmyaccountfooter.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocknewproducts.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocknewproducts.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocknewsletter.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocknewsletter.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockpermanentlinks.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockpermanentlinks.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockreinsurance.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockreinsurance.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocksearch.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocksearch.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockspecials.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockspecials.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockstore.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockstore.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocktags.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocktags.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocktopmenu.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocktopmenu.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockuserinfo.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockuserinfo.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockviewed.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockviewed.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockwishlist.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockwishlist.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-carriercompare.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-carriercompare.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-crossselling.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-crossselling.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-editorial.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-editorial.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-favoriteproducts.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-favoriteproducts.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-homeslider.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-homeslider.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-mailalerts.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-mailalerts.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-productcomments.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-productcomments.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-productscategory.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-productscategory.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-sendtoafriend.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-sendtoafriend.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-themeconfigurator.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-themeconfigurator.less.cache');

			if (file_exists(dirname(__FILE__).'/theme/install/modules-install.php'))
				require_once(dirname(__FILE__).'/theme/install/modules-install.php');

			$this->_html .= $this->displayConfirmation($this->l('Module cache cleared'));
		}
		if (Tools::isSubmit('submitUpdate'))
		{
			if (file_exists(dirname(__FILE__).'/theme/install/theme-update.php'))
				require_once(dirname(__FILE__).'/theme/install/theme-update.php');
			unlink(dirname(__FILE__).'/theme/install/theme-update.php');
			$this->_html .= $this->displayConfirmation($this->l('Module updated'));
		}
		$this->displayForm();
		return $this->_html;
	}

	public function displayForm()
	{
		$this->_html .= '<link rel="stylesheet" type="text/css" href="'.$this->_path.'views/css/admin/admin.css" />
		<link rel="stylesheet" type="text/css" href="'.$this->_path.'views/css/admin/colorpicker.css" />
		<script type="text/javascript" src="'.$this->_path.'views/js/admin/admin.js"></script>
		<script type="text/javascript" src="'.$this->_path.'views/js/admin/colorpicker.js"></script>
		<script language="javascript" type="text/javascript" src="'.$this->_path.'views/js/admin/edit_area_full.js"></script>
		<div id="tab_container">
			<script type="text/javascript">var id_tab = 1;changeTab(id_tab);</script>
			<ul class="tabs">
				<li id="tab_1" class="tab active" onclick="changeTab(1);">'.$this->l('General configuration').'</li>
				<li id="tab_2" class="tab" onclick="changeTab(2);">'.$this->l('Graphical configuration').'</li>
				<li id="tab_3" class="tab" onclick="changeTab(3);">'.$this->l('CSS Editor').'</li>
			</ul>
			<div id="content_1" class="content" style="display:block">';
				$this->configGeneral();
			$this->_html .= '</div>
			<div id="content_2" class="content" style="display:none">';
				$this->configStyle();
			$this->_html .= '</div>
			<div id="content_3" class="content" style="display:none">';
				$this->configCSS();
			$this->_html .= '</div>
		</div>';
	}

	public function configGeneral()
	{
		$base_admin_uri = is_dir(Tools::safeOutput($_SERVER['REQUEST_URI']));
		$languages = Language::getLanguages();
		$this->_html .= '<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">
			<fieldset>
				<h3>'.$this->l('Useful links for theme configuration').'</h3>
				<div class="block mini">
					<label>'.$this->l('Logo configuration').'</label>
					<div class="lnkContainer">
						<a class="lnk" target="_blank" href="'.$base_admin_uri.'?tab=AdminThemes&token='.Tools::getAdminToken('AdminThemes'.(int)Tab::getIdFromClassName('AdminThemes').(int)$this->context->cookie->id_employee).'">'.$this->l('Configure logo').'</a>
					</div>
					<p>'.$this->l('Link towards the logo configuration space').'</p>
				</div>
				<div class="block mini">
					<label>'.$this->l('Theme translations').'</label>
					<div class="lnkContainer">';
						foreach ($languages as $language)
						{
							if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
								$this->_html .= '<a target="_blank" style="margin-right:5px" href="'.$base_admin_uri.'?lang='.$language['iso_code'].'&tab=AdminTranslations&token='.Tools::getAdminToken('AdminTranslations'.(int)Tab::getIdFromClassName('AdminTranslations').(int)$this->context->cookie->id_employee).'&type=front&theme='.Configuration::get('PTM_THEMEPATH').'"><img src="'._THEME_LANG_DIR_.$language['id_lang'].'.jpg" alt="'.$language['iso_code'].'" title="'.$language['iso_code'].'" /></a>';
							else
								$this->_html .= '<a target="_blank" style="margin-right:5px" href="'.$base_admin_uri.'?lang='.$language['iso_code'].'&tab=AdminTranslations&token='.Tools::getAdminToken('AdminTranslations'.(int)Tab::getIdFromClassName('AdminTranslations').(int)$this->context->cookie->id_employee).'&type=front&theme_name='.Configuration::get('PTM_THEMEPATH').'"><img src="'._THEME_LANG_DIR_.$language['id_lang'].'.jpg" alt="'.$language['iso_code'].'" title="'.$language['iso_code'].'" /></a>';
						}
					$this->_html .= '</div>
					<p>'.$this->l('Link towards the theme translation space').'</p>
				</div>
				<div class="block mini">
					<label>'.$this->l('Images configuration').'</label>
					<div class="lnkContainer">
						<a class="lnk" target="_blank" href="'.$base_admin_uri.'?tab=AdminImages&token='.Tools::getAdminToken('AdminImages'.(int)Tab::getIdFromClassName('AdminImages').(int)$this->context->cookie->id_employee).'">'.$this->l('Configure images').'</a>
					</div>
					<p>'.$this->l('Link towards the images configuration space').'</p>
				</div>
				<div class="block mini">
					<label>'.$this->l('Modules configuration').'</label>
					<div class="lnkContainer">
						<a class="lnk" target="_blank" href="'.$base_admin_uri.'?tab=AdminModules&token='.Tools::getAdminToken('AdminModules'.(int)Tab::getIdFromClassName('AdminModules').(int)$this->context->cookie->id_employee).'">'.$this->l('Configure modules').'</a>
					</div>
					<p>'.$this->l('Link towards the modules configuration space').'</p>
				</div>
				<div class="block mini">
					<label>'.$this->l('Modules positions').'</label>
					<div class="lnkContainer">
						<a class="lnk" target="_blank" href="'.$base_admin_uri.'?tab=AdminModulesPositions&token='.Tools::getAdminToken('AdminModulesPositions'.(int)Tab::getIdFromClassName('AdminModulesPositions').(int)$this->context->cookie->id_employee).'">'.$this->l('Configure modules positions').'</a>
					</div>
					<p>'.$this->l('Link towards the modules positions configuration space').'</p>
				</div>
				<div class="block mini">
					<label>'.$this->l('Theme modules translations').'</label>
					<div class="lnkContainer">';
						foreach ($languages as $language)
						{
							if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
								$this->_html .= '<a target="_blank" style="margin-right:5px" href="'.$base_admin_uri.'index.php?tab=AdminTranslations&lang='.$language['iso_code'].'&type=modules&theme='.Configuration::get('PTM_THEMEPATH').'&token='.Tools::getAdminToken('AdminTranslations'.(int)Tab::getIdFromClassName('AdminTranslations').(int)$this->context->cookie->id_employee).'"><img src="'._THEME_LANG_DIR_.$language['id_lang'].'.jpg" alt="'.$language['iso_code'].'" title="'.$language['iso_code'].'" /></a>';
							else
								$this->_html .= '<a target="_blank" style="margin-right:5px" href="'.$base_admin_uri.'index.php?tab=AdminTranslations&lang='.$language['iso_code'].'&type=modules&token='.Tools::getAdminToken('AdminTranslations'.(int)Tab::getIdFromClassName('AdminTranslations').(int)$this->context->cookie->id_employee).'#'.Configuration::get('PTM_THEMEPATH').'"><img src="'._THEME_LANG_DIR_.$language['id_lang'].'.jpg" alt="'.$language['iso_code'].'" title="'.$language['iso_code'].'" /></a>';
						}
					$this->_html .= '</div>
					<p>'.$this->l('Link towards the theme modules translation space').'</p>
				</div>
				<div class="clear"></div>
				<div class="space"></div>
				<h3>'.$this->l('General configuration options').'</h3>
				<div class="block small higher">
					<label>'.$this->l('General theme display').'</label>
					<div class="inputContainer">
						<span class="label">'.$this->l('Responsive mode').' :</span>
						<input type="radio" name="ptm_responsive" value="1" '.(Configuration::get('PTM_RESPONSIVE') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="ptm_responsive" value="0" '.(!Configuration::get('PTM_RESPONSIVE') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<div class="inputContainer">
						<span class="label">'.$this->l('Column').' :</span>
						<input type="radio" name="ptm_column" value="1" '.(Configuration::get('PTM_COLUMN') ? 'checked="checked"' : '').' />'.$this->l('Left').'
						<input type="radio" name="ptm_column" value="0" '.(!Configuration::get('PTM_COLUMN') ? 'checked="checked"' : '').' />'.$this->l('Right').'
					</div>
					<div class="inputContainer">
						<span class="label">'.$this->l('Quick view').' :</span>
						<input type="radio" name="ptm_quickview" value="1" '.(Configuration::get('PTM_QUICKVIEW') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="ptm_quickview" value="0" '.(!Configuration::get('PTM_QUICKVIEW') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set whether the responsive mode is activated or not, the columns layout and whether the products quick view is enabled or not').'</p>
				</div>
				<div class="block small higher">
					<label>'.$this->l('Featured products display').'</label>
					<div class="inputContainer">
						<span class="label">'.$this->l('Buttons').' :</span>
						<select name="ptm_homebuttons" id="ptm_homebuttons">
							<option value="none" '.(Configuration::get('PTM_HOMEBUTTONS') == 'none' ? 'selected="selected"' : '').'>'.$this->l('None').'</option>
							<option value="view" '.(Configuration::get('PTM_HOMEBUTTONS') == 'view' ? 'selected="selected"' : '').'>'.$this->l('View').'</option>
							<option value="addcart" '.(Configuration::get('PTM_HOMEBUTTONS') == 'addcart' ? 'selected="selected"' : '').'>'.$this->l('Add to cart').'</option>
							<option value="both" '.(Configuration::get('PTM_HOMEBUTTONS') == 'both' ? 'selected="selected"' : '').'>'.$this->l('View and Add to cart').'</option>
						</select>
					</div>
					<span class="label">'.$this->l('Products per line').' :</span>
					<select name="ptm_homeproducts" id="ptm_homeproducts">
						<option value="3" '.(Configuration::get('PTM_HOMEPRODUCTS') == '3' ? 'selected="selected"' : '').'>'.$this->l('3 products').'</option>
						<option value="4" '.(Configuration::get('PTM_HOMEPRODUCTS') == '4' ? 'selected="selected"' : '').'>'.$this->l('4 products').'</option>
						<option value="5" '.(Configuration::get('PTM_HOMEPRODUCTS') == '5' ? 'selected="selected"' : '').'>'.$this->l('5 products').'</option>
					</select>
					<p>'.$this->l('Set the buttons to display and the number of products per line for featured products').'</p>
				</div>
				<div class="block small higher">
					<label>'.$this->l('Subcategories display').'</label>
					<div class="inputContainer">
						<span class="label">'.$this->l('Activate display').' :</span>
						<input type="radio" name="ptm_subcatdisplay" value="1" '.(Configuration::get('PTM_SUBCATDISPLAY') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="ptm_subcatdisplay" value="0" '.(!Configuration::get('PTM_SUBCATDISPLAY') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<span class="label">'.$this->l('Categories per line').' :</span>
					<select name="ptm_subcat" id="ptm_subcat">
						<option value="3" '.(Configuration::get('PTM_SUBCAT') == '3' ? 'selected="selected"' : '').'>'.$this->l('3 categories').'</option>
						<option value="4" '.(Configuration::get('PTM_SUBCAT') == '4' ? 'selected="selected"' : '').'>'.$this->l('4 categories').'</option>
						<option value="5" '.(Configuration::get('PTM_SUBCAT') == '5' ? 'selected="selected"' : '').'>'.$this->l('5 categories').'</option>
					</select>
					<p>'.$this->l('Set whether the subcategories are displayed or not and the number of categories per line').'</p>
				</div>
				<div class="block small higher">
					<label>'.$this->l('Products lists display').'</label>
					<div class="inputContainer">
						<span class="label">'.$this->l('Display').' :</span>
						<input type="radio" name="ptm_listdisplay" value="1" '.(Configuration::get('PTM_LISTDISPLAY') ? 'checked="checked"' : '').' />'.$this->l('Grid').'
						<input type="radio" name="ptm_listdisplay" value="0" '.(!Configuration::get('PTM_LISTDISPLAY') ? 'checked="checked"' : '').' />'.$this->l('List').'
					</div>
					<div class="inputContainer">
						<span class="label">'.$this->l('Buttons').' :</span>
						<select name="ptm_listbuttons" id="ptm_listbuttons">
							<option value="none" '.(Configuration::get('PTM_LISTBUTTONS') == 'none' ? 'selected="selected"' : '').'>'.$this->l('None').'</option>
							<option value="view" '.(Configuration::get('PTM_LISTBUTTONS') == 'view' ? 'selected="selected"' : '').'>'.$this->l('View').'</option>
							<option value="addcart" '.(Configuration::get('PTM_LISTBUTTONS') == 'addcart' ? 'selected="selected"' : '').'>'.$this->l('Add to cart').'</option>
							<option value="both" '.(Configuration::get('PTM_LISTBUTTONS') == 'both' ? 'selected="selected"' : '').'>'.$this->l('View and Add to cart').'</option>
						</select>
					</div>
					<span class="label">'.$this->l('Products per line').' :</span>
					<select name="ptm_listproducts" id="ptm_listproducts">
						<option value="3" '.(Configuration::get('PTM_LISTPRODUCTS') == '3' ? 'selected="selected"' : '').'>'.$this->l('3 products').'</option>
						<option value="4" '.(Configuration::get('PTM_LISTPRODUCTS') == '4' ? 'selected="selected"' : '').'>'.$this->l('4 products').'</option>
						<option value="5" '.(Configuration::get('PTM_LISTPRODUCTS') == '5' ? 'selected="selected"' : '').'>'.$this->l('5 products').'</option>
					</select>
					<p>'.$this->l('Set the grid or list default display, the buttons to display and the number of products per line for products lists').'</p>
				</div>
				<div class="clear"></div>
				<div class="update"><input type="submit" name="submitGeneral" value="'.$this->l('Update configuration').'" class="button" /></div>
			</fieldset>
		</form>';
	}

	public function configStyle()
	{
		$google_fonts_array = Array (
			Array ('font-name' => 'Abel','css-name' => 'Abel'),
			Array ('font-name' => 'Abril Fatface','css-name' => 'Abril+Fatface'),
			Array ('font-name' => 'Aclonica','css-name' => 'Aclonica'),
			Array ('font-name' => 'Actor','css-name' => 'Actor'),
			Array ('font-name' => 'Adamina','css-name' => 'Adamina'),
			Array ('font-name' => 'Aguafina Script','css-name' => 'Aguafina+Script'),
			Array ('font-name' => 'Aladin','css-name' => 'Aladin'),
			Array ('font-name' => 'Aldrich','css-name' => 'Aldrich'),
			Array ('font-name' => 'Alice','css-name' => 'Alice'),
			Array ('font-name' => 'Alike Angular','css-name' => 'Alike+Angular'),
			Array ('font-name' => 'Alike','css-name' => 'Alike'),
			Array ('font-name' => 'Allan','css-name' => 'Allan'),
			Array ('font-name' => 'Allerta Stencil','css-name' => 'Allerta+Stencil'),
			Array ('font-name' => 'Allerta','css-name' => 'Allerta'),
			Array ('font-name' => 'Amaranth','css-name' => 'Amaranth'),
			Array ('font-name' => 'Amatic SC','css-name' => 'Amatic+SC'),
			Array ('font-name' => 'Andada','css-name' => 'Andada'),
			Array ('font-name' => 'Andika','css-name' => 'Andika'),
			Array ('font-name' => 'Annie Use Your Telescope','css-name' => 'Annie+Use+Your+Telescope'),
			Array ('font-name' => 'Anonymous Pro','css-name' => 'Anonymous+Pro'),
			Array ('font-name' => 'Antic','css-name' => 'Antic'),
			Array ('font-name' => 'Anton','css-name' => 'Anton'),
			Array ('font-name' => 'Arapey','css-name' => 'Arapey'),
			Array ('font-name' => 'Architects Daughter','css-name' => 'Architects+Daughter'),
			Array ('font-name' => 'Arimo','css-name' => 'Arimo'),
			Array ('font-name' => 'Artifika','css-name' => 'Artifika'),
			Array ('font-name' => 'Arvo','css-name' => 'Arvo'),
			Array ('font-name' => 'Asset','css-name' => 'Asset'),
			Array ('font-name' => 'Astloch','css-name' => 'Astloch'),
			Array ('font-name' => 'Atomic Age','css-name' => 'Atomic+Age'),
			Array ('font-name' => 'Aubrey','css-name' => 'Aubrey'),
			Array ('font-name' => 'Bangers','css-name' => 'Bangers'),
			Array ('font-name' => 'Bentham','css-name' => 'Bentham'),
			Array ('font-name' => 'Bevan','css-name' => 'Bevan'),
			Array ('font-name' => 'Bigshot One','css-name' => 'Bigshot+One'),
			Array ('font-name' => 'Bitter','css-name' => 'Bitter'),
			Array ('font-name' => 'Black Ops One','css-name' => 'Black+Ops+One'),
			Array ('font-name' => 'Bowlby One SC','css-name' => 'Bowlby+One+SC'),
			Array ('font-name' => 'Bowlby One','css-name' => 'Bowlby+One'),
			Array ('font-name' => 'Brawler','css-name' => 'Brawler'),
			Array ('font-name' => 'Bubblegum Sans','css-name' => 'Bubblegum+Sans'),
			Array ('font-name' => 'Butcherman Caps','css-name' => 'Butcherman+Caps'),
			Array ('font-name' => 'Cabin Condensed','css-name' => 'Cabin+Condensed'),
			Array ('font-name' => 'Cabin Sketch','css-name' => 'Cabin+Sketch'),
			Array ('font-name' => 'Cabin','css-name' => 'Cabin'),
			Array ('font-name' => 'Cagliostro','css-name' => 'Cagliostro'),
			Array ('font-name' => 'Calligraffitti','css-name' => 'Calligraffitti'),
			Array ('font-name' => 'Candal','css-name' => 'Candal'),
			Array ('font-name' => 'Cantarell','css-name' => 'Cantarell'),
			Array ('font-name' => 'Cardo','css-name' => 'Cardo'),
			Array ('font-name' => 'Carme','css-name' => 'Carme'),
			Array ('font-name' => 'Carter One','css-name' => 'Carter+One'),
			Array ('font-name' => 'Caudex','css-name' => 'Caudex'),
			Array ('font-name' => 'Cedarville Cursive','css-name' => 'Cedarville+Cursive'),
			Array ('font-name' => 'Changa One','css-name' => 'Changa+One'),
			Array ('font-name' => 'Cherry Cream Soda','css-name' => 'Cherry+Cream+Soda'),
			Array ('font-name' => 'Chewy','css-name' => 'Chewy'),
			Array ('font-name' => 'Chicle','css-name' => 'Chicle'),
			Array ('font-name' => 'Chivo','css-name' => 'Chivo'),
			Array ('font-name' => 'Coda','css-name' => 'Coda'),
			Array ('font-name' => 'Comfortaa','css-name' => 'Comfortaa'),
			Array ('font-name' => 'Coming Soon','css-name' => 'Coming+Soon'),
			Array ('font-name' => 'Contrail One','css-name' => 'Contrail+One'),
			Array ('font-name' => 'Convergence','css-name' => 'Convergence'),
			Array ('font-name' => 'Cookie','css-name' => 'Cookie'),
			Array ('font-name' => 'Copse','css-name' => 'Copse'),
			Array ('font-name' => 'Corben','css-name' => 'Corben'),
			Array ('font-name' => 'Cousine','css-name' => 'Cousine'),
			Array ('font-name' => 'Coustard','css-name' => 'Coustard'),
			Array ('font-name' => 'Covered By Your Grace','css-name' => 'Covered+By+Your+Grace'),
			Array ('font-name' => 'Crafty Girls','css-name' => 'Crafty+Girls'),
			Array ('font-name' => 'Creepster Caps','css-name' => 'Creepster+Caps'),
			Array ('font-name' => 'Crushed','css-name' => 'Crushed'),
			Array ('font-name' => 'Cuprum','css-name' => 'Cuprum'),
			Array ('font-name' => 'Damion','css-name' => 'Damion'),
			Array ('font-name' => 'Dancing Script','css-name' => 'Dancing+Script'),
			Array ('font-name' => 'Dawning of a New Day','css-name' => 'Dawning+of+a+New+Day'),
			Array ('font-name' => 'Days One','css-name' => 'Days+One'),
			Array ('font-name' => 'Delius Swash Caps','css-name' => 'Delius+Swash+Caps'),
			Array ('font-name' => 'Delius Unicase','css-name' => 'Delius+Unicase'),
			Array ('font-name' => 'Delius','css-name' => 'Delius'),
			Array ('font-name' => 'Devonshire','css-name' => 'Devonshire'),
			Array ('font-name' => 'Didact Gothic','css-name' => 'Didact+Gothic'),
			Array ('font-name' => 'Dorsa','css-name' => 'Dorsa'),
			Array ('font-name' => 'Dr Sugiyama','css-name' => 'Dr+Sugiyama'),
			Array ('font-name' => 'Droid Sans Mono','css-name' => 'Droid+Sans+Mono'),
			Array ('font-name' => 'Droid Sans','css-name' => 'Droid+Sans'),
			Array ('font-name' => 'Droid Serif','css-name' => 'Droid+Serif'),
			Array ('font-name' => 'EB Garamond','css-name' => 'EB+Garamond'),
			Array ('font-name' => 'Eater Caps','css-name' => 'Eater+Caps'),
			Array ('font-name' => 'Expletus Sans','css-name' => 'Expletus+Sans'),
			Array ('font-name' => 'Fanwood Text','css-name' => 'Fanwood+Text'),
			Array ('font-name' => 'Federant','css-name' => 'Federant'),
			Array ('font-name' => 'Federo','css-name' => 'Federo'),
			Array ('font-name' => 'Fjord One','css-name' => 'Fjord+One'),
			Array ('font-name' => 'Fondamento','css-name' => 'Fondamento'),
			Array ('font-name' => 'Fontdiner Swanky','css-name' => 'Fontdiner+Swanky'),
			Array ('font-name' => 'Forum','css-name' => 'Forum'),
			Array ('font-name' => 'Francois One','css-name' => 'Francois+One'),
			Array ('font-name' => 'Gentium Basic','css-name' => 'Gentium+Basic'),
			Array ('font-name' => 'Gentium Book Basic','css-name' => 'Gentium+Book+Basic'),
			Array ('font-name' => 'Geo','css-name' => 'Geo'),
			Array ('font-name' => 'Geostar Fill','css-name' => 'Geostar+Fill'),
			Array ('font-name' => 'Geostar','css-name' => 'Geostar'),
			Array ('font-name' => 'Give You Glory','css-name' => 'Give+You+Glory'),
			Array ('font-name' => 'Gloria Hallelujah','css-name' => 'Gloria+Hallelujah'),
			Array ('font-name' => 'Goblin One','css-name' => 'Goblin+One'),
			Array ('font-name' => 'Gochi Hand','css-name' => 'Gochi+Hand'),
			Array ('font-name' => 'Gravitas One','css-name' => 'Gravitas+One'),
			Array ('font-name' => 'Gruppo','css-name' => 'Gruppo'),
			Array ('font-name' => 'Hammersmith One','css-name' => 'Hammersmith+One'),
			Array ('font-name' => 'Herr Von Muellerhoff','css-name' => 'Herr+Von+Muellerhoff'),
			Array ('font-name' => 'Holtwood One SC','css-name' => 'Holtwood+One+SC'),
			Array ('font-name' => 'Homemade Apple','css-name' => 'Homemade+Apple'),
			Array ('font-name' => 'IM Fell DW Pica SC','css-name' => 'IM+Fell+DW+Pica+SC'),
			Array ('font-name' => 'IM Fell DW Pica','css-name' => 'IM+Fell+DW+Pica'),
			Array ('font-name' => 'IM Fell Double Pica SC','css-name' => 'IM+Fell+Double+Pica+SC'),
			Array ('font-name' => 'IM Fell Double Pica','css-name' => 'IM+Fell+Double+Pica'),
			Array ('font-name' => 'IM Fell English SC','css-name' => 'IM+Fell+English+SC'),
			Array ('font-name' => 'IM Fell English','css-name' => 'IM+Fell+English'),
			Array ('font-name' => 'IM Fell French Canon SC','css-name' => 'IM+Fell+French+Canon+SC'),
			Array ('font-name' => 'IM Fell French Canon','css-name' => 'IM+Fell+French+Canon'),
			Array ('font-name' => 'IM Fell Great Primer SC','css-name' => 'IM+Fell+Great+Primer+SC'),
			Array ('font-name' => 'IM Fell Great Primer','css-name' => 'IM+Fell+Great+Primer'),
			Array ('font-name' => 'Iceland','css-name' => 'Iceland'),
			Array ('font-name' => 'Inconsolata','css-name' => 'Inconsolata'),
			Array ('font-name' => 'Indie Flower','css-name' => 'Indie+Flower'),
			Array ('font-name' => 'Irish Grover','css-name' => 'Irish+Grover'),
			Array ('font-name' => 'Istok Web','css-name' => 'Istok+Web'),
			Array ('font-name' => 'Jockey One','css-name' => 'Jockey+One'),
			Array ('font-name' => 'Josefin Sans','css-name' => 'Josefin+Sans'),
			Array ('font-name' => 'Josefin Slab','css-name' => 'Josefin+Slab'),
			Array ('font-name' => 'Judson','css-name' => 'Judson'),
			Array ('font-name' => 'Julee','css-name' => 'Julee'),
			Array ('font-name' => 'Jura','css-name' => 'Jura'),
			Array ('font-name' => 'Just Another Hand','css-name' => 'Just+Another+Hand'),
			Array ('font-name' => 'Just Me Again Down Here','css-name' => 'Just+Me+Again+Down+Here'),
			Array ('font-name' => 'Kameron','css-name' => 'Kameron'),
			Array ('font-name' => 'Kelly Slab','css-name' => 'Kelly+Slab'),
			Array ('font-name' => 'Kenia','css-name' => 'Kenia'),
			Array ('font-name' => 'Knewave','css-name' => 'Knewave'),
			Array ('font-name' => 'Kranky','css-name' => 'Kranky'),
			Array ('font-name' => 'Kreon','css-name' => 'Kreon'),
			Array ('font-name' => 'Kristi','css-name' => 'Kristi'),
			Array ('font-name' => 'La Belle Aurore','css-name' => 'La+Belle+Aurore'),
			Array ('font-name' => 'Lancelot','css-name' => 'Lancelot'),
			Array ('font-name' => 'Lato','css-name' => 'Lato'),
			Array ('font-name' => 'League Script','css-name' => 'League+Script'),
			Array ('font-name' => 'Leckerli One','css-name' => 'Leckerli+One'),
			Array ('font-name' => 'Lekton','css-name' => 'Lekton'),
			Array ('font-name' => 'Lemon','css-name' => 'Lemon'),
			Array ('font-name' => 'Limelight','css-name' => 'Limelight'),
			Array ('font-name' => 'Linden Hill','css-name' => 'Linden+Hill'),
			Array ('font-name' => 'Lobster Two','css-name' => 'Lobster+Two'),
			Array ('font-name' => 'Lobster','css-name' => 'Lobster'),
			Array ('font-name' => 'Lora','css-name' => 'Lora'),
			Array ('font-name' => 'Love Ya Like A Sister','css-name' => 'Love+Ya+Like+A+Sister'),
			Array ('font-name' => 'Loved by the King','css-name' => 'Loved+by+the+King'),
			Array ('font-name' => 'Luckiest Guy','css-name' => 'Luckiest+Guy'),
			Array ('font-name' => 'Maiden Orange','css-name' => 'Maiden+Orange'),
			Array ('font-name' => 'Mako','css-name' => 'Mako'),
			Array ('font-name' => 'Marck Script','css-name' => 'Marck+Script'),
			Array ('font-name' => 'Marvel','css-name' => 'Marvel'),
			Array ('font-name' => 'Mate SC','css-name' => 'Mate+SC'),
			Array ('font-name' => 'Mate','css-name' => 'Mate'),
			Array ('font-name' => 'Maven Pro','css-name' => 'Maven+Pro'),
			Array ('font-name' => 'Meddon','css-name' => 'Meddon'),
			Array ('font-name' => 'MedievalSharp','css-name' => 'MedievalSharp'),
			Array ('font-name' => 'Megrim','css-name' => 'Megrim'),
			Array ('font-name' => 'Merienda One','css-name' => 'Merienda+One'),
			Array ('font-name' => 'Merriweather','css-name' => 'Merriweather'),
			Array ('font-name' => 'Metrophobic','css-name' => 'Metrophobic'),
			Array ('font-name' => 'Michroma','css-name' => 'Michroma'),
			Array ('font-name' => 'Miltonian Tattoo','css-name' => 'Miltonian+Tattoo'),
			Array ('font-name' => 'Miltonian','css-name' => 'Miltonian'),
			Array ('font-name' => 'Miss Fajardose','css-name' => 'Miss+Fajardose'),
			Array ('font-name' => 'Miss Saint Delafield','css-name' => 'Miss+Saint+Delafield'),
			Array ('font-name' => 'Modern Antiqua','css-name' => 'Modern+Antiqua'),
			Array ('font-name' => 'Molengo','css-name' => 'Molengo'),
			Array ('font-name' => 'Monofett','css-name' => 'Monofett'),
			Array ('font-name' => 'Monoton','css-name' => 'Monoton'),
			Array ('font-name' => 'Monsieur La Doulaise','css-name' => 'Monsieur+La+Doulaise'),
			Array ('font-name' => 'Montez','css-name' => 'Montez'),
			Array ('font-name' => 'Mountains of Christmas','css-name' => 'Mountains+of+Christmas'),
			Array ('font-name' => 'Mr Bedford','css-name' => 'Mr+Bedford'),
			Array ('font-name' => 'Mr Dafoe','css-name' => 'Mr+Dafoe'),
			Array ('font-name' => 'Mr De Haviland','css-name' => 'Mr+De+Haviland'),
			Array ('font-name' => 'Mrs Sheppards','css-name' => 'Mrs+Sheppards'),
			Array ('font-name' => 'Muli','css-name' => 'Muli'),
			Array ('font-name' => 'Neucha','css-name' => 'Neucha'),
			Array ('font-name' => 'Neuton','css-name' => 'Neuton'),
			Array ('font-name' => 'News Cycle','css-name' => 'News+Cycle'),
			Array ('font-name' => 'Niconne','css-name' => 'Niconne'),
			Array ('font-name' => 'Nixie One','css-name' => 'Nixie+One'),
			Array ('font-name' => 'Nobile','css-name' => 'Nobile'),
			Array ('font-name' => 'Nosifer Caps','css-name' => 'Nosifer+Caps'),
			Array ('font-name' => 'Nothing You Could Do','css-name' => 'Nothing+You+Could+Do'),
			Array ('font-name' => 'Nova Cut','css-name' => 'Nova+Cut'),
			Array ('font-name' => 'Nova Flat','css-name' => 'Nova+Flat'),
			Array ('font-name' => 'Nova Mono','css-name' => 'Nova+Mono'),
			Array ('font-name' => 'Nova Oval','css-name' => 'Nova+Oval'),
			Array ('font-name' => 'Nova Round','css-name' => 'Nova+Round'),
			Array ('font-name' => 'Nova Script','css-name' => 'Nova+Script'),
			Array ('font-name' => 'Nova Slim','css-name' => 'Nova+Slim'),
			Array ('font-name' => 'Nova Square','css-name' => 'Nova+Square'),
			Array ('font-name' => 'Numans','css-name' => 'Numans'),
			Array ('font-name' => 'Nunito','css-name' => 'Nunito'),
			Array ('font-name' => 'Old Standard TT','css-name' => 'Old+Standard+TT'),
			Array ('font-name' => 'Open Sans','css-name' => 'Open+Sans'),
			Array ('font-name' => 'Orbitron','css-name' => 'Orbitron'),
			Array ('font-name' => 'Oswald','css-name' => 'Oswald'),
			Array ('font-name' => 'Over the Rainbow','css-name' => 'Over+the+Rainbow'),
			Array ('font-name' => 'Ovo','css-name' => 'Ovo'),
			Array ('font-name' => 'PT Sans Caption','css-name' => 'PT+Sans+Caption'),
			Array ('font-name' => 'PT Sans Narrow','css-name' => 'PT+Sans+Narrow'),
			Array ('font-name' => 'PT Sans','css-name' => 'PT+Sans'),
			Array ('font-name' => 'PT Serif Caption','css-name' => 'PT+Serif+Caption'),
			Array ('font-name' => 'PT Serif','css-name' => 'PT+Serif'),
			Array ('font-name' => 'Pacifico','css-name' => 'Pacifico'),
			Array ('font-name' => 'Passero One','css-name' => 'Passero+One'),
			Array ('font-name' => 'Patrick Hand','css-name' => 'Patrick+Hand'),
			Array ('font-name' => 'Paytone One','css-name' => 'Paytone+One'),
			Array ('font-name' => 'Permanent Marker','css-name' => 'Permanent+Marker'),
			Array ('font-name' => 'Petrona','css-name' => 'Petrona'),
			Array ('font-name' => 'Philosopher','css-name' => 'Philosopher'),
			Array ('font-name' => 'Piedra','css-name' => 'Piedra'),
			Array ('font-name' => 'Pinyon Script','css-name' => 'Pinyon+Script'),
			Array ('font-name' => 'Play','css-name' => 'Play'),
			Array ('font-name' => 'Playfair Display','css-name' => 'Playfair+Display'),
			Array ('font-name' => 'Podkova','css-name' => 'Podkova'),
			Array ('font-name' => 'Poller One','css-name' => 'Poller+One'),
			Array ('font-name' => 'Poly','css-name' => 'Poly'),
			Array ('font-name' => 'Pompiere','css-name' => 'Pompiere'),
			Array ('font-name' => 'Prata','css-name' => 'Prata'),
			Array ('font-name' => 'Prociono','css-name' => 'Prociono'),
			Array ('font-name' => 'Puritan','css-name' => 'Puritan'),
			Array ('font-name' => 'Quattrocento Sans','css-name' => 'Quattrocento+Sans'),
			Array ('font-name' => 'Quattrocento','css-name' => 'Quattrocento'),
			Array ('font-name' => 'Questrial','css-name' => 'Questrial'),
			Array ('font-name' => 'Quicksand','css-name' => 'Quicksand'),
			Array ('font-name' => 'Radley','css-name' => 'Radley'),
			Array ('font-name' => 'Raleway','css-name' => 'Raleway'),
			Array ('font-name' => 'Rammetto One','css-name' => 'Rammetto+One'),
			Array ('font-name' => 'Rancho','css-name' => 'Rancho'),
			Array ('font-name' => 'Rationale','css-name' => 'Rationale'),
			Array ('font-name' => 'Redressed','css-name' => 'Redressed'),
			Array ('font-name' => 'Reenie Beanie','css-name' => 'Reenie+Beanie'),
			Array ('font-name' => 'Ribeye Marrow','css-name' => 'Ribeye+Marrow'),
			Array ('font-name' => 'Ribeye','css-name' => 'Ribeye'),
			Array ('font-name' => 'Righteous','css-name' => 'Righteous'),
			Array ('font-name' => 'Rochester','css-name' => 'Rochester'),
			Array ('font-name' => 'Rock Salt','css-name' => 'Rock+Salt'),
			Array ('font-name' => 'Rokkitt','css-name' => 'Rokkitt'),
			Array ('font-name' => 'Rosario','css-name' => 'Rosario'),
			Array ('font-name' => 'Ruslan Display','css-name' => 'Ruslan+Display'),
			Array ('font-name' => 'Salsa','css-name' => 'Salsa'),
			Array ('font-name' => 'Sancreek','css-name' => 'Sancreek'),
			Array ('font-name' => 'Sansita One','css-name' => 'Sansita+One'),
			Array ('font-name' => 'Satisfy','css-name' => 'Satisfy'),
			Array ('font-name' => 'Schoolbell','css-name' => 'Schoolbell'),
			Array ('font-name' => 'Shadows Into Light','css-name' => 'Shadows+Into+Light'),
			Array ('font-name' => 'Shanti','css-name' => 'Shanti'),
			Array ('font-name' => 'Short Stack','css-name' => 'Short+Stack'),
			Array ('font-name' => 'Sigmar One','css-name' => 'Sigmar+One'),
			Array ('font-name' => 'Signika Negative','css-name' => 'Signika+Negative'),
			Array ('font-name' => 'Signika','css-name' => 'Signika'),
			Array ('font-name' => 'Six Caps','css-name' => 'Six+Caps'),
			Array ('font-name' => 'Slackey','css-name' => 'Slackey'),
			Array ('font-name' => 'Smokum','css-name' => 'Smokum'),
			Array ('font-name' => 'Smythe','css-name' => 'Smythe'),
			Array ('font-name' => 'Sniglet','css-name' => 'Sniglet'),
			Array ('font-name' => 'Snippet','css-name' => 'Snippet'),
			Array ('font-name' => 'Sorts Mill Goudy','css-name' => 'Sorts+Mill+Goudy'),
			Array ('font-name' => 'Special Elite','css-name' => 'Special+Elite'),
			Array ('font-name' => 'Spinnaker','css-name' => 'Spinnaker'),
			Array ('font-name' => 'Spirax','css-name' => 'Spirax'),
			Array ('font-name' => 'Stardos Stencil','css-name' => 'Stardos+Stencil'),
			Array ('font-name' => 'Sue Ellen Francisco','css-name' => 'Sue+Ellen+Francisco'),
			Array ('font-name' => 'Sunshiney','css-name' => 'Sunshiney'),
			Array ('font-name' => 'Supermercado One','css-name' => 'Supermercado+One'),
			Array ('font-name' => 'Swanky and Moo Moo','css-name' => 'Swanky+and+Moo+Moo'),
			Array ('font-name' => 'Syncopate','css-name' => 'Syncopate'),
			Array ('font-name' => 'Tangerine','css-name' => 'Tangerine'),
			Array ('font-name' => 'Tenor Sans','css-name' => 'Tenor+Sans'),
			Array ('font-name' => 'Terminal Dosis','css-name' => 'Terminal+Dosis'),
			Array ('font-name' => 'The Girl Next Door','css-name' => 'The+Girl+Next+Door'),
			Array ('font-name' => 'Tienne','css-name' => 'Tienne'),
			Array ('font-name' => 'Tinos','css-name' => 'Tinos'),
			Array ('font-name' => 'Tulpen One','css-name' => 'Tulpen+One'),
			Array ('font-name' => 'Ubuntu Condensed','css-name' => 'Ubuntu+Condensed'),
			Array ('font-name' => 'Ubuntu Mono','css-name' => 'Ubuntu+Mono'),
			Array ('font-name' => 'Ubuntu','css-name' => 'Ubuntu'),
			Array ('font-name' => 'Ultra','css-name' => 'Ultra'),
			Array ('font-name' => 'UnifrakturMaguntia','css-name' => 'UnifrakturMaguntia'),
			Array ('font-name' => 'Unkempt','css-name' => 'Unkempt'),
			Array ('font-name' => 'Unlock','css-name' => 'Unlock'),
			Array ('font-name' => 'Unna','css-name' => 'Unna'),
			Array ('font-name' => 'VT323','css-name' => 'VT323'),
			Array ('font-name' => 'Varela Round','css-name' => 'Varela+Round'),
			Array ('font-name' => 'Varela','css-name' => 'Varela'),
			Array ('font-name' => 'Vast Shadow','css-name' => 'Vast+Shadow'),
			Array ('font-name' => 'Vibur','css-name' => 'Vibur'),
			Array ('font-name' => 'Vidaloka','css-name' => 'Vidaloka'),
			Array ('font-name' => 'Volkhov','css-name' => 'Volkhov'),
			Array ('font-name' => 'Vollkorn','css-name' => 'Vollkorn'),
			Array ('font-name' => 'Voltaire','css-name' => 'Voltaire'),
			Array ('font-name' => 'Waiting for the Sunrise','css-name' => 'Waiting+for+the+Sunrise'),
			Array ('font-name' => 'Wallpoet','css-name' => 'Wallpoet'),
			Array ('font-name' => 'Walter Turncoat','css-name' => 'Walter+Turncoat'),
			Array ('font-name' => 'Wire One','css-name' => 'Wire+One'),
			Array ('font-name' => 'Yanone Kaffeesatz','css-name' => 'Yanone+Kaffeesatz'),
			Array ('font-name' => 'Yellowtail','css-name' => 'Yellowtail'),
			Array ('font-name' => 'Yeseva One','css-name' => 'Yeseva+One'),
			Array ('font-name' => 'Zeyada','css-name' => 'Zeyada')
		);
		$this->_html .= '<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">
			<fieldset>
				<h3>'.$this->l('Graphical configuration options').'</h3>
				<div class="block high">
					<label>'.$this->l('Import Google Web Font').'</label>
					<span class="label">'.$this->l('Imported font').' :</span>
					<select name="ptm_googlefont" id="ptm_googlefont" onchange="fontPreview();">';
						foreach ($google_fonts_array as $google_font)
							$this->_html .= '<option value="'.$google_font['css-name'].'" '.($google_font['css-name'] == Configuration::get('PTM_GOOGLEFONT') ? 'selected="selected"' : '').'>'.$google_font['font-name'].'</option>';
					$this->_html .= '</select>
					<div style="height:20px;line-height:20px;margin:8px 0 10px 5px">
						<link id="googleFontLink" href="http://fonts.googleapis.com/css?family='.Configuration::get('PTM_GOOGLEFONT').'" rel="stylesheet" type="text/css" />
						<span id="googleFontPreview" style="font-family:'.str_replace('+', ' ', Configuration::get('PTM_GOOGLEFONT')).';font-size:16px;font-weight:300">'.str_replace('+', ' ', Configuration::get('PTM_GOOGLEFONT')).'</span>
					</div>
					<p>'.$this->l('Import a Google Web Font to be able to use it in the shop').'</p>
				</div>
				<div class="block small higher">
					<label>'.$this->l('Fonts family').'</label>
					<span class="label">'.$this->l('Base font').' :</span>
					<input type="text" size="16" name="ptm_basefontfamily" value="'.Configuration::get('PTM_BASEFONTFAMILY').'" />
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Alt font').' :</span>
					<input type="text" size="16" name="ptm_altfontfamily" value="'.Configuration::get('PTM_ALTFONTFAMILY').'" />
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Prices font').' :</span>
					<input type="text" size="16" name="ptm_pricesfontfamily" value="'.Configuration::get('PTM_PRICESFONTFAMILY').'" />
					<p>'.$this->l('Set the family of the theme fonts').'</p>
				</div>
				<div class="block small higher">
					<label>'.$this->l('Fonts size').'</label>
					<span class="label">'.$this->l('Base font').' :</span>
					<input type="text" size="4" maxlength="2" name="ptm_basefontsize" value="'.Configuration::get('PTM_BASEFONTSIZE').'" /><span class="unity">px</span>
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Alt font').' :</span>
					<input type="text" size="4" maxlength="2" name="ptm_altfontsize" value="'.Configuration::get('PTM_ALTFONTSIZE').'" /><span class="unity">px</span>
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Prices font').' :</span>
					<input type="text" size="4" maxlength="2" name="ptm_pricesfontsize" value="'.Configuration::get('PTM_PRICESFONTSIZE').'" /><span class="unity">px</span>
					<p>'.$this->l('Set the size of the theme fonts').'</p>
				</div>
				<div class="block small high">
					<label>'.$this->l('Theme colors').'</label>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Base color').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ptm_basecolor" value="'.Configuration::get('PTM_BASECOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('PTM_BASECOLOR').'"></span>
					</div>
					<div class="spaceSmall"></div>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Alt color').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ptm_altcolor" value="'.Configuration::get('PTM_ALTCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('PTM_ALTCOLOR').'"></span>
					</div>
					<p>'.$this->l('Set the base color and the alt color of the theme').'</p>
				</div>
				<div class="block small high">
					<label>'.$this->l('Fonts colors').'</label>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Base font').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ptm_basefontcolor" value="'.Configuration::get('PTM_BASEFONTCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('PTM_BASEFONTCOLOR').'"></span>
					</div>
					<div class="spaceSmall"></div>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Prices font').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ptm_pricesfontcolor" value="'.Configuration::get('PTM_PRICESFONTCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('PTM_PRICESFONTCOLOR').'"></span>
					</div>
					<p>'.$this->l('Set the color of the theme fonts').'</p>
				</div>
				<div class="clear"></div>
				<div class="update"><input type="submit" name="submitStyle" value="'.$this->l('Update configuration').'" class="button" /></div>
			</fieldset>
		</form>';
	}

	public function configCSS()
	{
		$dir = dirname(__FILE__).'/theme/less/';
		$files = scandir($dir);
		$cnt = count($files);
		$this->_html .= '<script type="text/javascript">var baseDir = "'.$this->_path.'theme/less/";</script>
		<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">
			<fieldset>
				<h3>'.$this->l('Warning').'</h3>
				<div class="warning">'.$this->l('Editing CSS file is only for experienced users. Edit these files only if you know what you are doing.').'</div>
				<div class="clear"></div>
				<div class="space"></div>
				<h3>'.$this->l('List of CSS files (LESS files)').'</h3>
				<div style="max-width:350px;height:245px;overflow:auto;margin-top:10px">
					<table class="table" style="margin-top:0">
						<th>'.$this->l('Filename').'</th>
						<th class="center">'.$this->l('Edit').'</th>';
						for ($i = 0; $i < $cnt; $i++)
							if (preg_match('/.less$/', $files[$i]))
							{
								$link = '<a href="#editor_container" onclick="loadFile('.$i.');">';
								$link .= '<img src="'._PS_ADMIN_IMG_.'edit.gif" /></a>
								<input type="hidden" name="fileId" id="fileId" value="'.$i.'" />
								<input type="hidden" name="fileName_'.$i.'" id="fileName_'.$i.'" value="'.$files[$i].'" />';
								$this->_html .= '<tr>
									<td>'.$files[$i].'</td>
									<td class="center">'.$link.'</td>
								</tr>';
							}
					$this->_html .= '</table>
				</div>
				<div>';
					$this->_html .= '<div id="editor_container">
						<textarea cols="80" rows="30" id="contentCSS" name="contentCSS"></textarea>
						<input type="hidden" name="fileName" id="fileName" value="" />
					</div>
				</div>
				<div class="clear"></div>
				<div class="update"><input type="submit" name="submitCSS" value="'.$this->l('Update the CSS file').'" class="button" /></div>
			</fieldset>
		</form>';
	}

	public function putFileContents()
	{
		$filename = Tools::getValue('fileName');
		$file = dirname(__FILE__).'/theme/less/'.$filename;
		$balises = array('content:"e', 'content:"f');
		$replace = array('content:"\\e', 'content:"\\f');
		$data = str_replace($balises, $replace, Tools::getValue('contentCSS'));
		$contents = $data;
		if ($filename)
		{
			file_put_contents($file, $contents);
			return true;
		}
		else
			return false;
	}

	public function cacheCompileLess($input_file, $output_file)
	{
		if (!class_exists('lessc'))
			require_once dirname(__FILE__).'/lessc.inc.php';

		$cache_file = $input_file.'.cache';
		if (file_exists($cache_file))
			$cache = unserialize(Tools::file_get_contents($cache_file));
		else
			$cache = $input_file;

		$less = new lessc;
		$less->setVariables(array(
			'ptm_basefontfamily' => Configuration::get('PTM_BASEFONTFAMILY'),
			'ptm_altfontfamily' => Configuration::get('PTM_ALTFONTFAMILY'),
			'ptm_pricesfontfamily' => Configuration::get('PTM_PRICESFONTFAMILY'),
			'ptm_basefontsize' => Configuration::get('PTM_BASEFONTSIZE').'px',
			'ptm_altfontsize' => Configuration::get('PTM_ALTFONTSIZE').'px',
			'ptm_pricesfontsize' => Configuration::get('PTM_PRICESFONTSIZE').'px',
			'ptm_basecolor' => '#'.Configuration::get('PTM_BASECOLOR'),
			'ptm_altcolor' => '#'.Configuration::get('PTM_ALTCOLOR'),
			'ptm_basefontcolor' => '#'.Configuration::get('PTM_BASEFONTCOLOR'),
			'ptm_pricesfontcolor' => '#'.Configuration::get('PTM_PRICESFONTCOLOR')
		));

		$less->setFormatter('classic');
		$new_cache = $less->cachedCompile($cache);

		if (!is_array($cache) || $new_cache['updated'] > $cache['updated'])
		{
			file_put_contents($cache_file, serialize($new_cache));
			file_put_contents($output_file, $new_cache['compiled']);
		}
	}

	public function hookHeader()
	{
		$this->context->smarty->assign(array(
			'ptm_responsive' => Configuration::get('PTM_RESPONSIVE'),
			'ptm_column' => Configuration::get('PTM_COLUMN'),
			'ptm_quickview' => Configuration::get('PTM_QUICKVIEW'),
			'ptm_homebuttons' => Configuration::get('PTM_HOMEBUTTONS'),
			'ptm_homeproducts' => Configuration::get('PTM_HOMEPRODUCTS'),
			'ptm_subcatdisplay' => Configuration::get('PTM_SUBCATDISPLAY'),
			'ptm_subcat' => Configuration::get('PTM_SUBCAT'),
			'ptm_listdisplay' => Configuration::get('PTM_LISTDISPLAY'),
			'ptm_listbuttons' => Configuration::get('PTM_LISTBUTTONS'),
			'ptm_listproducts' => Configuration::get('PTM_LISTPRODUCTS'),
			'ptm_googlefont' => Configuration::get('PTM_GOOGLEFONT'),
			'PS_STOCK_MANAGEMENT' => Configuration::get('PS_STOCK_MANAGEMENT'),
			'imgSmallSize' => Image::getSize('small'),
			'imgMediumSize' => Image::getSize('medium'),
			'imgHomeSize' => Image::getSize('home')
		));

		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			$this->context->smarty->assign(array('HOOK_TOP_COLUMN' => Hook::exec('topColumn')));
		else
			$this->context->smarty->assign(array('HOOK_TOP_COLUMN' => Module::hookExec('topColumn')));

		$ptm_themepath = Configuration::get('PTM_THEMEPATH');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/theme-global.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/global.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/theme-responsive.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/responsive.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/theme-maintenance.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/maintenance.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-advancedeucompliance.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/advancedeucompliance/views/css/aeuc_front.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockbestsellers.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockbestsellers/blockbestsellers.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockbestsellers/blockbestsellers.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockbestsellers/css/blockbestsellers.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockcart.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockcart/blockcart.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockcart/blockcart.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockcart/css/blockcart.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockcontact.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockcontact/blockcontact.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockcontact/blockcontact.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockcontact/css/blockcontact.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockcurrencies.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockcurrencies/blockcurrencies.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockcurrencies/blockcurrencies.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockcurrencies/css/blockcurrencies.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blocklanguages.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocklanguages/blocklanguages.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocklanguages/blocklanguages.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocklanguages/css/blocklanguages.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blocklayered.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocklayered/blocklayered.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocklayered/blocklayered.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocklayered/blocklayered-15.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocklayered/blocklayered.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocklayered/css/blocklayered.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocklayered/blocklayered.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocklayered/css/blocklayered-15.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockmyaccountfooter.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockmyaccountfooter/blockmyaccount.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockmyaccountfooter/blockmyaccount.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockmyaccountfooter/css/blockmyaccount.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blocknewproducts.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocknewproducts/blocknewproducts.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocknewproducts/blocknewproducts.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocknewproducts/css/blocknewproducts.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blocknewsletter.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocknewsletter/blocknewsletter.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocknewsletter/blocknewsletter.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocknewsletter/css/blocknewsletter.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockpermanentlinks.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockpermanentlinks/blockpermanentlinks.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockpermanentlinks/blockpermanentlinks.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockpermanentlinks/css/blockpermanentlinks.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockreinsurance.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockreinsurance/style.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockreinsurance/style.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockreinsurance/css/style.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blocksearch.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocksearch/blocksearch.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocksearch/blocksearch.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocksearch/css/blocksearch.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockspecials.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockspecials/blockspecials.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockspecials/blockspecials.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockspecials/css/blockspecials.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockstore.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockstore/blockstore.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockstore/blockstore.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockstore/css/blockstore.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blocktags.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocktags/blocktags.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocktags/blocktags.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocktags/css/blocktags.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blocktopmenu.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blocktopmenu/css/superfish-modified.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockuserinfo.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockuserinfo/blockuserinfo.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockuserinfo/blockuserinfo.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockuserinfo/css/blockuserinfo.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockviewed.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockviewed/blockviewed.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockviewed/blockviewed.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockviewed/css/blockviewed.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockwishlist.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockwishlist/blockwishlist.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockwishlist/blockwishlist.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/blockwishlist/css/blockwishlist.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-carriercompare.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/carriercompare/style.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/carriercompare/style.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/carriercompare/css/style.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-crossselling.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/crossselling/crossselling.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/crossselling/crossselling.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/crossselling/css/crossselling.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-editorial.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/editorial/editorial.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/editorial/editorial.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/editorial/css/editorial.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-favoriteproducts.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/favoriteproducts/favoriteproducts.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/favoriteproducts/favoriteproducts.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/favoriteproducts/css/favoriteproducts.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-homeslider.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/homeslider/bx_styles.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/homeslider/bx_styles.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/homeslider/homeslider.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/homeslider/bx_styles.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/homeslider/css/bx_styles.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/homeslider/bx_styles.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/homeslider/css/homeslider.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-mailalerts.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/mailalerts/mailalerts.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/mailalerts/mailalerts.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/mailalerts/css/mailalerts.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-productcomments.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/productcomments/productcomments.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/productcomments/productcomments.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/productcomments/css/productcomments.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-productscategory.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/productscategory/productscategory.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/productscategory/productscategory.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/productscategory/css/productscategory.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-sendtoafriend.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/sendtoafriend/sendtoafriend.css');
		copy(_PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/sendtoafriend/sendtoafriend.css', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/sendtoafriend/css/sendtoafriend.css');

		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-themeconfigurator.less', _PS_ALL_THEMES_DIR_.''.$ptm_themepath.'/css/modules/themeconfigurator/css/hooks.css');

		if (file_exists(dirname(__FILE__).'/theme/install/modules-compile.php'))
			require_once(dirname(__FILE__).'/theme/install/modules-compile.php');

		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			$page_name = Dispatcher::getInstance()->getController();
			if (Configuration::get('PTM_RESPONSIVE') == 1)
				$this->context->controller->addCSS(_THEME_CSS_DIR_.'responsive.css', 'all');
			if (Configuration::get('PTM_QUICKVIEW') == 1 && $page_name != 'product')
				$this->context->controller->addCSS(__PS_BASE_URI__.'js/jquery/plugins/fancybox/jquery.fancybox.css', 'all');
			if (Configuration::get('PTM_QUICKVIEW') == 1 && $page_name != 'product')
				$this->context->controller->addJS(__PS_BASE_URI__.'js/jquery/plugins/fancybox/jquery.fancybox.js', 'all');
			$this->context->controller->addJS(_THEME_JS_DIR_.'formstyle.js', 'all');
			$this->context->controller->addJS(_THEME_JS_DIR_.'gridorlist.js', 'all');
			if (Configuration::get('PTM_QUICKVIEW') == 1)
				$this->context->controller->addJS(_THEME_JS_DIR_.'quickview.js', 'all');
		}
		else
		{
			if (Configuration::get('PTM_RESPONSIVE') == 1)
				Tools::addCSS(_THEME_CSS_DIR_.'responsive.css', 'all');
			if (Configuration::get('PTM_QUICKVIEW') == 1 && basename(Tools::safeOutput($_SERVER['SCRIPT_NAME'])) != 'product.php')
				Tools::addCSS(__PS_BASE_URI__.'css/jquery.fancybox-1.3.4.css', 'all');
			if (Configuration::get('PTM_QUICKVIEW') == 1 && basename(Tools::safeOutput($_SERVER['SCRIPT_NAME'])) != 'product.php')
				Tools::addJS(__PS_BASE_URI__.'js/jquery/jquery.fancybox-1.3.4.js', 'all');
			Tools::addJS(_THEME_JS_DIR_.'formstyle.js');
			Tools::addJS(_THEME_JS_DIR_.'gridorlist.js');
			if (Configuration::get('PTM_QUICKVIEW') == 1)
				Tools::addJS(_THEME_JS_DIR_.'quickview.js');
		}
	}
}