/**
* Module Prestashop FooterCustom
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*/

function changeTab(name) {
	if (document.getElementById('tab_'+id_tab) != null) {
		document.getElementById('tab_'+id_tab).className = 'tab';
		document.getElementById('tab_'+name).className = 'tab active';
		document.getElementById('content_'+id_tab).style.display = 'none';
		document.getElementById('content_'+name).style.display = 'block';
		id_tab = name;
		editAreaLoader.init({
			id: "contentCSS",
			syntax: "css",
			start_highlight: true,
			allow_resize: "no",
			allow_toggle: false,
			toolbar: "search, |, go_to_line, |, highlight"
		});
	}
}

$(document).ready(function() {
	$.each($('.colorpickerSelect'),function() {
		var $target = $(this);
		$(this).find('.colorpickerInput').ColorPicker({
			onSubmit: function(hsb, hex, rgb, el) {
				$(el).val(hex);
				$(el).ColorPickerHide();
			},
			onBeforeShow: function () {
				$(this).ColorPickerSetColor(this.value);
			},
			onChange: function (hsb, hex, rgb) {
				$target.find('.colorpickerPreview').css('backgroundColor', '#' + hex);
			}
		})
		.bind('keyup', function() {
			$(this).ColorPickerSetColor(this.value);
		});
	});
});

function nl2br(str, is_xhtml) {
    var breakTag = (is_xhtml || typeof is_xhtml === 'undefined') ? '<br />' : '<br>';
    return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1' + breakTag + '$2');
}

function loadFile(fileId) {
	getE('fileId').value = fileId;
	for (var i=0; i<=50; i++) {
		var fileName = getE('fileName_' + fileId).value;
	}
    var xhr;

	if (window.XMLHttpRequest) {
		xhr = new XMLHttpRequest();
	}
	else if (window.ActiveXObject) {
		try {
			xhr = new ActiveXObject("Msxml2.XMLHTTP");
		}
		catch (e) {
			try {
				xhr = new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch (e) {}
		}
	}
	
	xhr.onreadystatechange = function() {
		if (xhr.readyState == 4 && xhr.status == 200) {
			var new_file= {id: fileId, text: xhr.responseText, syntax: 'css', title: fileName};
			editAreaLoader.openFile('contentCSS', new_file);
			getE('fileName').value = fileName;
		}
		else if (xhr.readyState == 4 && xhr.status != 200) {
			alert('Une erreur est survenue !\n\nCode :' + xhr.status + '\nTexte : ' + xhr.statusText);
		}
	};
 
   xhr.open("GET", baseDir + fileName + '?nocache=' + Math.random(), true);
   xhr.send(null);
}

function blockEdit(blockId) {
	getE('id').value = blockId;
	var fc = parseInt(getE('languageNb').value - 1);
	for (var i=0; i<=fc; i++) {
		getE('titleInput_' + blocks[blockId][i * 5]).value = blocks[blockId][i * 5 + 1];
		getE('linkInput_' + blocks[blockId][i * 5]).value = blocks[blockId][i * 5 + 2];
		getE('inblockInput_' + blocks[blockId][i * 5]).value = blocks[blockId][i * 5 + 3];
		getE('positionInput_' + blocks[blockId][i * 5]).value = blocks[blockId][i * 5 + 4];
	}
	if (document.all) {
		getE('submitAddBlock').style.setAttribute('cssText', 'display:none');
		getE('submitEditBlock').style.setAttribute('cssText', 'display:block');
	}
	getE('submitAddBlock').setAttribute('style', 'display:none');
	getE('submitEditBlock').setAttribute('style', 'display:block');
}

function blockDelete(blockId) {
	document.location.replace(currentUrl+'&id='+blockId+'&token='+token);
}