{capture name=path}{l s='Payment'}{/capture}
{include file="$tpl_dir./breadcrumb.tpl"}
<link rel="stylesheet" href="{$module_dir}css/egrpayflow.css" />
<h2>{l s='Order summary' mod='egrpayflowpro'}</h2>

{assign var='current_step' value='payment'}
{include file="$tpl_dir./order-steps.tpl"}

{include file="$tpl_dir./errors.tpl"}

{if $httpssl == 1}

    {*<h3>{l s='Credit Card Payment'}</h3>*}
    <p>
        {*
        <img src="{$this_path}authorizenet.gif" alt="{l s='Credit Card' mod='egrpayflowpro'}" style="float:left; margin: 0px 10px 5px 0px;" />
        {l s='You have chosen to pay by credit card.' mod='egrpayflowpro'}
        <br/><br />
        *}
        {l s='Here is a short summary of your order:' mod='egrpayflowpro'}
    </p>

    {if isset($empty)}
        <p class="warning">{l s='Your shopping cart is empty.'}</p>
    {else}
        <div id="order-detail-content" class="table_block">
            <table id="cart_summary" class="std">
                <thead>
                    <tr>
                        <th class="cart_product first_item">{l s='Product' mod='egrpayflowpro'}</th>
                        <th class="cart_description item">{l s='Description' mod='egrpayflowpro'}</th>
                        <th class="cart_availability item">{l s='Avail.' mod='egrpayflowpro'}</th>
                        <th class="cart_unit item">{l s='Unit price' mod='egrpayflowpro'}</th>
                        <th class="cart_quantity item">{l s='Qty' mod='egrpayflowpro'}</th>
                        <th class="cart_total last_item">{l s='Total' mod='egrpayflowpro'}</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr class="cart_total_product">
                        <td colspan="5">{l s='Total products:' mod='egrpayflowpro'}</td>
                        <td class="price">{convertPrice price=$total_products_wt}</td>
                    </tr>
                    {if $total_discounts > 0}
                        <tr class="cart_total_voucher">
                            <td colspan="5">{l s='Total vouchers:' mod='egrpayflowpro'}</td>
                            <td class="price-discount">{convertPrice price=$total_discounts}</td>
                        </tr>
                    {/if}
                    {if $total_wrapping > 0}
                        <tr class="cart_total_voucher">
                            <td colspan="5">{l s='Total gift-wrapping:' mod='egrpayflowpro'}</td>
                            <td class="price-discount">{convertPrice price=$total_wrapping}</td>
                        </tr>
                    {/if}
                    {if $shippingCost > 0}
                        <tr class="cart_total_delivery">
                            <td colspan="5">{l s='Total shipping:' mod='egrpayflowpro'}</td>
                            <td class="price">{convertPrice price=$shippingCost}</td>
                        </tr>
                    {/if}
                    <tr class="cart_total_price">
                        <td colspan="5">{if !$carrier->id}{l s='Total:' mod='egrpayflowpro'}{else}{l s='Total:' mod='egrpayflowpro'}{/if}</td>
                        <td class="price">{convertPrice price=$total_price}</td>
                    </tr>
                </tfoot>
                <tbody>
                    {foreach from=$products item=product name=productLoop}
                        <tr class="{if $smarty.foreach.productLoop.last}last_item{elseif $smarty.foreach.productLoop.first}first_item{/if} {if $smarty.foreach.productLoop.index % 2}alternate_item{else}item{/if} cart_item">
                            <td class="cart_product">
                                <a href="{$link->getProductLink($product.id_product, $product.link_rewrite)|escape:'htmlall':'UTF-8'}">
                                    <img src="{$link->getImageLink($product.link_rewrite, $product.id_image, 'small_default')}" alt="{$product.name|escape:'htmlall':'UTF-8'}"/>
                                </a>
                            </td>
                            <td class="cart_description">
                                <h5><a href="{$link->getProductLink($product.id_product, $product.link_rewrite)|escape:'htmlall':'UTF-8'}">{$product.name|escape:'htmlall':'UTF-8'}</a></h5>
                            </td>

                            <td class="cart_availability">
                                {if $product.active AND ($product.allow_oosp OR $product.stock_quantity > 0)}
                                    <span class="label label-success">In stock</span>
                                {else}
                                    <span class="label label-success">Out of stock</span>
                                {/if}
                            </td>
                            <td class="cart_unit"><span class="price">{convertPrice price=$product.price_wt}</span></td>
                            <td class="cart_quantity">
                                <label class="product-quantity">{$product.cart_quantity|intval}</label>
                            </td>
                            <td class="cart_total"><span class="price" style="border-bottom: none;">{convertPrice price=$product.total_wt}</span></td>
                        </tr>
                    {/foreach}
                </tbody>
                {if $discounts}
                    <tbody>
                        {foreach from=$discounts item=discount name=discountLoop}
                            <tr class="cart_discount {if $smarty.foreach.discountLoop.last}last_item{elseif $smarty.foreach.discountLoop.first}first_item{else}item{/if}">
                                <td class="cart_discount_name" colspan="2">{$discount.name}</td>
                                <td class="cart_discount_description" colspan="3">{$discount.description}</td>
                                <td class="cart_discount_delete"><a href="{$base_dir_ssl}order.php?deleteDiscount={$discount.id_discount}" title="{l s='Delete' mod='egrpayflowpro'}"><img src="{$img_dir}icon/delete.gif" alt="{l s='Delete' mod='egrpayflowpro'}" class="icon" /></a></td>
                                <td class="cart_discount_price"><span class="price-discount">-{convertPrice price=$discount.value_real}</span></td>
                            </tr>
                        {/foreach}
                    </tbody>
                {/if}
            </table>
        </div>
    {/if}
    {$HOOK_SHOPPING_CART}

    {if $PayPalAPI_Supported_Currency==1}
        {literal}
            <style>
                #order-detail-content table#cart_summary{
                    border: 1px solid #d6d4d4;
                    border-bottom: 0;
                    border-right: 0;
                }
                #order-detail-content table#cart_summary th{
                    background: none repeat scroll 0 0 #fbfbfb;
                    border-bottom: 1px solid #d6d4d4;
                    border-right: 1px solid #d6d4d4;
                    color: #333333;
                    text-transform: none;
                    text-shadow: none;
                }
                #order-detail-content table#cart_summary td{
                    vertical-align: middle;
                }
                .cart_navigation a.button,.cart_navigation input.exclusive{
                    height: 45px;
                    line-height: 45px;
                    padding: 0 30px;
                }
                .cart_navigation input.exclusive{
                    float: right;
                }
                /*.account_creation label
                {
                    width:18%;
                }*/
                .account_creation p
                {

                }

                .account_creation
                {
                    margin-bottom:20px;
                    padding:20px;
                    border: 1px solid #d6d4d4;
                }
                .account_creation h3
                {
                    margin-top:0;
                    margin-bottom:20px;
                    padding-bottom:5px;
                    border-bottom: 1px solid #d6d4d4;
                }
                .account_creation label[for="year"]
                {
                    width:auto;
                }
                .sample-card-no
                {
                    color:#000;
                    margin-left:5px;
                }
                .card-name, .card-no
                {
                    width:40%;
                }
                #expMonth,#expYear {
                    width: 20%;
                }
                .product-quantity
                {
                    margin-right:10px;
                }
                .cart_quantity_up img, .cart_quantity_down img
                {
                    height:12px;
                }
                .month-left {
                    width: 20%;
                    float: left;
                }
                .month-left select#expMonth {
                    width: 90%;
                }
                @media only screen and (max-width:767px)
                {
                    .account_creation label, .account_creation label[for="year"]
                    {
                        width:100%;
                        max-width:400px;
                    }
                    .card-name, .card-no
                    {
                        width:94%;
                        max-width:300px;
                    }
                    #expMonth, #expYear
                    {
                        width:60%;
                    }
                    .sample-card-no
                    {
                        float:left;
                        clear:Both;
                        margin-left:0;
                        margin-bottom:5px;
                    }
                }
                @media only screen and (min-width:768px) and (max-width:1024px)
                {
                    .account_creation label
                    {
                        width:30%;
                    }
                } 
            </style>
        {/literal}
        <!--<h2 style="color:red;">{l s='Your currency might be changed' mod='egrpayflowpro'}</h2>-->
        <form action="{$request_uri}" method="post" id="account-creation_form" class="std">
            <fieldset class="account_creation">
                <h3>{l s='Card Details' mod='egrpayflowpro'}</h3>
                <p class="required">
                    <label for="cardName">{l s='Card Type' mod='egrpayflowpro'}</label><sup>*</sup>
                    <!--<input type="text" id="cardName" name="cardName" value="{if isset($cardName)}{$cardName|escape:'htmlall'|stripslashes}{/if}" />-->
                    <select class="card-name form-control" name="cardName" id="cardName">
                        <option>Select</option>
                        <option value="Visa" {if ($cardName == 'Visa')} selected="selected"{/if} >Visa</option>
                        <option value="MasterCard" {if ($cardName == 'MasterCard')} selected="selected"{/if}>MasterCard</option>
                        <option value="Discover" {if ($cardName == 'Discover')} selected="selected"{/if}>Discover</option>
                        <option value="Amex" {if ($cardName == 'Amex')} selected="selected"{/if}>American Express</option>
                    </select>                    
                </p>
                <p class="required">
                    <label for="cardNumber">{l s='Credit Card Number' mod='egrpayflowpro'}</label><sup>*</sup>
                    <input class="card-no form-control" type="text" id="cardNumber" name="cardNumber" value="{if isset($cardNumber)}{$cardNumber|escape:'htmlall'|stripslashes}{/if}" /><span class="sample-card-no">(eg:5105105105105100)</span>
                </p>
                <p class="required">
                <div class="month-left">
                    <label for="expMonth">{l s='Expiration Month' mod='egrpayflowpro'}</label>
                    <select id="expMonth" name="expMonth" class="form-control" style="width: 160px;" >
                        <option value="">-</option>
                        {foreach from=$months item=month}
                            <option value="{$month}" {if ($expMonth == $month)} selected="selected"{/if}>{l s="$month"}</option>
                        {/foreach}
                    </select>
                </div>
                <div class="year-left">
                    <label for="year">{l s='Year' mod='egrpayflowpro'}</label><sup>*</sup>
                    <select id="expYear" name="expYear" class="form-control" style="width: 160px;">
                        <option value="">-</option>
                        {foreach from=$years item=year}
                            <option value="{$year|escape:'htmlall':'UTF-8'}" {if ($expYear == $year)} selected="selected"{/if}>{$year|escape:'htmlall':'UTF-8'}</option>
                        {/foreach}
                    </select>   
                </div>
                </p>
                <p class="required">

                </p>
                <p class="required">
                    <label for="cardCode">{l s='CVV' mod='egrpayflowpro'}</label><sup>*</sup>
                    <input type="text" class="form-control" id="cardCode" name="cardCode"  maxlength="4"  style="width:50px;"value="{if isset($cardCode)}{$cardCode|escape:'htmlall'|stripslashes}{/if}" />
                </p>
            </fieldset>
            <p class="cart_navigation">
                <a href="{$base_dir_ssl}order?multi-shipping=" class="button">&laquo;{l s='Previous' mod='egrpayflowpro'}</a>
                <input type="submit" name="nextPayment" value="{l s='Next' mod='egrpayflowpro'}&raquo;" class="exclusive" />
            </p>
        </form>
    {else}
        <fieldset class="account_creation">
            <p style="color:red; font-size:14px; font-weight:bold" align="center">{l s='Your currency is not supported by Paypal' mod='egrpayflowpro'}</p>
        </fieldset>
    {/if}    
{else}
    <fieldset class="account_creation">
        <p style="color:red; font-size:14px; font-weight:bold" align="center">{l s='PayPal API Requires HTTPS ' mod='egrpayflowpro'}</p>
    </fieldset>
{/if}
