<?php
/**
* Module Prestashop CategoriesTopMenu
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*/

class CategoriesTopMenu extends Module
{
	public function __construct()
	{
		$this->name = 'categoriestopmenu';
		$this->tab = 'front_office_features';
		$this->version = '3.6.1';
		$this->author = 'PRESTACREA';

		$this->bootstrap = true;
		$this->need_instance = 0;
		parent::__construct();

		$this->displayName = ('PRESTACREA - Categories Top Menu');
		$this->description = $this->l('Adds a horizontal categories menu');
		$this->confirmUninstall = $this->l('Uninstalling the module will delete all its data. Do you want to continue uninstalling the module ?');
        
        if (version_compare(_PS_VERSION_, '1.5.0.0', '<'))
            require(_PS_MODULE_DIR_.$this->name.'/backward_compatibility/backward.php');
	}

	public function install()
	{
		if (file_exists(dirname(__FILE__).'/install/categoriestopmenu-install.php'))
			require_once(dirname(__FILE__).'/install/categoriestopmenu-install.php');

		if (file_exists(dirname(__FILE__).'/views/css/front/less/default.less.cache'))
			unlink(dirname(__FILE__).'/views/css/front/less/default.less.cache');
		if (file_exists(dirname(__FILE__).'/views/css/front/less/responsive.less.cache'))
			unlink(dirname(__FILE__).'/views/css/front/less/responsive.less.cache');

		if (file_exists(dirname(__FILE__).'/install/categoriestopmenu-update.php') && $this->version >= '3.3')
			unlink(dirname(__FILE__).'/install/categoriestopmenu-update.php');

		if (!parent::install() || !$this->registerHook('header') || !$this->registerHook('top'))
			return false;
		return true;
	}

	public function uninstall()
	{
		if (file_exists(dirname(__FILE__).'/install/categoriestopmenu-uninstall.php'))
			require_once(dirname(__FILE__).'/install/categoriestopmenu-uninstall.php');

		if (file_exists(dirname(__FILE__).'/views/css/front/less/default.less.cache'))
			unlink(dirname(__FILE__).'/views/css/front/less/default.less.cache');
		if (file_exists(dirname(__FILE__).'/views/css/front/less/responsive.less.cache'))
			unlink(dirname(__FILE__).'/views/css/front/less/responsive.less.cache');

		if (!parent::uninstall())
			return false;
		return true;
	}

	public function addLink()
	{
		$languages = Language::getLanguages();
		$default_language = (int)Configuration::get('PS_LANG_DEFAULT');
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			$id_shop = $this->context->shop->id;
			if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'categoriestopmenu VALUES ()') || !$last_id = Db::getInstance()->Insert_ID())
				return false;
			foreach ($languages as $language)
			{
				$title = Tools::getValue('title_'.$language['id_lang']) ? Tools::getValue('title_'.$language['id_lang']) : Tools::getValue('title_'.$default_language);
				$url = Tools::getValue('url_'.$language['id_lang']) ? Tools::getValue('url_'.$language['id_lang']) : Tools::getValue('url_'.$default_language);
				$position = Tools::getValue('position_'.$default_language);
				if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'categoriestopmenu_lang VALUES ('.$last_id.', \''.(int)$id_shop.'\', '.$language['id_lang'].', \''.addslashes($title).'\' , \''.addslashes($url).'\', \''.addslashes($position).'\')'))
					return false;
			}
			return true;
		}
		else
		{
			if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'categoriestopmenu VALUES ()') || !$last_id = mysql_insert_id())
				return false;
			foreach ($languages as $language)
			{
				$title = Tools::getValue('title_'.$language['id_lang']) ? Tools::getValue('title_'.$language['id_lang']) : Tools::getValue('title_'.$default_language);
				$url = Tools::getValue('url_'.$language['id_lang']) ? Tools::getValue('url_'.$language['id_lang']) : Tools::getValue('url_'.$default_language);
				$position = Tools::getValue('position_'.$default_language);
				if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'categoriestopmenu_lang VALUES ('.$last_id.', "1", '.$language['id_lang'].', \''.addslashes($title).'\' , \''.addslashes($url).'\', \''.addslashes($position).'\')'))
					return false;
			}
			return true;
		}
	}

	public function editLink()
	{
		$languages = Language::getLanguages();
		$default_language = (int)Configuration::get('PS_LANG_DEFAULT');
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			$id_shop = $this->context->shop->id;
			foreach ($languages as $language)
			{
				$title = Tools::getValue('title_'.$language['id_lang']) ? Tools::getValue('title_'.$language['id_lang']) : Tools::getValue('title_'.$default_language);
				$url = Tools::getValue('url_'.$language['id_lang']) ? Tools::getValue('url_'.$language['id_lang']) : Tools::getValue('url_'.$default_language);
				$position = Tools::getValue('position_'.$default_language);
				$id_link = (int)Tools::getValue('id');
				if (!Db::getInstance()->Execute('REPLACE '._DB_PREFIX_.'categoriestopmenu_lang VALUES (\''.($id_link).'\', \''.(int)$id_shop.'\', \''.$language['id_lang'].'\', \''.addslashes($title).'\', \''.addslashes($url).'\', \''.addslashes($position).'\')'))
					return false;
			}
			return true;
		}
		else
		{
			foreach ($languages as $language)
			{
				$title = Tools::getValue('title_'.$language['id_lang']) ? Tools::getValue('title_'.$language['id_lang']) : Tools::getValue('title_'.$default_language);
				$url = Tools::getValue('url_'.$language['id_lang']) ? Tools::getValue('url_'.$language['id_lang']) : Tools::getValue('url_'.$default_language);
				$position = Tools::getValue('position_'.$default_language);
				$id_link = (int)Tools::getValue('id');
				if (!Db::getInstance()->Execute('REPLACE '._DB_PREFIX_.'categoriestopmenu_lang VALUES (\''.($id_link).'\', "1", \''.$language['id_lang'].'\', \''.addslashes($title).'\', \''.addslashes($url).'\', \''.addslashes($position).'\')'))
					return false;
			}
			return true;
		}
	}

	public function deleteLink()
	{
		$id_link = (int)Tools::getValue('id');
		if (Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.'categoriestopmenu WHERE `id_link`='.$id_link))
			return Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.'categoriestopmenu_lang WHERE `id_link`='.$id_link);
		return false;
	}

	public function getCategories($id_lang)
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			return Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('SELECT c.`id_category`, cl.`name`
			FROM `'._DB_PREFIX_.'category` c
			LEFT JOIN `'._DB_PREFIX_.'category_lang` cl ON c.`id_category` = cl.`id_category`
			LEFT JOIN `'._DB_PREFIX_.'category_shop` cs ON (cs.`id_category` = c.`id_category`)
			WHERE cl.`id_lang` = '.(int)$id_lang.'
			AND `id_parent` > 0
			AND c.`id_category` != 1
			AND cs.`id_shop` = '.$this->context->shop->id.'
			GROUP BY id_category
			ORDER BY c.`id_category`');
		}
		else
		{
			return Db::getInstance()->ExecuteS('SELECT c.`id_category`, cl.`name`
			FROM `'._DB_PREFIX_.'category` c
			LEFT JOIN `'._DB_PREFIX_.'category_lang` cl ON c.`id_category` = cl.`id_category`
			'.(Tools::getValue('id_category') ? 'LEFT JOIN `'._DB_PREFIX_.'category_product` cp ON p.`id_product` = cp.`id_product`' : '').'
			WHERE cl.`id_lang` = '.(int)$id_lang.'
			AND `id_parent` > 0
			AND c.`id_category` != 1
			'.(Tools::getValue('id_category') ? 'AND cp.id_category = '.(int)Tools::getValue('id_category') : '').'
			ORDER BY c.`id_category`');
		}
	}

	public function getContent()
	{
		$this->_html = '<h2>'.$this->displayName.' - v.'.$this->version.'</h2>
		<div id="lnkDocContainer">
			<a class="lnk" target="_blank" href="'.$this->_path.'doc/'.$this->name.'.pdf">'.$this->l('PDF documentation').'</a>
		</div>
		<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">
			<input style="margin:0 0 20px;" type="submit" name="submitCache" value="'.$this->l('Clear module cache').'" class="button" />';
			if (file_exists(dirname(__FILE__).'/install/categoriestopmenu-update.php') && $this->version >= '3.3' && !Tools::isSubmit('submitUpdate'))
				$this->_html .= '<input style="margin:0 0 20px 10px;" type="submit" name="submitUpdate" value="'.$this->l('Update module').'" class="button" />';
		$this->_html .= '</form>';
		$default_language = (int)Configuration::get('PS_LANG_DEFAULT');
		$position = Tools::getValue('position_'.$default_language);
		if (Tools::isSubmit('submitGeneral'))
		{
			if (Tools::getValue('ctm_maxdepth') && Validate::isInt(Tools::getValue('ctm_maxdepth')))
				Configuration::updateValue('CTM_MAXDEPTH', pSQL(Tools::getValue('ctm_maxdepth')));
			else
				$this->_html .= $this->displayError($this->l('Invalid number of levels'));
			Configuration::updateValue('CTM_TABS', pSQL(Tools::getValue('ctm_tabs')));
			Configuration::updateValue('CTM_RESPONSIVE', pSQL(Tools::getValue('ctm_responsive')));
			Configuration::updateValue('CTM_HOME', pSQL(Tools::getValue('ctm_home')));
			Configuration::updateValue('CTM_SPECIALS', pSQL(Tools::getValue('ctm_specials')));
			Configuration::updateValue('CTM_NEWS', pSQL(Tools::getValue('ctm_news')));
			$this->_html .= $this->displayConfirmation($this->l('Configuration updated'));
		}
		elseif (Tools::isSubmit('submitAddLink'))
		{
			if (!$position || $position <= 0 || !Validate::isInt($position))
				$this->_html .= $this->displayError($this->l('Invalid position number'));
			else
			{
				if ($this->addLink())
					$this->_html .= $this->displayConfirmation($this->l('The link has been added successfully'));
				else
					$this->_html .= $this->displayError($this->l('An error occured during link adding'));
			}
		}
		elseif (Tools::isSubmit('submitEditLink'))
		{
			if (!$position || $position <= 0 || !Validate::isInt($position))
				$this->_html .= $this->displayError($this->l('Invalid position number'));
			else
			{
				if (!Tools::getValue('id') || !is_numeric(Tools::getValue('id')) || !$this->editLink())
					$this->_html .= $this->displayError($this->l('An error occured during link editing'));
				else
					$this->_html .= $this->displayConfirmation($this->l('The link has been edited successfully'));
			}
		}
		elseif (Tools::getValue('id'))
		{
			if (!is_numeric(Tools::getValue('id')) || !$this->deleteLink())
				$this->_html .= $this->displayError($this->l('An error occurred during link deletion'));
			else
				$this->_html .= $this->displayConfirmation($this->l('The link has been deleted successfully'));
		}
		if (Tools::isSubmit('submitStyle'))
		{
			if (Validate::isInt(Tools::getValue('ctm_width')))
				Configuration::updateValue('CTM_WIDTH', pSQL(Tools::getValue('ctm_width')));
			else
				$this->_html .= $this->displayError($this->l('Invalid menu maximum width'));
			if (Tools::getValue('ctm_fontfamily') && Validate::isName(Tools::getValue('ctm_fontfamily')))
				Configuration::updateValue('CTM_FONTFAMILY', pSQL(Tools::getValue('ctm_fontfamily')));
			else
				$this->_html .= $this->displayError($this->l('Invalid font family'));
			if (Tools::getValue('ctm_fontsize') && Validate::isInt(Tools::getValue('ctm_fontsize')))
				Configuration::updateValue('CTM_FONTSIZE', pSQL(Tools::getValue('ctm_fontsize')));
			else
				$this->_html .= $this->displayError($this->l('Invalid font size'));
			if (Tools::getValue('ctm_menutopcolor'))
				Configuration::updateValue('CTM_MENUTOPCOLOR', pSQL(Tools::getValue('ctm_menutopcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid menu top color'));
			if (Tools::getValue('ctm_menubottomcolor'))
				Configuration::updateValue('CTM_MENUBOTTOMCOLOR', pSQL(Tools::getValue('ctm_menubottomcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid menu bottom color'));
			if (Tools::getValue('ctm_firstfontcolor'))
				Configuration::updateValue('CTM_FIRSTFONTCOLOR', pSQL(Tools::getValue('ctm_firstfontcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid first level font color'));
			if (Tools::getValue('ctm_nextfontcolor'))
				Configuration::updateValue('CTM_NEXTFONTCOLOR', pSQL(Tools::getValue('ctm_nextfontcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid next levels font color'));
			if (Tools::getValue('ctm_linkstopcolor'))
				Configuration::updateValue('CTM_LINKSTOPCOLOR', pSQL(Tools::getValue('ctm_linkstopcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid links top color'));
			if (Tools::getValue('ctm_linksbottomcolor'))
				Configuration::updateValue('CTM_LINKSBOTTOMCOLOR', pSQL(Tools::getValue('ctm_linksbottomcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid links bottom color'));
			if (Tools::getValue('ctm_linksfontcolor'))
				Configuration::updateValue('CTM_LINKSFONTCOLOR', pSQL(Tools::getValue('ctm_linksfontcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid links font color'));
			if (file_exists(dirname(__FILE__).'/views/css/front/less/default.less.cache'))
				unlink(dirname(__FILE__).'/views/css/front/less/default.less.cache');
			if (file_exists(dirname(__FILE__).'/views/css/front/less/responsive.less.cache'))
				unlink(dirname(__FILE__).'/views/css/front/less/responsive.less.cache');
			$this->_html .= $this->displayConfirmation($this->l('Configuration updated'));
		}
		if (Tools::isSubmit('submitCSS'))
		{
			if ($this->putFileContents())
				$this->_html .= $this->displayConfirmation($this->l('CSS file updated'));
			else
				$this->_html .= $this->displayError($this->l('No CSS file selected'));
		}
		if (Tools::isSubmit('submitCache'))
		{
			if (file_exists(dirname(__FILE__).'/views/css/front/less/default.less.cache'))
				unlink(dirname(__FILE__).'/views/css/front/less/default.less.cache');
			if (file_exists(dirname(__FILE__).'/views/css/front/less/responsive.less.cache'))
				unlink(dirname(__FILE__).'/views/css/front/less/responsive.less.cache');
			$this->_html .= $this->displayConfirmation($this->l('Module cache cleared'));
		}
		if (Tools::isSubmit('submitUpdate'))
		{
			if (file_exists(dirname(__FILE__).'/install/categoriestopmenu-update.php'))
				require_once(dirname(__FILE__).'/install/categoriestopmenu-update.php');
			unlink(dirname(__FILE__).'/install/categoriestopmenu-update.php');
			$this->_html .= $this->displayConfirmation($this->l('Module updated'));
		}
		$this->displayForm();
		return $this->_html;
	}

	public function displayForm()
	{
		$this->_html .= '<link rel="stylesheet" type="text/css" href="'.$this->_path.'views/css/admin/admin.css" />
		<link rel="stylesheet" type="text/css" href="'.$this->_path.'views/css/admin/colorpicker.css" />
		<script type="text/javascript" src="'.$this->_path.'views/js/admin/admin.js"></script>
		<script type="text/javascript" src="'.$this->_path.'views/js/admin/colorpicker.js"></script>
		<script language="javascript" type="text/javascript" src="'.$this->_path.'views/js/admin/edit_area_full.js"></script>
		<div id="tab_container">
			<script type="text/javascript">var id_tab = 1;changeTab(id_tab);</script>
			<ul class="tabs">
				<li id="tab_1" class="tab active" onclick="changeTab(1);">'.$this->l('General configuration').'</li>
				<li id="tab_2" class="tab" onclick="changeTab(2);">'.$this->l('Graphical configuration').'</li>
				<li id="tab_3" class="tab" onclick="changeTab(3);">'.$this->l('CSS Editor').'</li>
			</ul>
			<div id="content_1" class="content" style="display:block">';
				$this->configGeneral();
			$this->_html .= '</div>
			<div id="content_2" class="content" style="display:none">';
				$this->configStyle();
			$this->_html .= '</div>
			<div id="content_3" class="content" style="display:none">';
				$this->configCSS();
			$this->_html .= '</div>
		</div>';
	}

	public function configGeneral()
	{
		$languages = Language::getLanguages();
		$default_language = (int)Configuration::get('PS_LANG_DEFAULT');
		$div_lang_name = 'title¤url';
		$this->_html .= '<script type="text/javascript">id_language = Number('.$default_language.');</script>
		<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">
			<fieldset>
				<h3>'.$this->l('General configuration options').'</h3>
				<div class="block mini high">
					<label>'.$this->l('Categories levels').'</label>
					<input type="text" size="4" maxlength="2" name="ctm_maxdepth" value="'.Configuration::get('CTM_MAXDEPTH').'" />
					<p>'.$this->l('Set the number of categories levels displayed in the menu').'</p>
				</div>
				<div class="block mini high">
					<label>'.$this->l('Menu display').'</label>
					<div class="inputContainer">
						<input type="radio" name="ctm_tabs" value="1" '.(Configuration::get('CTM_TABS') ? 'checked="checked"' : '').' />'.$this->l('Tabs').'
						<input type="radio" name="ctm_tabs" value="0" '.(!Configuration::get('CTM_TABS') ? 'checked="checked"' : '').' />'.$this->l('Bar').'
					</div>
					<p>'.$this->l('Set the menu display type (tabs only on wide screens with responsive mode)').'</p>
				</div>
				<div class="block mini high">
					<label>'.$this->l('Activate responsive mode').'</label>
					<div class="inputContainer">
						<input type="radio" name="ctm_responsive" value="1" '.(Configuration::get('CTM_RESPONSIVE') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="ctm_responsive" value="0" '.(!Configuration::get('CTM_RESPONSIVE') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set whether the responsive mode is activated or not (the template used must be compatible, disable this option if the template is not responsive)').'</p>
				</div>
				<div class="block mini">
					<label>'.$this->l('Display Home link').'</label>
					<div class="inputContainer">
						<input type="radio" name="ctm_home" value="1" '.(Configuration::get('CTM_HOME') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="ctm_home" value="0" '.(!Configuration::get('CTM_HOME') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set whether the home link is displayed or not').'</p>
				</div>
				<div class="block mini">
					<label>'.$this->l('Display Promotions link').'</label>
					<div class="inputContainer">
						<input type="radio" name="ctm_specials" value="1" '.(Configuration::get('CTM_SPECIALS') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="ctm_specials" value="0" '.(!Configuration::get('CTM_SPECIALS') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set whether the promotions link is displayed or not').'</p>
				</div>
				<div class="block mini">
					<label>'.$this->l('Display New products link').'</label>
					<div class="inputContainer">
						<input type="radio" name="ctm_news" value="1" '.(Configuration::get('CTM_NEWS') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="ctm_news" value="0" '.(!Configuration::get('CTM_NEWS') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set whether the new products link is displayed or not').'</p>
				</div>
				<div class="clear"></div>
				<div class="space"></div>
				<h3 id="linkedit_h3">'.$this->l('Additional links configuration').'</h3>
				<div id="linkedit" class="block small auto">
					<label>'.$this->l('Add or edit a link').'</label>
					<span class="label" style="float:left;width:70px;margin-top:5px">'.$this->l('Title').' :</span>
					<div style="overflow:hidden">';
						foreach ($languages as $language)
						$this->_html .= '<div id="title_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $default_language ? 'block' : 'none').'">
							<input type="text" size="20" name="title_'.$language['id_lang'].'" id="titleInput_'.$language['id_lang'].'" class="inputText float" value="" />
						</div>';
						$this->_html .= $this->displayFlags($languages, $default_language, $div_lang_name, 'title', true);
					$this->_html .= '</div>
					<span class="label" style="float:left;width:70px;margin-top:15px;clear:both">'.$this->l('URL').' :</span>
					<div style="margin:10px 0;overflow:hidden">';
						foreach ($languages as $language)
						$this->_html .= '<div id="url_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $default_language ? 'block' : 'none').'">
							<input type="text" size="20" name="url_'.$language['id_lang'].'" id="urlInput_'.$language['id_lang'].'" class="inputText float" value="" />
						</div>';
						$this->_html .= $this->displayFlags($languages, $default_language, $div_lang_name, 'url', true);
					$this->_html .= '</div>
					<div style="float:left;width:100%;margin:0 0 10px">';
						foreach ($languages as $language)
						$this->_html .= '<div style="display:'.($language['id_lang'] == $default_language ? 'block' : 'none').';float:left">
							<span class="label" style="float:left;width:70px;margin-top:5px">'.$this->l('Position N&ordm;').' :</span>
							<input type="text" size="2" maxlength="2" name="position_'.$language['id_lang'].'" id="positionInput_'.$language['id_lang'].'" value="" />
						</div>';
					$this->_html .= '</div>
					<div style="float:left">
						<input type="hidden" name="id" id="id" value="'.(Tools::getValue('id') ? Tools::getValue('id') : '').'" />
						<input type="submit" id="submitAddLink" name="submitAddLink" value="'.$this->l('Add this link').'" class="button" style="display:block" />
						<input type="submit" id="submitEditLink" name="submitEditLink" value="'.$this->l('Edit this link').'" class="button" style="display:none" />
					</div>
					<div class="clear"></div>
					<p>'.$this->l('Set the title, the url and the location of the link').'</p>
				</div>';
				$this->listLinks();
				$this->_html .= '<div class="block small auto">
					<label>'.$this->l('Additional links list').'</label>
					<div class="clear"></div>';
					$this->displayLinksList();
				$this->_html .= '</div>
				<div class="clear"></div>
				<div class="space"></div>
				<h3>'.$this->l('Categories display configuration').'</h3>
				<div class="block auto" style="clear:both">
					<label>'.$this->l('Categories to display').'</label>
					<table class="table" style="width:400px;font-weight:normal">
						<tr>
							<th class="center" style="width:15px"><input type="checkbox" name="checkme"/></th>
							<th class="center" style="width:50px">'.$this->l('ID').'</th>
							<th>'.$this->l('Name').'</th>
						</tr>';
						$i = 0;
						foreach ($this->getCategories($this->context->cookie->id_lang) as $category)
						{
							if (Tools::isSubmit('submitGeneral'))
							{
								if (Tools::getValue($category['id_category']))
									$this->updateCtm((int)$category['id_category'], 1);
								else
									$this->updateCtm((int)$category['id_category'], 0);
							}
							$this->_html .= '<tr'.($i % 2 ? ' class="alternate"' : '').'>
								<td class="center"><input type="checkbox" class="checkall" name="'.$category['id_category'].'" '.($this->testCtm((int)$category['id_category']) == 1 ? 'checked="checked"' : '').'></td>
								<td class="center">'.$category['id_category'].'</td>
								<td>'.$category['name'].'</td>
							</tr>';
							$i++;
						}
					$this->_html .= '</table>
					<p>'.$this->l('Set the categories to display').'</p>
				</div>
				<script type="text/javascript">
					$(document).ready(function() {
						$("input[name=checkme]").click(function() {
							var checked_status = this.checked;
							$(".checkall").each(function() {
								this.checked = checked_status;
							});
						});
					});
				</script>';
				$this->_html .= '<div class="clear"></div>
				<div class="update"><input type="submit" name="submitGeneral" value="'.$this->l('Update configuration').'" class="button" /></div>
			</fieldset>
		</form>';
	}

	public function configStyle()
	{
		$this->_html .= '<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">
			<fieldset>
				<h3>'.$this->l('Graphical configuration options').'</h3>
				<div class="block small high">
					<label>'.$this->l('Maximum width of the menu').'</label>
					<span class="label">'.$this->l('Maximum width').' :</span>
					<input type="text" size="4" maxlength="4" name="ctm_width" value="'.Configuration::get('CTM_WIDTH').'" /><span class="unity">px</span>
					<p>'.$this->l('Set the maximum width of the menu (set to 0 for 100% width)').'</p>
				</div>
				<div class="block small high">
					<label>'.$this->l('Global font style').'</label>
					<span class="label">'.$this->l('Font family').' :</span>
					<input type="text" size="16" name="ctm_fontfamily" value="'.Configuration::get('CTM_FONTFAMILY').'" />
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Font size').' :</span>
					<input type="text" size="4" maxlength="2" name="ctm_fontsize" value="'.Configuration::get('CTM_FONTSIZE').'" /><span class="unity">px</span>
					<p>'.$this->l('Set the font family and the font size of the menu').'</p>
				</div>
				<div class="block small high">
					<label>'.$this->l('Menu background color').'</label>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Color top').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ctm_menutopcolor" value="'.Configuration::get('CTM_MENUTOPCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('CTM_MENUTOPCOLOR').'"></span>
					</div>
					<div class="spaceSmall"></div>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Color bottom').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ctm_menubottomcolor" value="'.Configuration::get('CTM_MENUBOTTOMCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('CTM_MENUBOTTOMCOLOR').'"></span>
					</div>
					<p>'.$this->l('Set the color of the menu background (gradient)').'</p>
				</div>
				<div class="block small high">
					<label>'.$this->l('Menu font color').'</label>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('First level').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ctm_firstfontcolor" value="'.Configuration::get('CTM_FIRSTFONTCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('CTM_FIRSTFONTCOLOR').'"></span>
					</div>
					<div class="spaceSmall"></div>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Next levels').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ctm_nextfontcolor" value="'.Configuration::get('CTM_NEXTFONTCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('CTM_NEXTFONTCOLOR').'"></span>
					</div>
					<p>'.$this->l('Set the color of the different categories levels font').'</p>
				</div>
				<div class="block small high">
					<label>'.$this->l('Links background color').'</label>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Color top').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ctm_linkstopcolor" value="'.Configuration::get('CTM_LINKSTOPCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('CTM_LINKSTOPCOLOR').'"></span>
					</div>
					<div class="spaceSmall"></div>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Color bottom').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ctm_linksbottomcolor" value="'.Configuration::get('CTM_LINKSBOTTOMCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('CTM_LINKSBOTTOMCOLOR').'"></span>
					</div>
					<p>'.$this->l('Set the color of the links background (gradient)').'</p>
				</div>
				<div class="block small high">
					<label>'.$this->l('Links font color').'</label>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Color').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ctm_linksfontcolor" value="'.Configuration::get('CTM_LINKSFONTCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('CTM_LINKSFONTCOLOR').'"></span>
					</div>
					<p>'.$this->l('Set the color of the links font').'</p>
				</div>
				<div class="clear"></div>
				<div class="update"><input type="submit" name="submitStyle" value="'.$this->l('Update configuration').'" class="button" /></div>
			</fieldset>
		</form>';
	}

	public function configCSS()
	{
		$dir = dirname(__FILE__).'/views/css/front/less/';
		$files = scandir($dir);
		$cnt = count($files);
		$this->_html .= '<script type="text/javascript">var baseDir = "'.$this->_path.'views/css/front/less/";</script>
		<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">
			<fieldset>
				<h3>'.$this->l('Warning').'</h3>
				<div class="warning">'.$this->l('Editing CSS file is only for experienced users. Edit these files only if you know what you are doing.').'</div>
				<div class="clear"></div>
				<div class="space"></div>
				<h3>'.$this->l('List of CSS files (LESS files)').'</h3>
				<table class="table">
					<th>'.$this->l('Filename').'</th>
					<th class="center">'.$this->l('Edit').'</th>';
					for ($i = 0; $i < $cnt; $i++)
						if (preg_match('/.less$/', $files[$i]))
						{
							$link = '<a href="#editor_container" onclick="loadFile('.$i.');">';
							$link .= '<img src="'._PS_ADMIN_IMG_.'edit.gif" /></a>
							<input type="hidden" name="fileId" id="fileId" value="'.$i.'"/>
							<input type="hidden" name="fileName_'.$i.'" id="fileName_'.$i.'" value="'.$files[$i].'"/>';
							$this->_html .= '<tr>
								<td>'.$files[$i].'</td>
								<td class="center">'.$link.'</td>
							</tr>';
						}
				$this->_html .= '</table>
				<div>';
					$this->_html .= '<div id="editor_container">
						<textarea cols="80" rows="30" id="contentCSS" name="contentCSS"></textarea>
						<input type="hidden" name="fileName" id="fileName" value=""/>
					</div>
				</div>
				<div class="clear"></div>
				<div class="update"><input type="submit" name="submitCSS" value="'.$this->l('Update the CSS file').'" class="button" /></div>
			</fieldset>
		</form>';
	}

	public function putFileContents()
	{
		$filename = Tools::getValue('fileName');
		$file = dirname(__FILE__).'/views/css/front/less/'.$filename;
		$balises = array('content:"e', 'content:"f');
		$replace = array('content:"\\e', 'content:"\\f');
		$data = str_replace($balises, $replace, Tools::getValue('contentCSS'));
		$contents = $data;
		if ($filename)
		{
			file_put_contents($file, $contents);
			return true;
		}
		else
			return false;
	}

	public function getLinks($id_lang = null)
	{
		$result = array();
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			$id_shop = $this->context->shop->id;
			if (!$links = Db::getInstance()->ExecuteS('SELECT c.`id_link`, cl.`position` FROM `'._DB_PREFIX_.'categoriestopmenu` c JOIN `'._DB_PREFIX_.'categoriestopmenu_lang` cl ON (c.`id_link` = cl.`id_link` AND `id_shop`='.(int)$id_shop.' AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.') ORDER BY `position`'))
				return false;
		}
		else
		{
			if (!$links = Db::getInstance()->ExecuteS('SELECT c.`id_link`, cl.`position` FROM `'._DB_PREFIX_.'categoriestopmenu` c JOIN `'._DB_PREFIX_.'categoriestopmenu_lang` cl ON (c.`id_link` = cl.`id_link` AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.') ORDER BY `position`'))
				return false;
		}
		$i = 0;
		foreach ($links as $link)
		{
			$result[$i]['id'] = $link['id_link'];
			if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
				$sql = 'SELECT `id_lang`, `title`, `url`, `position` FROM '._DB_PREFIX_.'categoriestopmenu_lang WHERE `id_link`='.(int)$link['id_link'].' AND `id_shop`='.(int)$id_shop;
			else
				$sql = 'SELECT `id_lang`, `title`, `url`, `position` FROM '._DB_PREFIX_.'categoriestopmenu_lang WHERE `id_link`='.(int)$link['id_link'];
			if (isset($id_lang) && is_numeric($id_lang) && (int)$id_lang > 0)
				$sql .= ' AND `id_lang` = '.(int)$id_lang;
			if (!$texts = Db::getInstance()->ExecuteS($sql))
				return false;
			foreach ($texts as $text)
			{
				$result[$i]['title_'.$text['id_lang']] = $text['title'];
				$result[$i]['url_'.$text['id_lang']] = $text['url'];
				$result[$i]['position_'.$text['id_lang']] = $text['position'];
			}
			$i++;
		}
		return $result;
	}

	public function listLinks()
	{
		$links = $this->getLinks();
		$languages = Language::getLanguages();
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			$token = Tools::safeOutput(Tools::getValue('token'));
		if ($links)
		{
			$this->_html .= '<script type="text/javascript">
				var currentUrl = \''.Tools::safeOutput($_SERVER['REQUEST_URI']).'&configure='.$this->name.'\';';
				if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
					$this->_html .= 'var token=\''.$token.'\';';
				else
					$this->_html .= 'var token=\''.$this->context->admin_obj->token.'\';';
				$this->_html .= 'var links = new Array();';
				$var = '';
				foreach ($links as $link)
				{
					$var .= 'links['.$link['id'].'] = new Array(';
					$i = 0;
					foreach ($languages as $language)
					{
						if ($i > 0)
						$var .= ',';
						$var .= $language['id_lang'];
						$title = isset($link['title_'.$language['id_lang']]) ? $link['title_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes(html_entity_decode($title, ENT_QUOTES, 'UTF-8')).'\'';
						$url = isset($link['url_'.$language['id_lang']]) ? $link['url_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes($url).'\'';
						$position = isset($link['position_'.$language['id_lang']]) ? $link['position_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes($position).'\'';
						$i++;
					}
					$var .= ');';
				}
			$var .= '</script>';
			$this->_html .= $var;
		}
	}

	public function displayLinksList()
	{
		$links = $this->getLinks();
		$default_language = (int)Configuration::get('PS_LANG_DEFAULT');
		$languages = Language::getLanguages();
		if (!$links)
			$this->_html .= '<p>'.$this->l('No links').'</p>';
		else
		{
			$this->_html .= '<table class="table" style="width:97%;max-width:100%;font-weight:normal">
				<tr>
					<th class="center" style="width:15px"></th>
					<th>'.$this->l('Title').'</th>
					<th class="center" style="width:60px">'.$this->l('Actions').'</th>
				</tr>';
				foreach ($links as $link)
				{
					$position = isset($link['position_'.$this->context->cookie->id_lang]) ? $link['position_'.$this->context->cookie->id_lang] : $link['position_'.$default_language];
					$title = isset($link['title_'.$this->context->cookie->id_lang]) ? $link['title_'.$this->context->cookie->id_lang] : $link['title_'.$default_language];
					$this->_html .= '<tr>
						<td class="center">'.(int)$position.'</td>
						<td>'.Tools::safeOutput($title).'</td>
						<td class="center">
							<a href="#linkedit_h3"><img src="'._PS_ADMIN_IMG_.'edit.gif" onclick="linkEdit('.$link['id'].')" style="padding:0" title="'.$this->l('Edit').'" /></a>
							<a href="#"><img src="'._PS_ADMIN_IMG_.'delete.gif" onclick="linkDelete('.$link['id'].');return false;" style="padding:0" title="'.$this->l('Delete').'" /></a>
						</td>
					</tr>';
				}
			$this->_html .= '</table>
			<input type="hidden" id="languageFirst" value="'.$languages[0]['id_lang'].'" />
			<input type="hidden" id="languageNb" value="'.count($languages).'" />';
		}
	}

	public function updateCtm($id_category, $status)
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			return Db::getInstance()->Execute('UPDATE `'._DB_PREFIX_.'category_shop` SET `ctm`='.$status.' WHERE `id_category` = '.(int)$id_category.' AND `id_shop` = '.$this->context->shop->id);
		else
			return Db::getInstance()->Execute('UPDATE `'._DB_PREFIX_.'category` SET `ctm`='.$status.' WHERE `id_category` = '.(int)$id_category);
	}

	public function testCtm($id_category)
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			$value = Db::getInstance()->GetRow('SELECT `ctm` FROM `'._DB_PREFIX_.'category_shop` WHERE `id_category` = '.(int)$id_category.' AND `id_shop` = '.$this->context->shop->id);
			return $value['ctm'];
		}
		else
		{
			$value = Db::getInstance()->GetRow('SELECT `ctm` FROM `'._DB_PREFIX_.'category` WHERE `id_category` = '.(int)$id_category);
			return $value['ctm'];
		}
	}

	public function getTree($result_parents, $result_ids, $ctm_maxdepth, $id_category = 1, $current_depth = 0)
	{
		$children = array();
		if (isset($result_parents[$id_category]) && count($result_parents[$id_category]) && ($ctm_maxdepth == 0 || $current_depth < $ctm_maxdepth))
			foreach ($result_parents[$id_category] as $subcat)
				$children[] = $this->getTree($result_parents, $result_ids, $ctm_maxdepth, $subcat['id_category'], $current_depth + 1);
		if (!isset($result_ids[$id_category]))
			return false;
		return array('id' => $id_category, 'link' => $this->context->link->getCategoryLink($id_category, $result_ids[$id_category]['link_rewrite']),
		'name' => $result_ids[$id_category]['name'], 'desc'=> $result_ids[$id_category]['description'],
		'children' => $children);
	}

	public function getTree15($result_parents, $result_ids, $ctm_maxdepth, $id_category = null, $current_depth = 0)
	{
		if (is_null($id_category))
			$id_category = $this->context->shop->getCategory();
		$children = array();
		if (isset($result_parents[$id_category]) && count($result_parents[$id_category]) && ($ctm_maxdepth == 0 || $current_depth < $ctm_maxdepth))
			foreach ($result_parents[$id_category] as $subcat)
				$children[] = $this->getTree15($result_parents, $result_ids, $ctm_maxdepth, $subcat['id_category'], $current_depth + 1);
		if (!isset($result_ids[$id_category]))
			return false;
		$return = array('id' => $id_category, 'link' => $this->context->link->getCategoryLink($id_category, $result_ids[$id_category]['link_rewrite']),
		'name' => $result_ids[$id_category]['name'], 'desc'=> $result_ids[$id_category]['description'],
		'children' => $children);
		return $return;
	}

	public function cacheCompileLess($input_file, $output_file)
	{
		if (!class_exists('lessc'))
			require_once dirname(__FILE__).'/lessc.inc.php';

		$cache_file = $input_file.'.cache';
		if (file_exists($cache_file))
			$cache = unserialize(Tools::file_get_contents($cache_file));
		else
			$cache = $input_file;

		$less = new lessc;
		$less->setVariables(array(
			'ctm_width' => Configuration::get('CTM_WIDTH') > 0 ? Configuration::get('CTM_WIDTH').'px' : '100%',
			'ctm_fontfamily' => Configuration::get('CTM_FONTFAMILY'),
			'ctm_fontsize' => Configuration::get('CTM_FONTSIZE').'px',
			'ctm_menutopcolor' => '#'.Configuration::get('CTM_MENUTOPCOLOR'),
			'ctm_menubottomcolor' => '#'.Configuration::get('CTM_MENUBOTTOMCOLOR'),
			'ctm_firstfontcolor' => '#'.Configuration::get('CTM_FIRSTFONTCOLOR'),
			'ctm_nextfontcolor' => '#'.Configuration::get('CTM_NEXTFONTCOLOR'),
			'ctm_linkstopcolor' => '#'.Configuration::get('CTM_LINKSTOPCOLOR'),
			'ctm_linksbottomcolor' => '#'.Configuration::get('CTM_LINKSBOTTOMCOLOR'),
			'ctm_linksfontcolor' => '#'.Configuration::get('CTM_LINKSFONTCOLOR')
		));

		$less->setFormatter('classic');
		$new_cache = $less->cachedCompile($cache);

		if (!is_array($cache) || $new_cache['updated'] > $cache['updated'])
		{
			file_put_contents($cache_file, serialize($new_cache));
			file_put_contents($output_file, $new_cache['compiled']);
		}
	}

	public function hookHeader()
	{
		$this->context->smarty->assign(array(
			'ctm_tabs' => Configuration::get('CTM_TABS'),
			'ctm_responsive' => Configuration::get('CTM_RESPONSIVE')
		));

		$this->cacheCompileLess(dirname(__FILE__).'/views/css/front/less/default.less', dirname(__FILE__).'/views/css/front/categoriestopmenu.css');
		$this->cacheCompileLess(dirname(__FILE__).'/views/css/front/less/responsive.less', dirname(__FILE__).'/views/css/front/categoriestopmenu-responsive.css');

		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			$this->context->controller->addCSS(($this->_path).'views/css/front/categoriestopmenu.css', 'all');
			if (Configuration::get('CTM_RESPONSIVE') == 1)
				$this->context->controller->addCSS(($this->_path).'views/css/front/categoriestopmenu-responsive.css', 'all');
		}
		else
		{
			Tools::addCSS($this->_path.'views/css/front/categoriestopmenu.css', 'all');
			if (Configuration::get('CTM_RESPONSIVE') == 1)
				Tools::addCSS($this->_path.'views/css/front/categoriestopmenu-responsive.css', 'all');
		}
	}

	public function hookTop($params)
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			$id_shop = $this->context->shop->id;
			$sql = 'SELECT c.`id_link` AS id, cl.`title` AS title, cl.`url` AS url
			FROM `'._DB_PREFIX_.'categoriestopmenu` c
			JOIN `'._DB_PREFIX_.'categoriestopmenu_lang` cl ON (c.`id_link` = cl.`id_link` AND `id_shop`='.(int)$id_shop.' AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			ORDER BY `position`';
			$links = Db::getInstance()->ExecuteS($sql);
			$this->context->smarty->assign('id_shop', $id_shop);
		}
		else
		{
			$sql = 'SELECT c.`id_link` AS id, cl.`title` AS title, cl.`url` AS url
			FROM `'._DB_PREFIX_.'categoriestopmenu` c
			JOIN `'._DB_PREFIX_.'categoriestopmenu_lang` cl ON (c.`id_link` = cl.`id_link` AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			ORDER BY `position`';
			$links = Db::getInstance()->ExecuteS($sql);
		}
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			$id_customer = (int)$params['cookie']->id_customer;
			$groups = $id_customer ? implode(', ', Customer::getGroupsStatic($id_customer)) : Configuration::get('PS_UNIDENTIFIED_GROUP');
			$id_lang = (int)$params['cookie']->id_lang;
			$ctm_maxdepth = Configuration::get('CTM_MAXDEPTH');
			if (!$result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('SELECT c.id_parent, c.id_category, cl.name, cl.description, cl.link_rewrite
			FROM `'._DB_PREFIX_.'category` c
			LEFT JOIN `'._DB_PREFIX_.'category_lang` cl ON (c.`id_category` = cl.`id_category` AND cl.`id_lang` = '.$id_lang.Shop::addSqlRestrictionOnLang('cl').')
			LEFT JOIN `'._DB_PREFIX_.'category_group` cg ON (cg.`id_category` = c.`id_category`)
			LEFT JOIN `'._DB_PREFIX_.'category_shop` cs ON (cs.`id_category` = c.`id_category`)
			WHERE (c.`active` = 1 OR c.`id_category` = '.(int)Configuration::get('PS_HOME_CATEGORY').')
			AND c.`id_category` != '.(int)Configuration::get('PS_ROOT_CATEGORY').'
			'.((int)$ctm_maxdepth != 0 ? ' AND `level_depth` <= '.(int)$ctm_maxdepth : '').'
			AND cg.`id_group` IN ('.pSQL($groups).')
			AND cs.`id_shop` = '.$this->context->shop->id.'
			AND cs.`ctm` = 1
			GROUP BY id_category
			ORDER BY `level_depth` ASC, cs.`position` ASC'))
				return;
		}
		else
		{
			$id_customer = (int)$params['cookie']->id_customer;
			$ctm_maxdepth = Configuration::get('CTM_MAXDEPTH');
			if (!$result = Db::getInstance()->ExecuteS('SELECT DISTINCT c.*, cl.*
			FROM `'._DB_PREFIX_.'category` c
			LEFT JOIN `'._DB_PREFIX_.'category_lang` cl ON (c.`id_category` = cl.`id_category` AND `id_lang` = '.(int)$params['cookie']->id_lang.')
			LEFT JOIN `'._DB_PREFIX_.'category_group` ctg ON (ctg.`id_category` = c.`id_category`)
			'.($id_customer ? 'INNER JOIN `'._DB_PREFIX_.'customer_group` cg ON (cg.`id_group` = ctg.`id_group` AND cg.`id_customer` = '.(int)$id_customer.')' : '' ).'
			WHERE 1'.((int)$ctm_maxdepth != 0 ? ' AND `level_depth` <= '.(int)$ctm_maxdepth : '').'
			AND (c.`active` = 1 OR c.`id_category` = 1)
			'.(!$id_customer ? 'AND ctg.`id_group` = 1' : '' ).'
			AND c.`ctm` = 1
			ORDER BY `level_depth` ASC, c.`position` ASC'))
				return;
		}
		$result_parents = array();
		$result_ids = array();
		foreach ($result as $row)
		{
			$row['name'] = $row['name'];
			$result_parents[$row['id_parent']][] = $row;
			$result_ids[$row['id_category']] = $row;
		}
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			$block_categ_tree = $this->getTree15($result_parents, $result_ids, Configuration::get('CTM_MAXDEPTH'));
		else
			$block_categ_tree = $this->getTree($result_parents, $result_ids, Configuration::get('CTM_MAXDEPTH'));
		$this->context->smarty->assign('currentCategoryId', (int)Tools::getValue('id_category'));
		if (Tools::getValue('id_product'))
		{
			if (!isset($this->context->cookie->last_visited_category) || !Product::idIsOnCategoryId((int)Tools::getValue('id_product'), array('0' => array('id_category' => $this->context->cookie->last_visited_category))))
			{
				$product = new Product((int)Tools::getValue('id_product'));
				if (isset($product) && Validate::isLoadedObject($product))
					$this->context->cookie->last_visited_category = (int)$product->id_category_default;
			}
			$this->context->smarty->assign('currentCategoryId', (int)$this->context->cookie->last_visited_category);
		}
		$this->context->smarty->assign(array(
			'links' => $links,
			'blockCategTree' => $block_categ_tree,
			'ctm_home' => Configuration::get('CTM_HOME'),
			'ctm_specials' => Configuration::get('CTM_SPECIALS'),
			'ctm_news' => Configuration::get('CTM_NEWS')
		));
		$this->context->smarty->assign('branche_tpl_path', _PS_MODULE_DIR_.'categoriestopmenu/views/templates/front/categoriestopmenu-list.tpl');
		return $this->display(__FILE__, 'views/templates/front/categoriestopmenu.tpl');
	}
}